/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.CreateTableOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ConstraintSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class CreateTableStatement
extends DDLStatement {
    private SimpleTableSegment table;
    private SelectStatement selectStatement;
    private boolean ifNotExists;
    private SimpleTableSegment likeTable;
    private CreateTableOptionSegment createTableOption;
    private final Collection<ColumnDefinitionSegment> columnDefinitions = new LinkedList<ColumnDefinitionSegment>();
    private final Collection<ConstraintDefinitionSegment> constraintDefinitions = new LinkedList<ConstraintDefinitionSegment>();
    private final List<ColumnSegment> columns = new LinkedList<ColumnSegment>();
    private SQLStatementAttributes attributes;

    public CreateTableStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<SelectStatement> getSelectStatement() {
        return Optional.ofNullable(this.selectStatement);
    }

    public Optional<SimpleTableSegment> getLikeTable() {
        return Optional.ofNullable(this.likeTable);
    }

    public Optional<CreateTableOptionSegment> getCreateTableOption() {
        return Optional.ofNullable(this.createTableOption);
    }

    @Override
    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(this.getTables()), new CreateTableConstraintSQLStatementAttribute(), new CreateTableIndexSQLStatementAttribute());
    }

    private Collection<SimpleTableSegment> getTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(this.table);
        for (ColumnDefinitionSegment columnDefinitionSegment : this.columnDefinitions) {
            result.addAll(columnDefinitionSegment.getReferencedTables());
        }
        for (ConstraintDefinitionSegment constraintDefinitionSegment : this.constraintDefinitions) {
            if (!constraintDefinitionSegment.getReferencedTable().isPresent()) continue;
            result.add(constraintDefinitionSegment.getReferencedTable().get());
        }
        return result;
    }

    @Generated
    public SimpleTableSegment getTable() {
        return this.table;
    }

    @Generated
    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Generated
    public Collection<ColumnDefinitionSegment> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Generated
    public Collection<ConstraintDefinitionSegment> getConstraintDefinitions() {
        return this.constraintDefinitions;
    }

    @Generated
    public List<ColumnSegment> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setTable(SimpleTableSegment table) {
        this.table = table;
    }

    @Generated
    public void setSelectStatement(SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
    }

    @Generated
    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Generated
    public void setLikeTable(SimpleTableSegment likeTable) {
        this.likeTable = likeTable;
    }

    @Generated
    public void setCreateTableOption(CreateTableOptionSegment createTableOption) {
        this.createTableOption = createTableOption;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }

    private class CreateTableConstraintSQLStatementAttribute
    implements ConstraintSQLStatementAttribute {
        private CreateTableConstraintSQLStatementAttribute() {
        }

        @Override
        public Collection<ConstraintSegment> getConstraints() {
            LinkedList<ConstraintSegment> result = new LinkedList<ConstraintSegment>();
            for (ConstraintDefinitionSegment each : CreateTableStatement.this.constraintDefinitions) {
                each.getConstraintName().ifPresent(result::add);
            }
            return result;
        }
    }

    private class CreateTableIndexSQLStatementAttribute
    implements IndexSQLStatementAttribute {
        private CreateTableIndexSQLStatementAttribute() {
        }

        @Override
        public Collection<IndexSegment> getIndexes() {
            LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
            for (ConstraintDefinitionSegment each : CreateTableStatement.this.constraintDefinitions) {
                each.getIndexName().ifPresent(result::add);
            }
            return result;
        }

        @Override
        public Collection<ColumnSegment> getIndexColumns() {
            return CreateTableStatement.this.constraintDefinitions.stream().flatMap(each -> each.getIndexColumns().stream()).collect(Collectors.toList());
        }
    }
}

