/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.persist.coordinator.process;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.executor.sql.process.yaml.swapper.YamlProcessListSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.global.execution.ProcessNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.process.InstanceProcessNodeValue;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.process.KillProcessTriggerNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.node.compute.process.ShowProcessListTriggerNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class ClusterProcessPersistCoordinator {
    private final PersistRepository repository;
    private final YamlProcessListSwapper swapper = new YamlProcessListSwapper();

    public void reportLocalProcesses(String instanceId, String taskId) {
        Collection processes = ProcessRegistry.getInstance().listAll();
        if (!processes.isEmpty()) {
            this.repository.persist(NodePathGenerator.toPath((NodePath)new ProcessNodePath(taskId, instanceId)), YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(processes)));
        }
        this.repository.delete(NodePathGenerator.toPath((NodePath)new ShowProcessListTriggerNodePath(new InstanceProcessNodeValue(instanceId, taskId))));
    }

    public void cleanProcess(String instanceId, String processId) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new KillProcessTriggerNodePath(new InstanceProcessNodeValue(instanceId, processId))));
    }

    @Generated
    public ClusterProcessPersistCoordinator(PersistRepository repository) {
        this.repository = repository;
    }
}

