/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.state;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global.GlobalDataChangedEventHandler;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.type.DatabaseMetaDataChangedListener;
import org.apache.shardingsphere.mode.manager.cluster.persist.coordinator.database.ClusterDatabaseListenerCoordinatorType;
import org.apache.shardingsphere.mode.manager.cluster.persist.coordinator.database.ClusterDatabaseListenerPersistCoordinator;
import org.apache.shardingsphere.mode.manager.cluster.statistics.StatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.DatabaseMetaDataNodePath;
import org.apache.shardingsphere.mode.node.path.type.global.state.coordinator.database.DatabaseListenerCoordinatorNodePath;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class DatabaseListenerChangedHandler
implements GlobalDataChangedEventHandler {
    @Override
    public NodePath getSubscribedNodePath() {
        return new DatabaseListenerCoordinatorNodePath(null);
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        NodePathSearcher.find((String)event.getKey(), (NodePathSearchCriteria)DatabaseListenerCoordinatorNodePath.createDatabaseSearchCriteria()).ifPresent(optional -> this.handle(contextManager, (String)optional, ClusterDatabaseListenerCoordinatorType.valueOf(event.getValue())));
    }

    private void handle(ContextManager contextManager, String databaseName, ClusterDatabaseListenerCoordinatorType type) {
        ClusterPersistRepository repository = (ClusterPersistRepository)contextManager.getPersistServiceFacade().getRepository();
        String databasePath = NodePathGenerator.toPath((NodePath)new DatabaseMetaDataNodePath(databaseName));
        switch (type) {
            case CREATE: {
                repository.watch(databasePath, (DataChangedEventListener)new DatabaseMetaDataChangedListener(contextManager));
                contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().addDatabase(databaseName);
                break;
            }
            case DROP: {
                repository.removeDataListener(databasePath);
                contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().dropDatabase(databaseName);
                break;
            }
        }
        new ClusterDatabaseListenerPersistCoordinator(repository).delete(databaseName);
        if (InstanceType.PROXY == contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType()) {
            new StatisticsRefreshEngine(contextManager).asyncRefresh();
        }
    }
}

