/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.distsql.statement.CreateBroadcastTableRuleStatement;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class CreateBroadcastTableRuleExecutor
implements DatabaseRuleCreateExecutor<CreateBroadcastTableRuleStatement, BroadcastRule, BroadcastRuleConfiguration> {
    private ShardingSphereDatabase database;
    private BroadcastRule rule;

    public void checkBeforeUpdate(CreateBroadcastTableRuleStatement sqlStatement) {
        ShardingSpherePreconditions.checkNotEmpty((Map)this.database.getResourceMetaData().getStorageUnits(), () -> new EmptyStorageUnitException(this.database.getName()));
        if (!sqlStatement.isIfNotExists()) {
            this.checkDuplicate(sqlStatement);
        }
    }

    private void checkDuplicate(CreateBroadcastTableRuleStatement sqlStatement) {
        ShardingSpherePreconditions.checkMustEmpty(this.getDuplicatedRuleNames(sqlStatement), () -> new DuplicateRuleException("Broadcast", sqlStatement.getTables()));
    }

    private Collection<String> getDuplicatedRuleNames(CreateBroadcastTableRuleStatement sqlStatement) {
        HashSet<String> result = new HashSet<String>(null == this.rule ? Collections.emptySet() : this.rule.getTables());
        result.retainAll(sqlStatement.getTables());
        return result;
    }

    public BroadcastRuleConfiguration buildToBeCreatedRuleConfiguration(CreateBroadcastTableRuleStatement sqlStatement) {
        BroadcastRuleConfiguration result = new BroadcastRuleConfiguration(new HashSet(null == this.rule ? Collections.emptySet() : this.rule.getTables()));
        result.getTables().addAll(this.getToBeCreatedRuleNames(sqlStatement));
        return result;
    }

    private Collection<String> getToBeCreatedRuleNames(CreateBroadcastTableRuleStatement sqlStatement) {
        Collection result = sqlStatement.getTables();
        if (sqlStatement.isIfNotExists()) {
            result.removeIf(this.getDuplicatedRuleNames(sqlStatement)::contains);
        }
        return result;
    }

    public Class<BroadcastRule> getRuleClass() {
        return BroadcastRule.class;
    }

    public Class<CreateBroadcastTableRuleStatement> getType() {
        return CreateBroadcastTableRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(BroadcastRule rule) {
        this.rule = rule;
    }
}

