/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.DatabaseStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.SchemaStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlRowStatistics;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlRowStatisticsSwapper;
import org.apache.shardingsphere.mode.metadata.persist.metadata.service.TableRowDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.statistics.AlteredDatabaseStatistics;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsDatabaseNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsSchemaNodePath;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsTableNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class StatisticsPersistService {
    private final PersistRepository repository;
    private final TableRowDataPersistService tableRowDataPersistService;

    public StatisticsPersistService(PersistRepository repository) {
        this.repository = repository;
        this.tableRowDataPersistService = new TableRowDataPersistService(repository);
    }

    public ShardingSphereStatistics load(ShardingSphereMetaData metaData) {
        List databaseNames = this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new StatisticsDatabaseNodePath(null)));
        if (databaseNames.isEmpty()) {
            return new ShardingSphereStatistics();
        }
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        for (String each : databaseNames.stream().filter(arg_0 -> ((ShardingSphereMetaData)metaData).containsDatabase(arg_0)).collect(Collectors.toList())) {
            result.putDatabaseStatistics(each, this.load(metaData.getDatabase(each)));
        }
        return result;
    }

    private DatabaseStatistics load(ShardingSphereDatabase database) {
        DatabaseStatistics result = new DatabaseStatistics();
        for (String each : this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new StatisticsSchemaNodePath(database.getName(), null))).stream().filter(arg_0 -> ((ShardingSphereDatabase)database).containsSchema(arg_0)).collect(Collectors.toList())) {
            result.putSchemaStatistics(each, this.load(database.getName(), database.getSchema(each)));
        }
        return result;
    }

    private SchemaStatistics load(String databaseName, ShardingSphereSchema schema) {
        SchemaStatistics result = new SchemaStatistics();
        for (String each : this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new StatisticsTableNodePath(databaseName, schema.getName(), null))).stream().filter(arg_0 -> ((ShardingSphereSchema)schema).containsTable(arg_0)).collect(Collectors.toList())) {
            result.putTableStatistics(each, this.tableRowDataPersistService.load(databaseName, schema.getName(), schema.getTable(each)));
        }
        return result;
    }

    public void persist(ShardingSphereDatabase database, String schemaName, SchemaStatistics schemaStatistics) {
        if (schemaStatistics.getTableStatisticsMap().isEmpty()) {
            this.persistSchema(database.getName(), schemaName);
        }
        this.persistTableData(database, schemaName, schemaStatistics);
    }

    private void persistSchema(String databaseName, String schemaName) {
        this.repository.persist(NodePathGenerator.toPath((NodePath)new StatisticsSchemaNodePath(databaseName, schemaName)), "");
    }

    private void persistTableData(ShardingSphereDatabase database, String schemaName, SchemaStatistics schemaStatistics) {
        schemaStatistics.getTableStatisticsMap().values().forEach(each -> {
            List columns = database.getSchema(schemaName).containsTable(each.getName()) ? database.getSchema(schemaName).getTable(each.getName()).getAllColumns() : Collections.emptyList();
            YamlRowStatisticsSwapper swapper = new YamlRowStatisticsSwapper(new ArrayList(columns));
            this.persistTableData(database.getName(), schemaName, each.getName(), columns.isEmpty() ? Collections.emptyList() : (Collection)each.getRows().stream().map(arg_0 -> ((YamlRowStatisticsSwapper)swapper).swapToYamlConfiguration(arg_0)).collect(Collectors.toList()));
        });
    }

    private void persistTableData(String databaseName, String schemaName, String tableName, Collection<YamlRowStatistics> rows) {
        this.tableRowDataPersistService.persist(databaseName, schemaName, tableName, rows);
    }

    public void update(AlteredDatabaseStatistics alteredDatabaseStatistics) {
        this.tableRowDataPersistService.persist(alteredDatabaseStatistics.getDatabaseName(), alteredDatabaseStatistics.getSchemaName(), alteredDatabaseStatistics.getTableName(), alteredDatabaseStatistics.getAddedRows());
        this.tableRowDataPersistService.persist(alteredDatabaseStatistics.getDatabaseName(), alteredDatabaseStatistics.getSchemaName(), alteredDatabaseStatistics.getTableName(), alteredDatabaseStatistics.getUpdatedRows());
        this.tableRowDataPersistService.delete(alteredDatabaseStatistics.getDatabaseName(), alteredDatabaseStatistics.getSchemaName(), alteredDatabaseStatistics.getTableName(), alteredDatabaseStatistics.getDeletedRows());
    }

    public void delete(String databaseName) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new StatisticsDatabaseNodePath(databaseName)));
    }
}

