/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.firebird.visitor.statement.type;

import java.util.Collections;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.FirebirdStatementParser;
import org.apache.shardingsphere.sql.parser.engine.firebird.visitor.statement.FirebirdStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CommentStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.ExecuteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.collation.CreateCollationStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.domain.AlterDomainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.domain.CreateDomainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.AlterSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.sequence.CreateSequenceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.AlterTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.CreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class FirebirdDDLStatementVisitor
extends FirebirdStatementVisitor
implements DDLStatementVisitor {
    public FirebirdDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCreateTable(FirebirdStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(FirebirdStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (FirebirdStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null != each.constraintDefinition()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.constraintDefinition()));
            }
            if (null == each.checkConstraintDefinition()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.checkConstraintDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(FirebirdStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.dataTypeOption().stream().anyMatch(each -> null != each.primaryKey());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey, false, this.getText(ctx));
        for (FirebirdStatementParser.DataTypeOptionContext each2 : ctx.dataTypeOption()) {
            if (null == each2.referenceDefinition()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each2.referenceDefinition().tableName()));
        }
        return result;
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitCheckConstraintDefinition(FirebirdStatementParser.CheckConstraintDefinitionContext ctx) {
        return new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitAddConstraintSpecification(FirebirdStatementParser.AddConstraintSpecificationContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.constraintDefinition()));
    }

    @Override
    public ASTNode visitDropConstraintSpecification(FirebirdStatementParser.DropConstraintSpecificationContext ctx) {
        return new DropConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintDefinition().constraintName()));
    }

    @Override
    public ASTNode visitConstraintDefinition(FirebirdStatementParser.ConstraintDefinitionContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
        }
        if (null != ctx.primaryKeyOption()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.primaryKeyOption().columnNames())).getValue());
        }
        if (null != ctx.foreignKeyOption()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.foreignKeyOption().referenceDefinition().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitConstraintName(FirebirdStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitAlterTable(FirebirdStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof AddConstraintDefinitionSegment) {
                    result.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof DropConstraintDefinitionSegment)) continue;
                result.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDomain(FirebirdStatementParser.AlterDomainContext ctx) {
        return new AlterDomainStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterDefinitionClause(FirebirdStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.addColumnSpecification()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification()));
        }
        if (null != ctx.dropColumnSpecification()) {
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.dropColumnSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(FirebirdStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(ctx.columnDefinition().getStart().getStartIndex(), ctx.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition())));
        result.getValue().add(addColumnDefinition);
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(FirebirdStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.modifyColumn().columnName());
        DataTypeSegment dataType = null == ctx.dataType() ? null : (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false, false, this.getText(ctx));
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(FirebirdStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singleton((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitDropTable(FirebirdStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateFunction(FirebirdStatementParser.CreateFunctionContext ctx) {
        return new CreateFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateProcedure(FirebirdStatementParser.CreateProcedureContext ctx) {
        return new CreateProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterProcedure(FirebirdStatementParser.AlterProcedureContext ctx) {
        return new AlterProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterSequence(FirebirdStatementParser.AlterSequenceContext ctx) {
        return new AlterSequenceStatement(this.getDatabaseType(), ((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())).getTableName().getIdentifier().getValue());
    }

    @Override
    public ASTNode visitCreateCollation(FirebirdStatementParser.CreateCollationContext ctx) {
        return new CreateCollationStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateDomain(FirebirdStatementParser.CreateDomainContext ctx) {
        return new CreateDomainStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTrigger(FirebirdStatementParser.AlterTriggerContext ctx) {
        return new AlterTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTrigger(FirebirdStatementParser.CreateTriggerContext ctx) {
        return new CreateTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateSequence(FirebirdStatementParser.CreateSequenceContext ctx) {
        return new CreateSequenceStatement(this.getDatabaseType(), ((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())).getTableName().getIdentifier().getValue());
    }

    @Override
    public ASTNode visitExecuteStmt(FirebirdStatementParser.ExecuteStmtContext ctx) {
        return new ExecuteStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitComment(FirebirdStatementParser.CommentContext ctx) {
        CommentStatement result = new CommentStatement(this.getDatabaseType());
        if (null != ctx.tableName()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        }
        if (null != ctx.columnName()) {
            result.setColumn((ColumnSegment)this.visit((ParseTree)ctx.columnName()));
        }
        return result;
    }
}

