/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.engine.segment.ddl.column.ColumnDefinitionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class CreateTableStatementBinder
implements SQLStatementBinder<CreateTableStatement> {
    @Override
    public CreateTableStatement bind(CreateTableStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        SimpleTableSegment boundTable = SimpleTableSegmentBinder.bind(sqlStatement.getTable(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
        SelectStatement boundSelectStatement = sqlStatement.getSelectStatement().map(optional -> new SelectStatementBinder().bind((SelectStatement)optional, binderContext)).orElse(null);
        Collection boundColumnDefinitions = sqlStatement.getColumnDefinitions().stream().map(arg_0 -> CreateTableStatementBinder.lambda$bind$1(binderContext, (Multimap)tableBinderContexts, arg_0)).collect(Collectors.toList());
        return this.copy(sqlStatement, boundTable, boundSelectStatement, boundColumnDefinitions);
    }

    private CreateTableStatement copy(CreateTableStatement sqlStatement, SimpleTableSegment boundTable, SelectStatement boundSelectStatement, Collection<ColumnDefinitionSegment> boundColumnDefinitions) {
        CreateTableStatement result = new CreateTableStatement(sqlStatement.getDatabaseType());
        result.setTable(boundTable);
        result.setSelectStatement(boundSelectStatement);
        result.getColumnDefinitions().addAll(boundColumnDefinitions);
        result.getConstraintDefinitions().addAll(sqlStatement.getConstraintDefinitions());
        result.setIfNotExists(sqlStatement.isIfNotExists());
        result.getColumns().addAll(sqlStatement.getColumns());
        sqlStatement.getLikeTable().ifPresent(arg_0 -> ((CreateTableStatement)result).setLikeTable(arg_0));
        sqlStatement.getCreateTableOption().ifPresent(arg_0 -> ((CreateTableStatement)result).setCreateTableOption(arg_0));
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }

    private static /* synthetic */ ColumnDefinitionSegment lambda$bind$1(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, ColumnDefinitionSegment each) {
        return ColumnDefinitionSegmentBinder.bind(each, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
    }
}

