/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;

public class SQLStatement
implements ASTNode {
    private final Collection<Integer> uniqueParameterIndexes = new LinkedHashSet<Integer>();
    private final Collection<ParameterMarkerSegment> parameterMarkers = new LinkedHashSet<ParameterMarkerSegment>();
    private final Collection<String> variableNames = new CaseInsensitiveSet();
    private final Collection<CommentSegment> comments = new LinkedList<CommentSegment>();
    private final DatabaseType databaseType;
    private SQLStatementAttributes attributes;

    public final int getParameterCount() {
        return this.uniqueParameterIndexes.size();
    }

    public final void addParameterMarkers(Collection<ParameterMarkerSegment> segments) {
        for (ParameterMarkerSegment each : segments) {
            this.parameterMarkers.add(each);
            this.uniqueParameterIndexes.add(each.getParameterIndex());
        }
    }

    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new SQLStatementAttribute[0]);
    }

    public SQLStatementAttributes getAttributes() {
        if (null == this.attributes) {
            this.buildAttributes();
        }
        return this.attributes;
    }

    @Generated
    public SQLStatement(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    public Collection<Integer> getUniqueParameterIndexes() {
        return this.uniqueParameterIndexes;
    }

    @Generated
    public Collection<ParameterMarkerSegment> getParameterMarkers() {
        return this.parameterMarkers;
    }

    @Generated
    public Collection<String> getVariableNames() {
        return this.variableNames;
    }

    @Generated
    public Collection<CommentSegment> getComments() {
        return this.comments;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

