/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import lombok.Generated;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActiveVersionChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActiveVersionChecker.class);
    private final PersistRepository repository;

    public boolean checkSame(DataChangedEvent event) {
        return this.checkSame(event.getValue(), event.getKey());
    }

    public boolean checkSame(VersionNodePath versionNodePath, int currentVersion) {
        return this.checkSame(String.valueOf(currentVersion), versionNodePath.getActiveVersionPath());
    }

    private boolean checkSame(String currentVersion, String activeVersionPath) {
        if (currentVersion.equals(this.repository.query(activeVersionPath))) {
            return true;
        }
        log.warn("Invalid active version `{}` of key `{}`", (Object)currentVersion, (Object)activeVersionPath);
        return false;
    }

    @Generated
    public ActiveVersionChecker(PersistRepository repository) {
        this.repository = repository;
    }
}

