/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.type;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.exception.UnsupportedStorageTypeException;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DatabaseTypeFactory {
    public static DatabaseType get(String url) {
        Collection databaseTypes = ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class).stream().filter(each -> DatabaseTypeFactory.matchURLs(url, each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkNotEmpty((Collection)databaseTypes, () -> new UnsupportedStorageTypeException(url));
        for (DatabaseType each2 : databaseTypes) {
            if (each2.getTrunkDatabaseType().isPresent()) continue;
            return each2;
        }
        return (DatabaseType)databaseTypes.iterator().next();
    }

    public static DatabaseType get(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDatabaseProductName().contains("Hive") ? (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"Hive") : DatabaseTypeFactory.get(metaData.getURL());
    }

    private static boolean matchURLs(String url, DatabaseType databaseType) {
        return databaseType.getJdbcUrlPrefixes().stream().anyMatch(url::startsWith);
    }

    @Generated
    private DatabaseTypeFactory() {
    }
}

