/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.database.system;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.DialectSystemDatabase;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;

public final class SystemDatabase {
    private final DatabaseType databaseType;

    public Collection<String> getSystemDatabases() {
        return DatabaseTypedSPILoader.findService(DialectSystemDatabase.class, this.databaseType).map(DialectSystemDatabase::getSystemDatabases).orElse(Collections.emptyList());
    }

    public Collection<String> getSystemSchemas(String databaseName) {
        return DatabaseTypedSPILoader.findService(DialectSystemDatabase.class, this.databaseType).map(optional -> optional.getSystemSchemas(databaseName)).orElse(Collections.emptyList());
    }

    public Collection<String> getSystemSchemas() {
        return DatabaseTypedSPILoader.findService(DialectSystemDatabase.class, this.databaseType).map(DialectSystemDatabase::getSystemSchemas).orElse(Collections.emptyList());
    }

    @Generated
    public SystemDatabase(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

