/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.data.loader.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.ColumnMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColumnMetaDataLoader.class);
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String IS_NULLABLE = "IS_NULLABLE";

    public static Collection<ColumnMetaData> load(Connection connection, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = ColumnMetaDataLoader.loadPrimaryKeys(connection, tableNamePattern);
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        ArrayList<Boolean> primaryKeyFlags = new ArrayList<Boolean>();
        ArrayList<Boolean> caseSensitiveFlags = new ArrayList<Boolean>();
        ArrayList<Boolean> nullableFlags = new ArrayList<Boolean>();
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), tableNamePattern, "%");){
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME);
                if (!Objects.equals(tableNamePattern, tableName)) continue;
                String columnName = resultSet.getString(COLUMN_NAME);
                columnTypes.add(resultSet.getInt(DATA_TYPE));
                primaryKeyFlags.add(primaryKeys.contains(columnName));
                nullableFlags.add("YES".equals(resultSet.getString(IS_NULLABLE)));
                columnNames.add(columnName);
            }
        }
        String emptyResultSQL = ColumnMetaDataLoader.generateEmptyResultSQL(tableNamePattern, columnNames, databaseType);
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(emptyResultSQL);){
            for (int i = 0; i < columnNames.size(); ++i) {
                boolean generated = resultSet.getMetaData().isAutoIncrement(i + 1);
                caseSensitiveFlags.add(resultSet.getMetaData().isCaseSensitive(resultSet.findColumn((String)columnNames.get(i))));
                result.add(new ColumnMetaData((String)columnNames.get(i), (Integer)columnTypes.get(i), (Boolean)primaryKeyFlags.get(i), generated, (Boolean)caseSensitiveFlags.get(i), true, false, (Boolean)nullableFlags.get(i)));
            }
        }
        catch (SQLException ex) {
            log.error("Error occurred while loading column meta data, SQL: {}", (Object)emptyResultSQL, (Object)ex);
            throw ex;
        }
        return result;
    }

    private static String generateEmptyResultSQL(String table, List<String> columnNames, DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        String wrappedColumnNames = columnNames.stream().map(each -> dialectDatabaseMetaData.getQuoteCharacter().wrap((String)each)).collect(Collectors.joining(","));
        return String.format("SELECT %s FROM %s WHERE 1 != 1", wrappedColumnNames, dialectDatabaseMetaData.getQuoteCharacter().wrap(table));
    }

    private static Collection<String> loadPrimaryKeys(Connection connection, String table) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), connection.getSchema(), table);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    @Generated
    private ColumnMetaDataLoader() {
    }
}

