/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.rule;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseLeafValueChangedHandler;
import org.apache.shardingsphere.mode.metadata.changed.RuleItemChangedNodePathBuilder;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.rule.DatabaseRuleNodePath;

public abstract class RuleItemConfigurationChangedHandler
implements DatabaseLeafValueChangedHandler {
    private final ContextManager contextManager;
    private final RuleItemChangedNodePathBuilder ruleItemChangedNodePathBuilder = new RuleItemChangedNodePathBuilder();

    @Override
    public final void handle(String databaseName, DataChangedEvent event) {
        Optional databaseRuleNodePath = this.ruleItemChangedNodePathBuilder.build(databaseName, event.getKey(), event.getType());
        if (!databaseRuleNodePath.isPresent()) {
            return;
        }
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                this.contextManager.getMetaDataContextManager().getDatabaseRuleItemManager().alter((DatabaseRuleNodePath)databaseRuleNodePath.get());
                break;
            }
            case DELETED: {
                this.contextManager.getMetaDataContextManager().getDatabaseRuleItemManager().drop((DatabaseRuleNodePath)databaseRuleNodePath.get());
                break;
            }
        }
    }

    @Generated
    public RuleItemConfigurationChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

