/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IMetadataDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

public abstract class MetadataDefinitionBase
extends DefinitionBase
implements IMetadataDefinition {
    private IDefinition decoratedDefinition;
    private final String tagName;
    private IMetaTagAttribute[] attributes;

    public MetadataDefinitionBase(String name, String tagName, IClassDefinition decoratedDefinition) {
        super(name);
        this.decoratedDefinition = decoratedDefinition;
        this.setNamespaceReference(NamespaceDefinition.getPublicNamespaceDefinition());
        this.tagName = tagName;
    }

    @Override
    public IDefinition getDecoratedDefinition() {
        return this.decoratedDefinition;
    }

    public IMetaTagsNode getTagNode() {
        return null;
    }

    @Override
    public int getStart() {
        return 0;
    }

    @Override
    public int getEnd() {
        return 0;
    }

    public IDefinitionNode getDecoratedDefinitionNode() {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public IMetaTagAttribute[] getAttributes() {
        return this.attributes;
    }

    void setAttributes(IMetaTagAttribute[] attributes) {
        this.attributes = attributes;
    }

    public String getAttributeValue(String key) {
        if (this.attributes != null) {
            for (IMetaTagAttribute attribute : this.attributes) {
                if (!attribute.getKey().equals(key)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    @Override
    public boolean matches(DefinitionBase definition) {
        if (this == definition) {
            return true;
        }
        if (this.getClass() != definition.getClass()) {
            return false;
        }
        assert (definition instanceof MetadataDefinitionBase);
        MetadataDefinitionBase other = (MetadataDefinitionBase)definition;
        assert (this.tagName.equals(other.tagName));
        if (!this.getBaseName().equals(other.getBaseName())) {
            return false;
        }
        assert (this.decoratedDefinition instanceof DefinitionBase);
        assert (other.decoratedDefinition instanceof DefinitionBase);
        if (!((DefinitionBase)this.decoratedDefinition).matches((DefinitionBase)other.decoratedDefinition)) {
            return false;
        }
        return super.matches(definition);
    }

    @Override
    public String getDeprecatedSince() {
        return this.getAttributeValue("deprecatedSince");
    }

    @Override
    public String getDeprecatedReplacement() {
        return this.getAttributeValue("deprecatedReplacement");
    }

    @Override
    public String getDeprecatedMessage() {
        return this.getAttributeValue("deprecatedMessage");
    }
}

