/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

public final class Label
implements Comparable<Label>,
Cloneable {
    public static final int NO_POSITION = -1;
    private String labelText;
    private LabelKind mustTargetExecutable;
    private int instructionPosition = -1;

    public Label(String label_text) {
        this(label_text, LabelKind.EXECUTABLE_INSTRUCTION);
    }

    public Label(String label_text, LabelKind mustTargetExectuable) {
        this.labelText = label_text;
        this.mustTargetExecutable = mustTargetExectuable;
    }

    public Label() {
        this.labelText = null;
    }

    private Label(Label src) {
        this.instructionPosition = src.instructionPosition;
        this.labelText = src.labelText;
    }

    @Override
    public int compareTo(Label o) {
        return this.instructionPosition - o.instructionPosition;
    }

    public String toString() {
        return this.labelText != null ? this.labelText : super.toString() + " => " + this.instructionPosition;
    }

    public void setPosition(int pos) {
        assert (this.instructionPosition == -1) : "setPostition() after a position set: " + this.toString();
        this.instructionPosition = pos;
    }

    public int getPosition() {
        return this.instructionPosition;
    }

    public void adjustOffset(int base_offset) {
        assert (this.instructionPosition != -1) : "adjustOffset() before any position set";
        this.instructionPosition += base_offset;
    }

    public Object clone() {
        return new Label(this);
    }

    public boolean targetMustBeExecutable() {
        return this.mustTargetExecutable == LabelKind.EXECUTABLE_INSTRUCTION;
    }

    public static enum LabelKind {
        EXECUTABLE_INSTRUCTION,
        ANY_INSTRUCTION;

    }
}

