/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBlockNode;
import org.apache.royale.compiler.tree.as.IConditionalNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IStatementNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MaxBlockDepthRule
extends LinterRule {
    public int maximum = 4;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        int maxBlockDepth = this.getMaxDepth((IASNode)functionNode.getScopedNode());
        if (maxBlockDepth <= this.maximum) {
            return;
        }
        problems.add(new MaxBlockDepthLinterProblem(functionNode, maxBlockDepth, this.maximum));
    }

    private int getMaxDepth(IASNode node) {
        int maxDepth = 0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            int childMaxDepth;
            IASNode child = node.getChild(i);
            if (child instanceof IFunctionNode) continue;
            if (child instanceof IStatementNode) {
                int childMaxDepth2;
                IConditionalNode conditionalNode;
                IStatementNode statementNode = (IStatementNode)child;
                IASNode possibleBlock = null;
                if (statementNode.getChildCount() > 0 && (possibleBlock = statementNode.getChild(statementNode.getChildCount() - 1)) instanceof IConditionalNode && (conditionalNode = (IConditionalNode)possibleBlock).getChildCount() > 0) {
                    possibleBlock = conditionalNode.getChild(conditionalNode.getChildCount() - 1);
                }
                if (!(possibleBlock instanceof IBlockNode) || maxDepth >= (childMaxDepth2 = this.getMaxDepth(possibleBlock) + 1)) continue;
                maxDepth = childMaxDepth2;
                continue;
            }
            if (!(child instanceof IBlockNode) || maxDepth >= (childMaxDepth = this.getMaxDepth(child) + 1)) continue;
            maxDepth = childMaxDepth;
        }
        return maxDepth;
    }

    public static class MaxBlockDepthLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Function '${functionName}' has blocks nested ${depth} levels deep, but expected no deeper than ${maxDepth} levels";
        public String functionName;
        public int depth;
        public int maxDepth;

        public MaxBlockDepthLinterProblem(IFunctionNode node, int depth, int maxDepth) {
            super((ISourceLocation)node.getParametersContainerNode());
            this.depth = depth;
            this.maxDepth = maxDepth;
            this.functionName = node.getName();
        }
    }
}

