/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.player;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class TrustFile {
    public static final String TRUST_FILENAME = "royaleUnit.cfg";
    private File trustDirectory;
    private File trustFile;
    private List<String> paths;

    public TrustFile(Project project, File userTrustDirectory, File globaTrustDirectory) {
        File file = this.trustDirectory = userTrustDirectory != null ? userTrustDirectory : globaTrustDirectory;
        if (!this.trustDirectory.exists()) {
            try {
                this.trustDirectory.mkdirs();
            }
            catch (Exception e) {
                throw new BuildException("Could not create Flash Player trust directory at [" + this.trustDirectory.getAbsolutePath() + "]; permission denied.");
            }
        }
        this.trustFile = project.resolveFile(this.trustDirectory.getAbsolutePath() + "/royaleUnit.cfg");
        this.paths = this.read();
    }

    private List<String> read() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.trustFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.trustFile));
                String path = null;
                while ((path = reader.readLine()) != null) {
                    paths.add(path);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return paths;
    }

    public void add(String url) {
        String path = new File(url).getParentFile().getAbsolutePath();
        this.addPath(path);
    }

    public void add(File swf) {
        String path = swf.getParentFile().getAbsolutePath();
        this.addPath(path);
    }

    private void addPath(String path) {
        if (!this.trustDirectory.exists()) {
            this.trustDirectory.mkdir();
        }
        if (!this.paths.contains(path)) {
            this.paths.add(path);
            this.write();
            LoggingUtil.log("Updated local trust file at [" + this.trustFile.getAbsolutePath() + "], added [" + path + "].");
        } else {
            LoggingUtil.log("Entry [" + path + "] already available in local trust file at [" + this.trustFile.getAbsolutePath() + "].");
        }
    }

    private void write() {
        try {
            FileWriter writer = new FileWriter(this.trustFile, false);
            for (String path : this.paths) {
                writer.write(path + System.getProperty("line.separator"));
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(String url) {
        String path = new File(url).getParentFile().getAbsolutePath();
        this.removePath(path);
    }

    public void remove(File swf) {
        String path = swf.getParentFile().getAbsolutePath();
        this.removePath(path);
    }

    public void removePath(String path) {
        if (this.paths.contains(path)) {
            this.paths.remove(path);
            this.write();
            LoggingUtil.log("Updated local trust file at [" + this.trustFile.getAbsolutePath() + "], removed [" + path + "].");
        }
    }
}

