/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;

public class BootstrapMainStarter {
    public void start(String[] args, Path mavenHome) throws Exception {
        Path mavenJar = this.findLauncherJar(mavenHome);
        URLClassLoader contextClassLoader = new URLClassLoader(new URL[]{mavenJar.toUri().toURL()}, ClassLoader.getSystemClassLoader().getParent());
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        Class<?> mainClass = contextClassLoader.loadClass("org.codehaus.plexus.classworlds.launcher.Launcher");
        System.setProperty("maven.home", mavenHome.toAbsolutePath().toString());
        System.setProperty("classworlds.conf", mavenHome.resolve("bin/m2.conf").toAbsolutePath().toString());
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{args});
    }

    private Path findLauncherJar(Path mavenHome) throws IOException {
        Path mavenBoot = mavenHome.resolve("boot");
        if (Files.isDirectory(mavenBoot, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(mavenBoot, "plexus-classworlds-*.jar");){
                Iterator<Path> iterator = ds.iterator();
                if (iterator.hasNext()) {
                    Path path = iterator.next();
                    return path;
                }
            }
        }
        throw new FileNotFoundException(String.format(Locale.ROOT, "Could not locate the Maven launcher JAR in Maven distribution '%s'.", mavenHome));
    }
}

