/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFunctionNode;

public class MXMLFunctionNode
extends MXMLExpressionNodeBase
implements IMXMLFunctionNode {
    private static final Object DEFAULT = null;

    MXMLFunctionNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLFunctionID;
    }

    @Override
    public String getName() {
        return "Function";
    }

    @Override
    public IFunctionDefinition getValue(ICompilerProject project) {
        IDefinition d;
        assert (this.getExpressionNode() instanceof IExpressionNode) : "getValue() shouldn't be getting called on a non-expression MXMLFunctionNode";
        IExpressionNode expressionNode = (IExpressionNode)this.getExpressionNode();
        if (expressionNode != null && (d = expressionNode.resolve(project)) instanceof IFunctionDefinition) {
            return (IFunctionDefinition)d;
        }
        return null;
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.FUNCTION;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.parseExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        ITypeDefinition functionType = builder.getBuiltinType("Function");
        this.checkExpressionType(builder, functionType);
        super.initializationComplete(builder, tag, info);
    }
}

