/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessClosurePrimitivesWithModuleSupport;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ShadowVariablesWithModuleSupport;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;

final class RenameVarsWithModuleSupport
implements CompilerPass {
    private static final int MAX_LOCALS_IN_SCOPE_TO_TEMP_RENAME = 1000;
    private final AbstractCompiler compiler;
    private final ArrayList<Node> globalNameNodes = new ArrayList();
    private final ArrayList<Node> localNameNodes = new ArrayList();
    private final Map<Node, String> originalNameByNode = new HashMap<Node, String>();
    private final Map<Node, String> pseudoNameMap;
    private Set<String> externNames;
    private final Set<String> reservedNames;
    private final Map<String, String> renameMap = new HashMap<String, String>();
    private final VariableMap prevUsedRenameMap;
    private final String prefix;
    private int assignmentCount = 0;
    private final Set<Var> localBleedingFunctions = new HashSet<Var>();
    private final ListMultimap<Scope, Var> localBleedingFunctionsPerScope = ArrayListMultimap.create();
    private final Map<String, Assignment> assignments = new HashMap<String, Assignment>();
    private final boolean localRenamingOnly;
    private final boolean preserveFunctionExpressionNames;
    private final boolean shouldShadow;
    private final boolean preferStableNames;
    private final char[] reservedCharacters;
    private static final String LOCAL_VAR_PREFIX = "L ";
    private final NameGenerator nameGenerator;
    private List<String> externAliases;
    private static final Comparator<Assignment> FREQUENCY_COMPARATOR = new Comparator<Assignment>(){

        @Override
        public int compare(Assignment a1, Assignment a2) {
            if (a1.count != a2.count) {
                return a2.count - a1.count;
            }
            return ORDER_OF_OCCURRENCE_COMPARATOR.compare(a1, a2);
        }
    };
    private static final Comparator<Assignment> ORDER_OF_OCCURRENCE_COMPARATOR = new Comparator<Assignment>(){

        @Override
        public int compare(Assignment a1, Assignment a2) {
            return a1.orderOfOccurrence - a2.orderOfOccurrence;
        }
    };

    RenameVarsWithModuleSupport(AbstractCompiler compiler, String prefix, boolean localRenamingOnly, boolean preserveFunctionExpressionNames, boolean generatePseudoNames, boolean shouldShadow, boolean preferStableNames, VariableMap prevUsedRenameMap, @Nullable char[] reservedCharacters, @Nullable Set<String> reservedNames, NameGenerator nameGenerator) {
        this.compiler = compiler;
        this.prefix = Strings.nullToEmpty(prefix);
        this.localRenamingOnly = localRenamingOnly;
        this.preserveFunctionExpressionNames = preserveFunctionExpressionNames;
        this.pseudoNameMap = generatePseudoNames ? new HashMap<Node, String>() : null;
        this.prevUsedRenameMap = prevUsedRenameMap;
        this.reservedCharacters = reservedCharacters;
        this.shouldShadow = shouldShadow;
        this.preferStableNames = preferStableNames;
        this.reservedNames = reservedNames == null ? new HashSet<String>() : new HashSet<String>(reservedNames);
        this.nameGenerator = nameGenerator;
    }

    public void process(Node externs, Node root) {
        this.externAliases = ProcessClosurePrimitivesWithModuleSupport.externedAliases.get(externs);
        this.externNames = NodeUtil.collectExternVariableNames((AbstractCompiler)this.compiler, (Node)externs);
        this.originalNameByNode.clear();
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)root, (NodeTraversal.Callback)new ProcessVars());
        this.reservedNames.addAll(this.externNames);
        TreeSet<Assignment> varsByFrequency = new TreeSet<Assignment>(FREQUENCY_COMPARATOR);
        varsByFrequency.addAll(this.assignments.values());
        if (this.shouldShadow) {
            new ShadowVariablesWithModuleSupport(this.compiler, this.assignments, varsByFrequency, this.pseudoNameMap).process(externs, root);
        }
        if (this.prevUsedRenameMap != null) {
            this.reusePreviouslyUsedVariableMap(varsByFrequency);
        }
        if (this.prevUsedRenameMap != null) {
            this.reservedNames.addAll(this.prevUsedRenameMap.getNewNameToOriginalNameMap().keySet());
        }
        this.assignNames(varsByFrequency);
        for (Node n : this.globalNameNodes) {
            boolean moveToExternsAfterRename = false;
            String renamedVar = n.getString();
            if (this.prevUsedRenameMap != null && this.externAliases.contains(renamedVar) && n.getParent().isVar()) {
                moveToExternsAfterRename = true;
            }
            this.setNameAndReport(n, this.getNewGlobalName(n));
            if (!moveToExternsAfterRename) continue;
            Node p = n.getParent();
            p.detach();
            Node externsInput = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
            externsInput.addChildToBack(p);
            this.compiler.reportChangeToEnclosingScope(p);
        }
        for (Node n : this.localNameNodes) {
            this.setNameAndReport(n, this.getNewLocalName(n));
        }
    }

    private void setNameAndReport(Node n, @Nullable String newName) {
        if (newName != null && !newName.equals(n.getString())) {
            n.setString(newName);
            if (!newName.equals(this.originalNameByNode.get(n))) {
                this.compiler.reportChangeToEnclosingScope(n);
                Node parent = n.getParent();
                if (parent.isFunction() && NodeUtil.isFunctionDeclaration((Node)parent)) {
                    this.compiler.reportChangeToEnclosingScope(parent);
                }
            }
        }
    }

    @Nullable
    private String getNewGlobalName(Node n) {
        String oldName = n.getString();
        Assignment a = this.assignments.get(oldName);
        if (a.newName != null && !a.newName.equals(oldName)) {
            if (this.pseudoNameMap != null) {
                return this.pseudoNameMap.get(n);
            }
            return a.newName;
        }
        return null;
    }

    @Nullable
    private String getNewLocalName(Node n) {
        String oldTempName = n.getString();
        Assignment a = this.assignments.get(oldTempName);
        if (!a.newName.equals(oldTempName)) {
            if (this.pseudoNameMap != null) {
                return this.pseudoNameMap.get(n);
            }
            return a.newName;
        }
        return null;
    }

    private void recordPseudoName(Node n) {
        this.pseudoNameMap.put(n, "$" + n.getString() + "$$");
    }

    private void reusePreviouslyUsedVariableMap(SortedSet<Assignment> varsToRename) {
        Preconditions.checkNotNull(this.prevUsedRenameMap.getNewNameToOriginalNameMap());
        for (Assignment a : varsToRename) {
            String prevNewName = this.prevUsedRenameMap.lookupNewName(a.oldName);
            if (prevNewName == null || this.reservedNames.contains(prevNewName) || !a.isLocal && (this.externNames.contains(a.oldName) || !prevNewName.startsWith(this.prefix))) continue;
            this.reservedNames.add(prevNewName);
            this.finalizeNameAssignment(a, prevNewName);
        }
    }

    private void assignNames(SortedSet<Assignment> varsToRename) {
        NameGenerator globalNameGenerator = null;
        NameGenerator localNameGenerator = null;
        globalNameGenerator = this.nameGenerator;
        this.nameGenerator.reset(this.reservedNames, this.prefix, this.reservedCharacters);
        localNameGenerator = this.prefix.isEmpty() ? globalNameGenerator : this.nameGenerator.clone(this.reservedNames, "", this.reservedCharacters);
        ArrayList<Assignment> pendingAssignments = new ArrayList<Assignment>();
        ArrayList<String> generatedNamesForAssignments = new ArrayList<String>();
        for (Assignment a : varsToRename) {
            String newName;
            if (a.newName != null || this.externNames.contains(a.oldName)) continue;
            if (a.isLocal) {
                newName = localNameGenerator.generateNextName();
                this.finalizeNameAssignment(a, newName);
            } else {
                newName = globalNameGenerator.generateNextName();
                pendingAssignments.add(a);
                generatedNamesForAssignments.add(newName);
            }
            this.reservedNames.add(newName);
        }
        int numPendingAssignments = generatedNamesForAssignments.size();
        int i = 0;
        while (i < numPendingAssignments) {
            TreeSet<Assignment> varsByOrderOfOccurrence = new TreeSet<Assignment>(ORDER_OF_OCCURRENCE_COMPARATOR);
            int len = ((String)generatedNamesForAssignments.get(i)).length();
            for (int j = i; j < numPendingAssignments && ((String)generatedNamesForAssignments.get(j)).length() == len; ++j) {
                varsByOrderOfOccurrence.add((Assignment)pendingAssignments.get(j));
            }
            for (Assignment a : varsByOrderOfOccurrence) {
                this.finalizeNameAssignment(a, (String)generatedNamesForAssignments.get(i));
                ++i;
            }
        }
    }

    private void finalizeNameAssignment(Assignment a, String newName) {
        a.setNewName(newName);
        this.renameMap.put(a.oldName, newName);
    }

    VariableMap getVariableMap() {
        return new VariableMap(ImmutableMap.copyOf(this.renameMap));
    }

    private boolean okToRenameVar(String name, boolean isLocal) {
        return !this.compiler.getCodingConvention().isExported(name, isLocal);
    }

    private int getLocalVarIndex(Var v) {
        boolean isBleedingIntoScope;
        int num = v.index;
        Scope s = (Scope)((Scope)v.scope).getParent();
        if (s == null) {
            throw new IllegalArgumentException("Var is not local");
        }
        boolean bl = isBleedingIntoScope = s.getParent() != null && this.localBleedingFunctions.contains(v);
        while (s.getParent() != null) {
            if (isBleedingIntoScope) {
                num += this.localBleedingFunctionsPerScope.get((Object)s).indexOf(v) + 1;
                isBleedingIntoScope = false;
            } else {
                num += this.localBleedingFunctionsPerScope.get((Object)s).size();
            }
            if (this.shouldTemporarilyRenameLocalsInScope(s)) {
                num += s.getVarCount();
            }
            s = (Scope)s.getParent();
        }
        return num;
    }

    private boolean shouldTemporarilyRenameLocalsInScope(Scope s) {
        return !this.preferStableNames || s.getVarCount() <= 1000;
    }

    class ProcessVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        ProcessVars() {
        }

        public void enterScope(NodeTraversal t) {
            if (t.inGlobalHoistScope() || !RenameVarsWithModuleSupport.this.shouldTemporarilyRenameLocalsInScope(t.getScope())) {
                return;
            }
            Scope scope = t.getScope();
            for (Var current : scope.getVarIterable()) {
                if (!current.isBleedingFunction()) continue;
                RenameVarsWithModuleSupport.this.localBleedingFunctions.add(current);
                RenameVarsWithModuleSupport.this.localBleedingFunctionsPerScope.put((Scope)scope.getParent(), current);
            }
        }

        public void exitScope(NodeTraversal t) {
        }

        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean local;
            if (!n.isName() && !n.isImportStar()) {
                return;
            }
            String name = n.getString();
            if (name.isEmpty()) {
                return;
            }
            if (parent.isImportSpec() && parent.hasTwoChildren() && parent.getFirstChild() == n) {
                return;
            }
            Var var = (Var)t.getScope().getVar(name);
            boolean bl = local = var != null && var.isLocal() && (((Scope)((Scope)var.scope).getParent()).isLocal() || !var.isBleedingFunction());
            if (var != null && var.isArguments()) {
                RenameVarsWithModuleSupport.this.reservedNames.add(name);
                return;
            }
            if (!local && RenameVarsWithModuleSupport.this.localRenamingOnly) {
                RenameVarsWithModuleSupport.this.reservedNames.add(name);
                return;
            }
            if (RenameVarsWithModuleSupport.this.preserveFunctionExpressionNames && var != null && NodeUtil.isFunctionExpression((Node)var.getParentNode())) {
                RenameVarsWithModuleSupport.this.reservedNames.add(name);
                return;
            }
            if (!RenameVarsWithModuleSupport.this.okToRenameVar(name, local)) {
                String newName;
                if (local && !(newName = MakeDeclaredNamesUnique.ContextualRenameInverter.getOriginalName((String)name)).equals(name)) {
                    n.setString(newName);
                }
                return;
            }
            if (RenameVarsWithModuleSupport.this.pseudoNameMap != null) {
                RenameVarsWithModuleSupport.this.recordPseudoName(n);
            }
            if (local && RenameVarsWithModuleSupport.this.shouldTemporarilyRenameLocalsInScope((Scope)var.getScope())) {
                String tempName = RenameVarsWithModuleSupport.LOCAL_VAR_PREFIX + RenameVarsWithModuleSupport.this.getLocalVarIndex(var);
                this.incCount(tempName);
                RenameVarsWithModuleSupport.this.localNameNodes.add(n);
                RenameVarsWithModuleSupport.this.originalNameByNode.put(n, n.getString());
                n.setString(tempName);
            } else if (var != null) {
                this.incCount(name);
                RenameVarsWithModuleSupport.this.globalNameNodes.add(n);
            }
        }

        void incCount(String name) {
            Assignment s = RenameVarsWithModuleSupport.this.assignments.get(name);
            if (s == null) {
                s = new Assignment(name);
                RenameVarsWithModuleSupport.this.assignments.put(name, s);
            }
            ++s.count;
        }
    }

    class Assignment {
        final boolean isLocal;
        final String oldName;
        final int orderOfOccurrence;
        String newName;
        int count;

        Assignment(String name) {
            this.isLocal = name.startsWith(RenameVarsWithModuleSupport.LOCAL_VAR_PREFIX);
            this.oldName = name;
            this.newName = null;
            this.count = 0;
            this.orderOfOccurrence = RenameVarsWithModuleSupport.this.assignmentCount++;
        }

        void setNewName(String newName) {
            Preconditions.checkState(this.newName == null);
            this.newName = newName;
        }
    }
}

