/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.player;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.commands.player.DefaultPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.process.ProcessCommand;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;

public class CustomPlayerCommand
implements ProcessCommand {
    private DefaultPlayerCommand proxiedCommand;
    private File executable;
    private String[] executableArgs;

    public ProcessCommand getProxiedCommand() {
        return this.proxiedCommand;
    }

    public void setProxiedCommand(DefaultPlayerCommand playerCommand) {
        this.proxiedCommand = playerCommand;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public String[] getExecutableArgs() {
        return this.executableArgs;
    }

    public void setExecutableArgs(String[] executableArgs) {
        this.executableArgs = executableArgs;
    }

    @Override
    public void setProject(Project project) {
        this.proxiedCommand.setProject(project);
    }

    @Override
    public void setSwf(File swf) {
        this.proxiedCommand.setSwf(swf);
    }

    public String getUrl() {
        return this.proxiedCommand.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.proxiedCommand.setUrl(url);
    }

    @Override
    public File getFileToExecute() {
        return this.proxiedCommand.getFileToExecute();
    }

    @Override
    public void prepare() {
        this.proxiedCommand.prepare();
        this.proxiedCommand.getCommandLine().setExecutable(this.executable.getAbsolutePath());
        this.proxiedCommand.getCommandLine().clearArgs();
        int customArgsCount = this.executableArgs != null ? this.executableArgs.length : 0;
        String[] args = new String[customArgsCount + 1];
        if (this.executableArgs != null) {
            System.arraycopy(this.executableArgs, 0, args, 0, this.executableArgs.length);
        }
        args[args.length - 1] = this.getUrl() != null ? this.getUrl() : this.getFileToExecute().getAbsolutePath();
        this.proxiedCommand.getCommandLine().addArguments(args);
    }

    @Override
    public Process launch() throws IOException {
        LoggingUtil.log(this.proxiedCommand.getCommandLine().describeCommand());
        return Runtime.getRuntime().exec(this.proxiedCommand.getCommandLine().getCommandline(), this.getJointEnvironment(), this.proxiedCommand.getProject().getBaseDir());
    }

    @Override
    public void setEnvironment(String[] variables) {
        this.proxiedCommand.setEnvironment(variables);
    }

    private String[] getJointEnvironment() {
        Vector procEnvironment = Execute.getProcEnvironment();
        String[] environment = new String[procEnvironment.size() + this.proxiedCommand.getEnvironment().length];
        System.arraycopy(procEnvironment.toArray(), 0, environment, 0, procEnvironment.size());
        System.arraycopy(this.proxiedCommand.getEnvironment(), 0, environment, procEnvironment.size(), this.proxiedCommand.getEnvironment().length);
        return environment;
    }
}

