/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.Frame;
import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Isolate;
import flash.tools.debugger.IsolateSession;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSupportedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SuspendedException;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.Watch;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.ConsoleErrorFault;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.FileListModifiedEvent;
import flash.tools.debugger.events.FunctionMetaDataAvailableEvent;
import flash.tools.debugger.events.IsolateCreateEvent;
import flash.tools.debugger.events.IsolateExitEvent;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import flash.tools.debugger.expression.ECMA;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import flash.util.FieldFormat;
import flash.util.Trace;
import flex.tools.debugger.cli.AmbiguousException;
import flex.tools.debugger.cli.BreakAction;
import flex.tools.debugger.cli.CatchAction;
import flex.tools.debugger.cli.DisplayAction;
import flex.tools.debugger.cli.ExpressionCache;
import flex.tools.debugger.cli.Extensions;
import flex.tools.debugger.cli.FaultActions;
import flex.tools.debugger.cli.FileInfoCache;
import flex.tools.debugger.cli.FileLocation;
import flex.tools.debugger.cli.Help;
import flex.tools.debugger.cli.InternalProperty;
import flex.tools.debugger.cli.LocationCollection;
import flex.tools.debugger.cli.NoMatchException;
import flex.tools.debugger.cli.StringIntArray;
import flex.tools.debugger.cli.VariableFacade;
import flex.tools.debugger.cli.WatchAction;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.LocaleUtils;

public class DebugCLI
implements Runnable,
SourceLocator {
    public static final String VERSION = "82";
    public static final int CMD_UNKNOWN = 0;
    public static final int CMD_QUIT = 1;
    public static final int CMD_CONTINUE = 2;
    public static final int CMD_STEP = 3;
    public static final int CMD_NEXT = 4;
    public static final int CMD_FINISH = 5;
    public static final int CMD_BREAK = 6;
    public static final int CMD_SET = 7;
    public static final int CMD_LIST = 8;
    public static final int CMD_PRINT = 9;
    public static final int CMD_TUTORIAL = 10;
    public static final int CMD_INFO = 11;
    public static final int CMD_HOME = 12;
    public static final int CMD_RUN = 13;
    public static final int CMD_FILE = 14;
    public static final int CMD_DELETE = 15;
    public static final int CMD_SOURCE = 16;
    public static final int CMD_COMMENT = 17;
    public static final int CMD_CLEAR = 18;
    public static final int CMD_HELP = 19;
    public static final int CMD_SHOW = 20;
    public static final int CMD_KILL = 21;
    public static final int CMD_HANDLE = 22;
    public static final int CMD_ENABLE = 23;
    public static final int CMD_DISABLE = 24;
    public static final int CMD_DISPLAY = 25;
    public static final int CMD_UNDISPLAY = 26;
    public static final int CMD_COMMANDS = 27;
    public static final int CMD_PWD = 28;
    public static final int CMD_CF = 29;
    public static final int CMD_CONDITION = 30;
    public static final int CMD_AWATCH = 31;
    public static final int CMD_WATCH = 32;
    public static final int CMD_RWATCH = 33;
    public static final int CMD_WHAT = 34;
    public static final int CMD_DISASSEMBLE = 35;
    public static final int CMD_HALT = 36;
    public static final int CMD_MCTREE = 37;
    public static final int CMD_VIEW_SWF = 38;
    public static final int CMD_DOWN = 39;
    public static final int CMD_UP = 40;
    public static final int CMD_FRAME = 41;
    public static final int CMD_DIRECTORY = 42;
    public static final int CMD_CATCH = 43;
    public static final int CMD_CONNECT = 44;
    public static final int CMD_WORKER = 45;
    public static final int INFO_UNKNOWN_CMD = 100;
    public static final int INFO_ARGS_CMD = 101;
    public static final int INFO_BREAK_CMD = 102;
    public static final int INFO_FILES_CMD = 103;
    public static final int INFO_HANDLE_CMD = 104;
    public static final int INFO_FUNCTIONS_CMD = 105;
    public static final int INFO_LOCALS_CMD = 106;
    public static final int INFO_SCOPECHAIN_CMD = 107;
    public static final int INFO_SOURCES_CMD = 108;
    public static final int INFO_STACK_CMD = 109;
    public static final int INFO_VARIABLES_CMD = 110;
    public static final int INFO_DISPLAY_CMD = 111;
    public static final int INFO_TARGETS_CMD = 112;
    public static final int INFO_SWFS_CMD = 113;
    public static final int INFO_WORKERS_CMD = 114;
    public static final int SHOW_UNKNOWN_CMD = 200;
    public static final int SHOW_NET_CMD = 201;
    public static final int SHOW_FUNC_CMD = 202;
    public static final int SHOW_URI_CMD = 203;
    public static final int SHOW_PROPERTIES_CMD = 204;
    public static final int SHOW_FILES_CMD = 205;
    public static final int SHOW_BREAK_CMD = 206;
    public static final int SHOW_VAR_CMD = 207;
    public static final int SHOW_MEM_CMD = 208;
    public static final int SHOW_LOC_CMD = 209;
    public static final int SHOW_DIRS_CMD = 210;
    public static final int ENABLE_ONCE_CMD = 301;
    public static final int METADATA_RETRIES = 40;
    public static final boolean WORKER_DISPLAY_INTERNAL_SWAP_INFO = true;
    Stack<LineNumberReader> m_readerStack = new Stack();
    public PrintStream m_err;
    public PrintStream m_out;
    Session m_session;
    String m_launchURI;
    boolean m_fullnameOption = false;
    String m_cdPath;
    String m_mruURI = null;
    String m_connectPort;
    private boolean m_quietMode;
    public static final String m_newline = System.getProperty("line.separator");
    private static final LocalizationManager m_localizationManager = new LocalizationManager();
    private static final FaultActions.FaultActionsBuilder faultActionsBuilder = new FaultActions.FaultActionsBuilder(m_localizationManager);
    List<String> m_sourceDirectories;
    int m_sourceDirectoriesChangeCount;
    private File m_flexHomeDirectory;
    private boolean m_initializedFlexHomeDirectory;
    FileInfoCache m_fileInfo;
    FaultActions m_faultTable = faultActionsBuilder.build();
    Vector<Integer> m_breakIsolates;
    ExpressionCache m_exprCache = new ExpressionCache(this);
    Vector<BreakAction> m_breakpoints = new Vector();
    Vector<WatchAction> m_watchpoints = new Vector();
    Vector<CatchAction> m_catchpoints = new Vector();
    ArrayList<DisplayAction> m_displays = new ArrayList();
    int m_activeIsolate;
    DebugCLIIsolateState m_mainState;
    int m_lastPromptIsolate;
    private HashMap<Integer, DebugCLIIsolateState> m_isolateState;
    LineNumberReader m_in;
    public LineNumberReader m_keyboardStream;
    Vector<String> m_keyboardInput = new Vector();
    boolean m_keyboardReadRequest;
    StringTokenizer m_currentTokenizer;
    String m_currentToken;
    String m_currentLine;
    public String m_repeatLine;
    private boolean m_isIde;
    public static final String LIST_MODULE = "$listmodule";
    public static final String LIST_LINE = "$listline";
    public static final String LIST_WORKER = "$listworker";
    private static final String LIST_SIZE = "$listsize";
    private static final String COLUMN_WIDTH = "$columnwidth";
    private static final String UPDATE_DELAY = "$updatedelay";
    private static final String HALT_TIMEOUT = "$halttimeout";
    private static final String BPNUM = "$bpnum";
    private static final String LAST_FRAME_DEPTH = "$lastframedepth";
    private static final String CURRENT_FRAME_DEPTH = "$currentframedepth";
    public static final String DISPLAY_FRAME_NUMBER = "$displayframenumber";
    private static final String FILE_LIST_WRAP = "$filelistwrap";
    private static final String NO_WAITING = "$nowaiting";
    private static final String INFO_STACK_SHOW_THIS = "$infostackshowthis";
    private static final String PLAYER_FULL_SUPPORT = "$playerfullsupport";
    public static final String DISPLAY_ATTRIBUTES = "$displayattributes";
    private static final int AUTHORED_FILE = 1;
    private static final int FRAMEWORK_FILE = 2;
    private static final int SYNTHETIC_FILE = 3;
    private static final int ACTIONS_FILE = 4;
    private static final String[] FRAMEWORK_FILE_PACKAGES;
    static StringIntArray g_commandArray;
    static StringIntArray g_infoCommandArray;
    static StringIntArray g_showCommandArray;
    static StringIntArray g_enableCommandArray;
    static StringIntArray g_disableCommandArray;

    private DebugCLIIsolateState getIsolateState(int n) {
        if (n == 1) {
            return this.m_mainState;
        }
        DebugCLIIsolateState debugCLIIsolateState = null;
        if (!this.m_isolateState.containsKey(n)) {
            debugCLIIsolateState = new DebugCLIIsolateState(this);
            this.m_isolateState.put(n, debugCLIIsolateState);
        } else {
            debugCLIIsolateState = this.m_isolateState.get(n);
        }
        return debugCLIIsolateState;
    }

    public int getActiveIsolateId() {
        return this.m_activeIsolate;
    }

    private boolean getRequestResume(int n) {
        return this.getIsolateState((int)n).m_requestResume;
    }

    private void setRequestResume(boolean bl, int n) {
        this.getIsolateState((int)n).m_requestResume = bl;
    }

    private boolean getStepResume(int n) {
        return this.getIsolateState((int)n).m_stepResume;
    }

    private void setStepResume(boolean bl, int n) {
        this.getIsolateState((int)n).m_stepResume = bl;
    }

    private boolean getRequestHalt(int n) {
        return this.getIsolateState((int)n).m_requestHalt;
    }

    private void setRequestHalt(boolean bl, int n) {
        this.getIsolateState((int)n).m_requestHalt = bl;
    }

    private InitialPromptState getPromptState(int n) {
        return this.getIsolateState((int)n).m_promptState;
    }

    private void setPromptState(InitialPromptState initialPromptState, int n) {
        this.getIsolateState((int)n).m_promptState = initialPromptState;
    }

    public static void main(String[] stringArray) {
        FileReader fileReader;
        DebugCLI debugCLI = new DebugCLI();
        debugCLI.m_err = System.err;
        debugCLI.m_out = System.out;
        debugCLI.initSourceDirectoriesList();
        debugCLI.m_keyboardStream = new LineNumberReader(new InputStreamReader(System.in));
        debugCLI.pushStream(debugCLI.m_keyboardStream);
        debugCLI.processArgs(stringArray);
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("user.dir");
        if (string2 != null && !string2.equals(string)) {
            try {
                fileReader = new FileReader(new File(string2, ".fdbinit"));
                debugCLI.pushStream(new LineNumberReader(fileReader));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (string != null) {
            try {
                fileReader = new FileReader(new File(string, ".fdbinit"));
                debugCLI.pushStream(new LineNumberReader(fileReader));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        debugCLI.execute();
    }

    public DebugCLI() {
        this.m_sourceDirectories = new LinkedList<String>();
        this.initProperties();
        this.m_mainState = new DebugCLIIsolateState(this);
        this.m_lastPromptIsolate = -1;
        this.initIsolateState();
    }

    public static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    public Session getSession() {
        return this.m_session;
    }

    public FileInfoCache getFileCache() {
        return this.m_fileInfo;
    }

    public boolean isIde() {
        return this.m_isIde;
    }

    public String module2ClassName(int n) {
        String string = null;
        try {
            SourceFile sourceFile = this.m_fileInfo.getFile(n);
            string = sourceFile.getPackageName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    LineNumberReader popStream() {
        return this.m_readerStack.pop();
    }

    public void pushStream(LineNumberReader lineNumberReader) {
        this.m_readerStack.push(lineNumberReader);
    }

    boolean haveStreams() {
        return !this.m_readerStack.empty();
    }

    public void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.charAt(0) == '-') {
                if (string.equals("-unit")) {
                    System.setProperty("fdbunit", "");
                    continue;
                }
                if (string.equals("-fullname") || string.equals("-f")) {
                    this.m_fullnameOption = true;
                    continue;
                }
                if (string.equals("-cd")) {
                    if (i + 1 >= stringArray.length) continue;
                    this.m_cdPath = stringArray[i++];
                    continue;
                }
                if (string.equals("-p")) {
                    if (i + 1 >= stringArray.length) continue;
                    this.m_connectPort = stringArray[++i];
                    continue;
                }
                if (string.equals("-ide")) {
                    this.m_isIde = true;
                    continue;
                }
                if (string.equals("-lang")) {
                    if (i + 1 >= stringArray.length) continue;
                    DebugCLI.getLocalizationManager().setLocale(LocaleUtils.toLocale((String)stringArray[++i]));
                    continue;
                }
                this.err("Unknown command-line argument: " + string);
                continue;
            }
            StringReader stringReader = new StringReader("run " + string + m_newline);
            this.pushStream(new LineNumberReader(stringReader));
        }
    }

    protected String readLine() throws IOException {
        String string = null;
        string = this.haveStreams() ? this.m_in.readLine() : this.keyboardReadLine();
        this.setCurrentLine(string);
        return string;
    }

    synchronized String keyboardReadLine() {
        this.m_keyboardReadRequest = true;
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.m_keyboardInput.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_keyboardStream != null) {
            try {
                if (this.m_keyboardReadRequest) {
                    String string = this.m_keyboardStream.readLine();
                    this.m_keyboardInput.add(string);
                    this.m_keyboardReadRequest = false;
                    DebugCLI debugCLI = this;
                    synchronized (debugCLI) {
                        this.notifyAll();
                        continue;
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setCurrentLine(String string) {
        this.m_currentLine = string;
        if (this.m_currentLine == null) {
            this.m_currentTokenizer = null;
        } else {
            this.m_currentLine = this.m_currentLine.trim();
            if (this.m_repeatLine != null && !this.haveStreams() && this.m_currentLine.length() == 0) {
                this.m_currentLine = this.m_repeatLine;
            }
            this.m_currentTokenizer = new StringTokenizer(this.m_currentLine, " \n\r\t");
        }
    }

    public boolean hasMoreTokens() {
        return this.m_currentTokenizer.hasMoreTokens();
    }

    public String nextToken() {
        this.m_currentToken = this.m_currentTokenizer.nextToken();
        return this.m_currentToken;
    }

    public int nextIntToken() throws NumberFormatException {
        this.nextToken();
        return Integer.parseInt(this.m_currentToken);
    }

    public long nextLongToken() throws NumberFormatException {
        this.nextToken();
        return Long.parseLong(this.m_currentToken);
    }

    public String restOfLine() {
        return this.m_currentTokenizer.nextToken("").trim();
    }

    public void execute() {
        this.displayStartMessage();
        Thread thread = new Thread((Runnable)this, "Keyboard input");
        thread.start();
        while (this.haveStreams()) {
            try {
                this.m_in = this.popStream();
                this.process();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                HashMap<String, IOException> hashMap = new HashMap<String, IOException>();
                hashMap.put("exceptionMessage", iOException);
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("errorWhileProcessingFile", hashMap));
            }
        }
        this.exitSession();
        this.m_keyboardStream = null;
    }

    public PrintStream getOut() {
        return this.m_out;
    }

    private void displayStartMessage() {
        Map<Object, Object> map;
        String string = DebugCLI.getLocalizationManager().getLocalizedTextString("defaultBuildName");
        try {
            map = new Properties();
            ((Properties)map).load(this.getClass().getResourceAsStream("version.properties"));
            String string2 = ((Properties)map).getProperty("build");
            if (string2 != null && !string2.equals("")) {
                string = string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map = new HashMap();
        map.put("build", string);
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("about", map));
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("copyright"));
    }

    void displayPrompt() {
        this.m_out.print("(fdb) ");
    }

    void displayCommandPrompt() {
        this.m_out.print(">");
    }

    void repeat(StringBuilder stringBuilder, char c, int n) {
        while (n-- > 0) {
            stringBuilder.append(c);
        }
    }

    boolean yesNoQuery(String string) throws IOException {
        boolean bl = false;
        this.m_out.print(string);
        this.m_out.print(DebugCLI.getLocalizationManager().getLocalizedTextString("yesOrNoAppendedToAllQuestions"));
        String string2 = this.readLine();
        if (string2 != null && string2.equals(DebugCLI.getLocalizationManager().getLocalizedTextString("singleCharacterUserTypesForYes"))) {
            bl = true;
        } else {
            if (string2 != null && string2.equals("escape")) {
                throw new IllegalArgumentException("escape");
            }
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("yesNoQueryNotConfirmed"));
        }
        return bl;
    }

    public void err(String string) {
        this.out(string);
    }

    public void out(String string) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            this.m_out.print(string);
        } else {
            this.m_out.println(string);
        }
    }

    static String uft() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        long l3 = l2 - l;
        NumberFormat numberFormat = NumberFormat.getInstance();
        return "Used " + numberFormat.format(l3) + " - free " + numberFormat.format(l) + " - total " + numberFormat.format(l2);
    }

    void initProperties() {
        this.propertyPut(LIST_SIZE, 10);
        this.propertyPut(LIST_LINE, 1);
        this.propertyPut(LIST_MODULE, 1);
        this.propertyPut(LIST_WORKER, 1);
        this.propertyPut(COLUMN_WIDTH, 70);
        this.propertyPut(UPDATE_DELAY, 25);
        this.propertyPut(HALT_TIMEOUT, 7000);
        this.propertyPut(BPNUM, 0);
        this.propertyPut(LAST_FRAME_DEPTH, 0);
        this.propertyPut(CURRENT_FRAME_DEPTH, 0);
        this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
        this.propertyPut(FILE_LIST_WRAP, 999999);
        this.propertyPut(NO_WAITING, 0);
        this.propertyPut(INFO_STACK_SHOW_THIS, 1);
    }

    public void propertyPut(String string, int n) {
        this.m_exprCache.put(string, n);
    }

    public int propertyGet(String string) {
        return (Integer)this.m_exprCache.get(string);
    }

    public Set<String> propertyKeys() {
        return this.m_exprCache.keySet();
    }

    void process() throws IOException {
        boolean bl = false;
        while (!bl) {
            try {
                this.runningLoop();
                if (!this.haveStreams()) {
                    this.displayPrompt();
                }
                this.readLine();
                if (this.m_currentLine == null) break;
                bl = this.processLine();
            }
            catch (NoResponseException noResponseException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noResponseException"));
            }
            catch (NotSuspendedException notSuspendedException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notSuspendedException"));
            }
            catch (AmbiguousException ambiguousException) {
            }
            catch (IllegalStateException illegalStateException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("illegalStateException"));
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("illegalMonitorStateException"));
            }
            catch (NoSuchElementException noSuchElementException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchElementException"));
            }
            catch (NumberFormatException numberFormatException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("numberFormatException"));
            }
            catch (SocketException socketException) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("message", socketException.getMessage());
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("socketException", hashMap));
            }
            catch (VersionException versionException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("versionException"));
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (Exception exception) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unexpectedError"));
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("stackTraceFollows"));
                exception.printStackTrace();
            }
            if (!this.isConnectionLost()) continue;
            try {
                this.dumpHaltState(false);
            }
            catch (PlayerDebugException playerDebugException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sessionEndedAbruptly"));
            }
        }
    }

    boolean isConnectionLost() {
        boolean bl = false;
        if (this.m_session != null && !this.m_session.isConnected()) {
            bl = true;
        }
        return bl;
    }

    boolean haveConnection() {
        boolean bl = false;
        if (this.m_session != null && this.m_session.isConnected()) {
            bl = true;
        }
        return bl;
    }

    void doShow() throws AmbiguousException, PlayerDebugException {
        if (!this.hasMoreTokens()) {
            this.out(this.getHelpTopic("show"));
        } else {
            String string = this.nextToken();
            int n = this.showCommandFor(string);
            switch (n) {
                case 201: {
                    this.doShowStats();
                    break;
                }
                case 202: {
                    this.doShowFuncs();
                    break;
                }
                case 203: {
                    this.doShowUri();
                    break;
                }
                case 204: {
                    this.doShowProperties();
                    break;
                }
                case 205: {
                    this.doShowFiles();
                    break;
                }
                case 206: {
                    this.doShowBreak();
                    break;
                }
                case 207: {
                    this.doShowVariable();
                    break;
                }
                case 208: {
                    this.doShowMemory();
                    break;
                }
                case 209: {
                    this.doShowLocations();
                    break;
                }
                case 210: {
                    this.doShowDirectories();
                    break;
                }
                default: {
                    this.doUnknown("show", string);
                }
            }
        }
    }

    void doShowUri() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("URI = ");
            stringBuilder.append(this.m_session.getURI());
            this.out(stringBuilder.toString());
        }
        catch (Exception exception) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noUriReceived"));
        }
    }

    void doShowFiles() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Isolate isolate : this.m_session.getWorkers()) {
                Iterator iterator = this.m_fileInfo.getAllFiles(isolate.getId());
                while (iterator.hasNext()) {
                    SourceFile sourceFile = (SourceFile)((Map.Entry)iterator.next()).getValue();
                    String string = sourceFile.getName();
                    int n = sourceFile.getId();
                    String string2 = sourceFile.getFullPath();
                    stringBuilder.append(n);
                    stringBuilder.append(' ');
                    stringBuilder.append(string2);
                    stringBuilder.append(", ");
                    stringBuilder.append(string);
                    stringBuilder.append(" (");
                    if (isolate.getId() == 1) {
                        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                    } else {
                        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                        hashMap.put("worker", isolate.getId() - 1);
                        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", hashMap));
                    }
                    stringBuilder.append(")");
                    stringBuilder.append(m_newline);
                }
            }
            this.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFilesFound"));
        }
    }

    void doShowMemory() {
        this.out(DebugCLI.uft());
    }

    void doShowLocations() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Num Type           Disp Enb Address    What" + m_newline);
        int n = this.breakpointCount();
        for (int i = 0; i < n; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            int n2 = breakAction.getId();
            FieldFormat.formatLong(stringBuilder, n2, 3);
            stringBuilder.append(" breakpoint     ");
            if (breakAction.isAutoDisable()) {
                stringBuilder.append("dis  ");
            } else if (breakAction.isAutoDelete()) {
                stringBuilder.append("del  ");
            } else {
                stringBuilder.append("keep ");
            }
            if (breakAction.isEnabled()) {
                stringBuilder.append("y   ");
            } else {
                stringBuilder.append("n   ");
            }
            Iterator<Location> iterator = breakAction.getLocations().iterator();
            while (iterator.hasNext()) {
                Object object;
                Location location = iterator.next();
                SourceFile sourceFile = location.getFile();
                String string = sourceFile == null ? DebugCLI.getLocalizationManager().getLocalizedTextString("unknownBreakpointLocation") : sourceFile.getFunctionNameForLine(this.m_session, location.getLine());
                int n3 = this.adjustOffsetForUnitTests(sourceFile == null ? 0 : sourceFile.getOffsetForLine(location.getLine()));
                stringBuilder.append("0x");
                FieldFormat.formatLongToHex(stringBuilder, n3, 8);
                stringBuilder.append(' ');
                if (string != null) {
                    object = new HashMap<String, String>();
                    object.put("functionName", string);
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inFunctionAt", (Map)object));
                }
                stringBuilder.append(sourceFile.getName());
                stringBuilder.append("#");
                stringBuilder.append(sourceFile.getId());
                stringBuilder.append(':');
                stringBuilder.append(location.getLine());
                try {
                    object = this.m_fileInfo.swfForFile(sourceFile, location.getIsolateId());
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("swf", FileInfoCache.shortNameOfSwf((SwfInfo)object));
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inSwf", hashMap));
                    if (location.getIsolateId() == 1) {
                        stringBuilder.append(" (");
                        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                        stringBuilder.append(")");
                    } else {
                        hashMap = new HashMap();
                        hashMap.put("worker", location.getIsolateId() - 1);
                        stringBuilder.append(" (");
                        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", hashMap));
                        stringBuilder.append(")");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("nonRestorable"));
                }
                stringBuilder.append(m_newline);
                if (!iterator.hasNext()) continue;
                stringBuilder.append("                            ");
            }
        }
        this.out(stringBuilder.toString());
    }

    private int adjustOffsetForUnitTests(int n) {
        if (System.getProperty("fdbunit") == null) {
            return n;
        }
        return 0;
    }

    void doShowDirectories() {
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceDirectoriesSearched"));
        for (String string : this.m_sourceDirectories) {
            this.out("  " + string);
        }
    }

    void doHalt() throws SuspendedException, NotConnectedException, NoResponseException {
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("attemptingToSuspend"));
        IsolateSession isolateSession = this.m_session.getWorkerSession(this.getActiveIsolateId());
        if (!isolateSession.isSuspended()) {
            isolateSession.suspend();
        }
        if (isolateSession.isSuspended()) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerStopped"));
        } else {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerRunning"));
        }
    }

    public void appendReason(StringBuilder stringBuilder, int n) {
        switch (n) {
            case 0: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_Unknown"));
                break;
            }
            case 1: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_HitBreakpoint"));
                break;
            }
            case 2: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_HitWatchpoint"));
                break;
            }
            case 3: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_ProgramThrewException"));
                break;
            }
            case 4: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_StopRequest"));
                break;
            }
            case 5: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_ProgramFinishedStepping"));
                break;
            }
            case 6: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_HaltOpcode"));
                break;
            }
            case 7: {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("suspendReason_ScriptHasLoadedIntoFlashPlayer"));
            }
        }
    }

    void doInfo() throws AmbiguousException, PlayerDebugException {
        if (!this.hasMoreTokens()) {
            this.out(this.getHelpTopic("info"));
        } else {
            String string = this.nextToken();
            int n = this.infoCommandFor(string);
            switch (n) {
                case 101: {
                    this.doInfoArgs();
                    break;
                }
                case 102: {
                    this.doInfoBreak();
                    break;
                }
                case 103: {
                    this.doInfoFiles();
                    break;
                }
                case 105: {
                    this.doInfoFuncs();
                    break;
                }
                case 104: {
                    this.doInfoHandle();
                    break;
                }
                case 106: {
                    this.doInfoLocals();
                    break;
                }
                case 107: {
                    this.doInfoScopeChain();
                    break;
                }
                case 108: {
                    this.doInfoSources();
                    break;
                }
                case 109: {
                    this.doInfoStack();
                    break;
                }
                case 110: {
                    this.doInfoVariables();
                    break;
                }
                case 111: {
                    this.doInfoDisplay();
                    break;
                }
                case 112: {
                    this.doInfoTargets();
                    break;
                }
                case 113: {
                    this.doInfoSwfs();
                    break;
                }
                case 114: {
                    this.doInfoWorkers();
                    break;
                }
                default: {
                    this.doUnknown("info", string);
                }
            }
        }
    }

    void doInfoWorkers() throws NotConnectedException, NotSupportedException, NotSuspendedException, NoResponseException {
        Isolate[] isolateArray = this.m_session.getWorkers();
        if (isolateArray == null || isolateArray.length == 0) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("noWorkersRunning"));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Isolate isolate : isolateArray) {
            String string = DebugCLI.getLocalizationManager().getLocalizedTextString("workerRunning");
            if (this.m_session.getWorkerSession(isolate.getId()).isSuspended()) {
                string = DebugCLI.getLocalizationManager().getLocalizedTextString("workerSuspended");
            }
            if (this.m_activeIsolate == isolate.getId()) {
                string = string + " " + DebugCLI.getLocalizationManager().getLocalizedTextString("workerSelected");
            }
            if (isolate.getId() == 1) {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                stringBuilder.append(" ");
                stringBuilder.append(0);
            } else {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put("worker", isolate.getId() - 1);
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", hashMap));
            }
            stringBuilder.append(" - " + string + m_newline);
        }
        this.out(stringBuilder.toString());
    }

    void doInfoStack() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder stringBuilder = new StringBuilder();
        Frame[] frameArray = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
        if (frameArray == null || frameArray.length == 0) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noStackAvailable"));
        } else {
            boolean bl = this.propertyGet(INFO_STACK_SHOW_THIS) == 1;
            for (int i = 0; i < frameArray.length; ++i) {
                Frame frame = frameArray[i];
                boolean bl2 = this.appendFrameInfo(stringBuilder, frame, i, bl, true);
                stringBuilder.append(m_newline);
                if (!bl2) break;
            }
        }
        this.out(stringBuilder.toString());
    }

    boolean appendFrameInfo(StringBuilder stringBuilder, Frame frame, int n, boolean bl, boolean bl2) throws PlayerDebugException {
        boolean bl3 = true;
        int n2 = n;
        Location location = frame.getLocation();
        SourceFile sourceFile = location.getFile();
        int n3 = location.getLine();
        String string = sourceFile == null ? "<null>" : sourceFile.getName();
        String string2 = frame.getCallSignature();
        String string3 = DebugCLI.extractFunctionName(string2);
        if (sourceFile == null && n3 < 0) {
            bl3 = false;
        } else {
            Variable[] variableArray = frame.getArguments(this.m_session);
            Variable variable = frame.getThis(this.m_session);
            boolean bl4 = string3 != null || variableArray != null;
            stringBuilder.append('#');
            FieldFormat.formatLong(stringBuilder, n2, 3);
            stringBuilder.append(' ');
            if (bl && variable != null) {
                this.m_exprCache.appendVariable(stringBuilder, variable, frame.getIsolateId());
                stringBuilder.append(".");
            }
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            if (bl4) {
                stringBuilder.append('(');
                for (int i = 0; i < variableArray.length; ++i) {
                    Variable variable2 = variableArray[i];
                    stringBuilder.append(variable2.getName());
                    stringBuilder.append('=');
                    this.m_exprCache.appendVariableValue(stringBuilder, variable2.getValue(), frame.getIsolateId());
                    if (i + 1 >= variableArray.length) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(")");
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("atFilename"));
            }
            stringBuilder.append(string);
            if (sourceFile != null && (bl2 || !this.m_fileInfo.inFileList(sourceFile))) {
                stringBuilder.append('#');
                stringBuilder.append(sourceFile.getId());
            }
            stringBuilder.append(':');
            stringBuilder.append(n3);
        }
        return bl3;
    }

    public static String extractFunctionName(String string) {
        int n = string.indexOf(40);
        if (n > -1) {
            string = string.substring(0, n);
        }
        if (string != null && (n = string.indexOf("::")) > -1) {
            string = string.substring(n + 2);
        }
        return string;
    }

    void doInfoVariables() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Variable[] variableArray = this.m_session.getWorkerSession(this.m_activeIsolate).getVariableList();
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable = variableArray[i];
                if (variable.isAttributeSet(32) || variable.isAttributeSet(65536)) continue;
                this.m_exprCache.appendVariable(stringBuilder, variableArray[i], this.m_activeIsolate);
                stringBuilder.append(m_newline);
            }
        }
        catch (NullPointerException nullPointerException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noVariables"));
        }
        this.out(stringBuilder.toString());
    }

    void doInfoDisplay() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Num Enb Expression" + m_newline);
        int n = this.displayCount();
        for (int i = 0; i < n; ++i) {
            DisplayAction displayAction = this.displayAt(i);
            int n2 = displayAction.getId();
            String string = displayAction.getContent();
            stringBuilder.append(':');
            FieldFormat.formatLong(stringBuilder, n2, 3);
            if (displayAction.isEnabled()) {
                stringBuilder.append(" y  ");
            } else {
                stringBuilder.append(" n  ");
            }
            stringBuilder.append(string);
            stringBuilder.append(m_newline);
        }
        this.out(stringBuilder.toString());
    }

    void doInfoArgs() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n = this.propertyGet(DISPLAY_FRAME_NUMBER);
            Frame[] frameArray = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
            Variable[] variableArray = frameArray[n].getArguments(this.m_session);
            for (int i = 0; i < variableArray.length; ++i) {
                this.m_exprCache.appendVariable(stringBuilder, variableArray[i], this.m_activeIsolate);
                stringBuilder.append(m_newline);
            }
        }
        catch (NullPointerException nullPointerException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noArguments"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("notInValidFrame"));
        }
        this.out(stringBuilder.toString());
    }

    void doInfoLocals() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n = this.propertyGet(DISPLAY_FRAME_NUMBER);
            Frame[] frameArray = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
            Frame frame = frameArray[n];
            Variable[] variableArray = frame.getLocals(this.m_session);
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable = variableArray[i];
                if (!variable.isAttributeSet(32)) continue;
                this.m_exprCache.appendVariable(stringBuilder, variable, this.m_activeIsolate);
                stringBuilder.append(m_newline);
            }
        }
        catch (NullPointerException nullPointerException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noLocals"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("notInValidFrame"));
        }
        this.out(stringBuilder.toString());
    }

    void doInfoScopeChain() throws PlayerDebugException {
        this.waitTilHalted(this.m_activeIsolate);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n = this.propertyGet(DISPLAY_FRAME_NUMBER);
            Frame[] frameArray = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
            Frame frame = frameArray[n];
            Variable[] variableArray = frame.getScopeChain(this.m_session);
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable = variableArray[i];
                this.m_exprCache.appendVariable(stringBuilder, variable, this.m_activeIsolate);
                stringBuilder.append(m_newline);
            }
        }
        catch (NullPointerException nullPointerException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("noScopeChain"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("notInValidFrame"));
        }
        this.out(stringBuilder.toString());
    }

    void doInfoTargets() {
        if (!this.haveConnection()) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
            if (this.m_launchURI != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("uri", this.m_launchURI);
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("runWillLaunchUri", hashMap));
            }
        } else {
            String string = this.m_session.getURI();
            if (string == null || string.length() < 1) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("targetUnknown"));
            } else {
                this.out(string);
            }
        }
    }

    void doInfoSwfs() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            SwfInfo[] swfInfoArray = this.m_fileInfo.getSwfs(this.m_activeIsolate);
            for (int i = 0; i < swfInfoArray.length; ++i) {
                SwfInfo swfInfo = swfInfoArray[i];
                if (swfInfo == null || swfInfo.isUnloaded()) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("swfName", FileInfoCache.nameOfSwf(swfInfo));
                hashMap.put("size", NumberFormat.getInstance().format(swfInfo.getSwfSize()));
                try {
                    int n = swfInfo.getSwdSize(this.m_session);
                    SourceFile[] sourceFileArray = swfInfo.getSourceList(this.m_session);
                    int n2 = Integer.MIN_VALUE;
                    int n3 = Integer.MAX_VALUE;
                    for (int j = 0; j < sourceFileArray.length; ++j) {
                        SourceFile sourceFile = sourceFileArray[j];
                        int n4 = sourceFile.getId();
                        n2 = n4 > n2 ? n4 : n2;
                        n3 = n4 < n3 ? n4 : n3;
                    }
                    hashMap.put("scriptCount", Integer.toString(swfInfo.getSourceCount(this.m_session)));
                    hashMap.put("min", Integer.toString(n3));
                    hashMap.put("max", Integer.toString(n2));
                    hashMap.put("plus", swfInfo.isProcessingComplete() ? "+" : "");
                    hashMap.put("moreInfo", n == 0 ? DebugCLI.getLocalizationManager().getLocalizedTextString("remainingSourceBeingLoaded") : "");
                }
                catch (InProgressException inProgressException) {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("debugInfoBeingLoaded"));
                }
                hashMap.put("url", swfInfo.getUrl());
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("swfInfo", hashMap));
                stringBuilder.append(m_newline);
            }
            this.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSWFs"));
        }
    }

    private int getFileType(SourceFile sourceFile) {
        String string = sourceFile.getName();
        String string2 = sourceFile.getPackageName();
        if (string.startsWith("<") && string.endsWith(">") || string.equals("GeneratedLocale")) {
            return 3;
        }
        for (String string3 : FRAMEWORK_FILE_PACKAGES) {
            if (!string2.startsWith(string3 + '\\') && !string2.startsWith(string3 + '/') && !string2.equals(string3)) continue;
            return 2;
        }
        if (string.startsWith("Actions for")) {
            return 4;
        }
        return 1;
    }

    void buildFileList(StringBuilder stringBuilder, boolean bl) {
        int n;
        SourceFile[] sourceFileArray = this.m_fileInfo.getFileList(this.m_activeIsolate);
        if (sourceFileArray == null) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFilesFound"));
            return;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        block6: for (n = 0; n < sourceFileArray.length; ++n) {
            SourceFile sourceFile = sourceFileArray[n];
            int n2 = this.getFileType(sourceFile);
            int n3 = sourceFile.getId();
            String string = sourceFile.getName() + "#" + n3;
            switch (n2) {
                case 3: {
                    vector3.add(string);
                    continue block6;
                }
                case 2: {
                    vector2.add(string);
                    continue block6;
                }
                case 4: {
                    vector4.add(string);
                    continue block6;
                }
                case 1: {
                    vector.add(string);
                }
            }
        }
        n = this.propertyGet(FILE_LIST_WRAP);
        if (!bl) {
            if (vector4.size() > 0) {
                this.appendStrings(stringBuilder, vector4, vector4.size() > n);
            }
            if (vector2.size() > 0) {
                stringBuilder.append("---" + m_newline);
                this.appendStrings(stringBuilder, vector2, vector2.size() > n);
            }
            if (vector3.size() > 0) {
                stringBuilder.append("---" + m_newline);
                this.appendStrings(stringBuilder, vector3, vector3.size() > n);
            }
            stringBuilder.append("---" + m_newline);
        }
        this.appendStrings(stringBuilder, vector, vector.size() > n);
    }

    void appendStrings(StringBuilder stringBuilder, Vector<String> vector, boolean bl) {
        int n = vector.size();
        int n2 = 0;
        int n3 = this.propertyGet(COLUMN_WIDTH);
        for (int i = 0; i < n; ++i) {
            String string = vector.get(i);
            stringBuilder.append(string);
            if (bl) {
                if ((n2 += string.length() + 2) >= n3) {
                    stringBuilder.append(m_newline);
                    n2 = 0;
                    continue;
                }
                stringBuilder.append(", ");
                continue;
            }
            stringBuilder.append(m_newline);
        }
        if (bl && n2 > 0) {
            stringBuilder.append(m_newline);
        }
    }

    void doInfoFiles() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.hasMoreTokens()) {
                String string = this.nextToken();
                this.listFilesMatching(stringBuilder, string);
            } else {
                this.buildFileList(stringBuilder, false);
            }
            this.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException();
        }
    }

    void doInfoHandle() {
        if (this.hasMoreTokens()) {
            String string = this.nextToken();
            if (!this.m_faultTable.exists(string)) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unrecognizedFault"));
            } else {
                this.listFault(string);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendFaultTitles(stringBuilder);
            Object[] objectArray = this.m_faultTable.names();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.appendFault(stringBuilder, (String)objectArray[i]);
            }
            this.out(stringBuilder.toString());
        }
    }

    void doInfoFuncs() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            if (this.hasMoreTokens()) {
                string = this.nextToken();
                int n = string.equals(".") ? this.propertyGet(LIST_MODULE) : this.parseFileArg(this.m_activeIsolate, -1, string);
                SourceFile sourceFile = this.m_fileInfo.getFile(n, this.m_activeIsolate);
                this.listFunctionsFor(stringBuilder, sourceFile);
            } else {
                SourceFile[] sourceFileArray = this.m_fileInfo.getFileList(this.m_activeIsolate);
                if (sourceFileArray == null) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFilesFound"));
                } else {
                    for (int i = 0; i < sourceFileArray.length; ++i) {
                        SourceFile sourceFile = sourceFileArray[i];
                        this.listFunctionsFor(stringBuilder, sourceFile);
                    }
                }
            }
            this.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noFunctionsFound"));
        }
        catch (ParseException parseException) {
            this.err(parseException.getMessage());
        }
        catch (NoMatchException noMatchException) {
            this.err(noMatchException.getMessage());
        }
        catch (AmbiguousException ambiguousException) {
            this.err(ambiguousException.getMessage());
        }
    }

    void listFunctionsFor(StringBuilder stringBuilder, SourceFile sourceFile) {
        Object[] objectArray = sourceFile.getFunctionNames(this.m_session);
        if (objectArray == null) {
            return;
        }
        Arrays.sort(objectArray);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sourceFile", sourceFile.getName() + "#" + sourceFile.getId());
        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("functionsInSourceFile", hashMap));
        stringBuilder.append(m_newline);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(' ');
            stringBuilder.append((String)object);
            stringBuilder.append(' ');
            stringBuilder.append(sourceFile.getLineForFunctionName(this.m_session, (String)object));
            stringBuilder.append(m_newline);
        }
    }

    void listFilesMatching(StringBuilder stringBuilder, String string) {
        SourceFile[] sourceFileArray = this.m_fileInfo.getFiles(string);
        for (int i = 0; i < sourceFileArray.length; ++i) {
            SourceFile sourceFile = sourceFileArray[i];
            stringBuilder.append(sourceFile.getName());
            stringBuilder.append('#');
            stringBuilder.append(sourceFile.getId());
            stringBuilder.append(m_newline);
        }
    }

    void doInfoSources() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.buildFileList(stringBuilder, true);
            this.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException();
        }
    }

    void doInfoBreak() throws NotConnectedException {
        int n;
        Object object;
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Num Type           Disp Enb Address    What" + m_newline);
        int n4 = this.breakpointCount();
        for (n3 = 0; n3 < n4; ++n3) {
            HashMap<String, String> hashMap;
            Object object2;
            Object object3;
            BreakAction breakAction = this.breakpointAt(n3);
            int n5 = breakAction.getStatus();
            n2 = n5 == 1 ? 1 : 0;
            Location location = breakAction.getLocation();
            object = breakAction.getLocations();
            SourceFile sourceFile = location != null ? location.getFile() : null;
            String string = sourceFile == null ? null : sourceFile.getFunctionNameForLine(this.m_session, location.getLine());
            boolean bl = breakAction.isSingleSwf();
            int n6 = breakAction.getCommandCount();
            int n7 = breakAction.getHits();
            String string2 = breakAction.getConditionString();
            boolean bl2 = breakAction.isSilent();
            int n8 = this.adjustOffsetForUnitTests(sourceFile == null ? 0 : sourceFile.getOffsetForLine(location.getLine()));
            int n9 = breakAction.getId();
            FieldFormat.formatLong(stringBuilder, n9, 3);
            stringBuilder.append(" breakpoint     ");
            if (breakAction.isAutoDisable()) {
                stringBuilder.append("dis  ");
            } else if (breakAction.isAutoDelete()) {
                stringBuilder.append("del  ");
            } else {
                stringBuilder.append("keep ");
            }
            if (breakAction.isEnabled()) {
                stringBuilder.append("y   ");
            } else {
                stringBuilder.append("n   ");
            }
            stringBuilder.append("0x");
            FieldFormat.formatLongToHex(stringBuilder, n8, 8);
            stringBuilder.append(' ');
            if (string != null) {
                object3 = new HashMap<String, String>();
                object3.put("functionName", string);
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inFunctionAt", (Map)object3));
            }
            if (sourceFile != null) {
                stringBuilder.append(sourceFile.getName());
                if (n2 != 0 && bl) {
                    stringBuilder.append("#");
                    stringBuilder.append(sourceFile.getId());
                }
                stringBuilder.append(':');
                stringBuilder.append(location.getLine());
            } else {
                object3 = breakAction.getBreakpointExpression();
                if (object3 != null) {
                    stringBuilder.append((String)object3);
                }
            }
            object3 = new StringBuilder();
            if (object != null) {
                object2 = ((LocationCollection)object).iterator();
                while (object2.hasNext()) {
                    hashMap = (Location)object2.next();
                    ((StringBuilder)object3).append(hashMap.getIsolateId() - 1);
                    if (!object2.hasNext()) continue;
                    ((StringBuilder)object3).append(" / ");
                }
            }
            if (location != null) {
                object2 = new HashMap();
                object2.put("worker", ((StringBuilder)object3).toString());
                stringBuilder.append(" (");
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inWorker", (Map)object2));
                stringBuilder.append(") ");
            }
            switch (n5) {
                case 2: {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotYetResolved"));
                    break;
                }
                case 3: {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointAmbiguous"));
                    break;
                }
                case 4: {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNoCode"));
                }
            }
            if (bl && n2 != 0) {
                try {
                    object2 = this.m_fileInfo.swfForFile(sourceFile, location.getIsolateId());
                    hashMap = new HashMap();
                    hashMap.put("swf", FileInfoCache.nameOfSwf((SwfInfo)object2));
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("inSwf", hashMap));
                }
                catch (NullPointerException nullPointerException) {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("nonRestorable"));
                }
            }
            stringBuilder.append(m_newline);
            if (string2 != null && string2.length() > 0) {
                stringBuilder.append("        ");
                hashMap = new HashMap();
                hashMap.put("breakpointCondition", string2);
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString(DebugCLI.getLocalizationManager().getLocalizedTextString("stopOnlyIfConditionMet", hashMap)));
                stringBuilder.append(m_newline);
            }
            if (n7 > 0) {
                stringBuilder.append("        ");
                hashMap = new HashMap<String, String>();
                hashMap.put("count", Integer.toString(n7));
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointAlreadyHit", hashMap));
                stringBuilder.append(m_newline);
            }
            if (bl2) {
                stringBuilder.append("        ");
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("silentBreakpoint") + m_newline);
            }
            for (int i = 0; i < n6; ++i) {
                stringBuilder.append("        ");
                stringBuilder.append(breakAction.commandAt(i));
                stringBuilder.append(m_newline);
            }
        }
        n3 = this.watchpointCount();
        for (n = 0; n < n3; ++n) {
            WatchAction watchAction = this.watchpointAt(n);
            n2 = watchAction.getId();
            FieldFormat.formatLong(stringBuilder, n2, 4);
            int n10 = watchAction.getKind();
            switch (n10) {
                case 1: {
                    stringBuilder.append("rd watchpoint  ");
                    break;
                }
                case 2: {
                    stringBuilder.append("wr watchpoint  ");
                    break;
                }
                default: {
                    stringBuilder.append("watchpoint     ");
                }
            }
            stringBuilder.append("keep ");
            stringBuilder.append("y   ");
            stringBuilder.append("           ");
            stringBuilder.append(watchAction.getExpr());
            stringBuilder.append(m_newline);
        }
        n = this.catchpointCount();
        for (int i = 0; i < n; ++i) {
            CatchAction catchAction = this.catchpointAt(i);
            int n11 = catchAction.getId();
            FieldFormat.formatLong(stringBuilder, n11, 4);
            object = catchAction.getTypeToCatch();
            if (object == null) {
                object = "*";
            }
            stringBuilder.append("catch          ");
            stringBuilder.append("keep ");
            stringBuilder.append("y   ");
            stringBuilder.append("           ");
            stringBuilder.append((String)object);
            stringBuilder.append(m_newline);
        }
        this.out(stringBuilder.toString());
    }

    void dumpHaltState(boolean bl) throws NotConnectedException, SuspendedException, NoResponseException, NotSupportedException, NotSuspendedException, IOException {
        this.processEvents();
        if (this.hasAnyPendingResumes() != -1 && !bl) {
            return;
        }
        if (!this.m_session.isConnected()) {
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("sessionTerminated"));
            this.exitSession();
        } else {
            if (!this.m_quietMode && this.hasAnythingSuspended()) {
                StringBuilder stringBuilder = new StringBuilder();
                this.dumpBreakLine(bl, stringBuilder);
                StringBuilder stringBuilder2 = new StringBuilder();
                boolean bl2 = this.processBreak(bl, stringBuilder2, this.m_activeIsolate);
                StringBuilder stringBuilder3 = new StringBuilder();
                if (bl2) {
                    this.dumpBreakLine(bl, stringBuilder3);
                } else {
                    stringBuilder3.append((CharSequence)stringBuilder);
                    if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
                        stringBuilder3.append(m_newline);
                    }
                    stringBuilder3.append((CharSequence)stringBuilder2);
                }
                if (stringBuilder3.length() > 0) {
                    this.out(stringBuilder3.toString());
                }
            } else if (!this.m_quietMode) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerDidNotStop"));
            }
            this.m_quietMode = false;
        }
    }

    Location getCurrentLocation() {
        return this.getCurrentLocationIsolate(1);
    }

    Location getCurrentLocationIsolate(int n) {
        Location location = null;
        try {
            Frame[] frameArray = this.m_session.getWorkerSession(n).getFrames();
            this.propertyPut(CURRENT_FRAME_DEPTH, frameArray.length > 0 ? frameArray.length : 0);
            location = frameArray.length > 0 ? frameArray[0].getLocation() : null;
        }
        catch (PlayerDebugException playerDebugException) {
            // empty catch block
        }
        return location;
    }

    void dumpBreakLine(boolean bl, StringBuilder stringBuilder) throws NotConnectedException {
        int n = -1;
        String string = DebugCLI.getLocalizationManager().getLocalizedTextString("unknownFilename");
        int n2 = -1;
        this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
        int n3 = this.getLastStoppedIsolate();
        boolean bl2 = this.m_activeIsolate != n3;
        this.m_activeIsolate = n3;
        this.propertyPut(LIST_WORKER, n3);
        Location location = this.getCurrentLocationIsolate(n3);
        int n4 = 0;
        try {
            n4 = this.m_session.getWorkerSession(n3).suspendReason();
        }
        catch (PlayerDebugException playerDebugException) {
            // empty catch block
        }
        if (n4 == 7) {
            this.m_fileInfo.setDirty();
            this.m_fileInfo.getSwfsIsolate(n3);
            this.processEvents();
            this.propagateBreakpoints(n3);
            this.propertyPut(LIST_LINE, 1);
            this.propertyPut(LIST_WORKER, n3);
            this.propertyPut(LIST_MODULE, 1);
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("additionalCodeLoaded"));
            if (bl2) {
                stringBuilder.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (n3 - 1) + m_newline);
            }
            stringBuilder.append(m_newline);
            if (this.resolveBreakpoints(stringBuilder)) {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("setAdditionalBreakpoints") + m_newline);
            } else {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("fixBreakpoints") + m_newline);
            }
            this.setPromptState(InitialPromptState.SHOWN_ONCE, n3);
        } else if (location == null || location.getFile() == null) {
            if (bl2) {
                stringBuilder.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (n3 - 1) + m_newline);
            }
            this.propertyPut(LAST_FRAME_DEPTH, 0);
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("executionHalted"));
            stringBuilder.append(' ');
            this.appendBreakInfo(stringBuilder, this.m_activeIsolate);
        } else {
            if (bl2) {
                stringBuilder.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (n3 - 1) + m_newline);
            }
            SourceFile sourceFile = location.getFile();
            string = sourceFile.getName();
            n2 = location.getLine();
            String string2 = sourceFile.getFunctionNameForLine(this.m_session, n2);
            int n5 = this.propertyGet(LIST_MODULE);
            int n6 = this.propertyGet(LAST_FRAME_DEPTH);
            int n7 = sourceFile.getId();
            int n8 = this.propertyGet(CURRENT_FRAME_DEPTH);
            this.propertyPut(LAST_FRAME_DEPTH, n8);
            if (!bl || n5 != n7 || n6 != n8) {
                String string3;
                String string4;
                Serializable serializable;
                if (n4 == 3 || n4 == 4) {
                    serializable = new StringBuilder();
                    this.appendReason((StringBuilder)serializable, n4);
                    string4 = ((StringBuilder)serializable).toString();
                } else {
                    n = this.enabledBreakpointIndexOf(location);
                    if (n > -1) {
                        serializable = new HashMap();
                        serializable.put("breakpointNumber", Integer.toString(this.breakpointAt(n).getId()));
                        string4 = DebugCLI.getLocalizationManager().getLocalizedTextString("hitBreakpoint", (Map)((Object)serializable));
                    } else {
                        string4 = DebugCLI.getLocalizationManager().getLocalizedTextString("executionHalted");
                    }
                }
                serializable = new HashMap();
                serializable.put("reasonForHalting", string4);
                serializable.put("fileAndLine", string + ':' + n2);
                if (string2 != null) {
                    serializable.put("functionName", string2);
                    string3 = "haltedInFunction";
                } else {
                    string3 = "haltedInFile";
                }
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString(string3, (Map)((Object)serializable)));
                if (!this.m_fullnameOption) {
                    stringBuilder.append(m_newline);
                }
            }
            this.setListingPosition(n7, n2, n3);
            if (!this.m_fullnameOption) {
                this.appendSource(stringBuilder, sourceFile.getId(), n2, sourceFile.getLine(n2), false);
            }
        }
    }

    private int getLastStoppedIsolate() {
        int n = 1;
        if (this.m_breakIsolates.size() > 0) {
            n = this.m_breakIsolates.get(this.m_breakIsolates.size() - 1);
        }
        return n;
    }

    void appendFullnamePosition(StringBuilder stringBuilder, SourceFile sourceFile, int n) {
        String string = sourceFile.getFullPath();
        if (string.startsWith("file:/")) {
            string = string.substring(6);
        }
        stringBuilder.append('\u001a');
        stringBuilder.append('\u001a');
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(n);
        stringBuilder.append(':');
        stringBuilder.append('0');
        stringBuilder.append(':');
        stringBuilder.append("beg");
        stringBuilder.append(':');
        stringBuilder.append('0');
    }

    void dumpTraceLine(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[trace] ");
        stringBuilder.append(string);
        this.out(stringBuilder.toString());
    }

    void dumpFaultLine(FaultEvent faultEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (faultEvent instanceof ConsoleErrorFault) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenDisplayingConsoleError"));
            stringBuilder.append(' ');
            stringBuilder.append(faultEvent.information);
            String string = faultEvent.stackTrace();
            if (string != null && string.length() > 0) {
                stringBuilder.append("\n").append(string);
            }
        } else {
            String string;
            String string2 = faultEvent.name();
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenDisplayingFault"));
            stringBuilder.append(' ');
            stringBuilder.append(string2);
            if (faultEvent.information != null && faultEvent.information.length() > 0) {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("informationAboutFault"));
                stringBuilder.append(faultEvent.information);
            }
            if ((string = faultEvent.stackTrace()) != null && string.length() > 0) {
                stringBuilder.append("\n").append(string);
            }
        }
        this.out(stringBuilder.toString());
    }

    void handleSwfLoadedEvent(SwfLoadedEvent swfLoadedEvent) {
        this.dumpSwfLoadedLine(swfLoadedEvent);
    }

    void dumpSwfLoadedLine(SwfLoadedEvent swfLoadedEvent) {
        int n = swfLoadedEvent.path.lastIndexOf(63);
        String string = n > -1 ? swfLoadedEvent.path.substring(0, n) : swfLoadedEvent.path;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenSwfLoaded"));
        stringBuilder.append(' ');
        stringBuilder.append(string);
        stringBuilder.append(" - ");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("size", NumberFormat.getInstance().format(swfLoadedEvent.swfSize));
        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("sizeAfterDecompression", hashMap));
        this.out(stringBuilder.toString());
    }

    void propagateBreakpoints(int n) throws NotConnectedException {
        SwfInfo[] swfInfoArray = this.m_fileInfo.getSwfsIsolate(n);
        SwfInfo swfInfo = swfInfoArray.length > 0 ? swfInfoArray[swfInfoArray.length - 1] : null;
        int n2 = this.m_breakpoints.size();
        for (int i = 0; swfInfo != null && i < n2; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            if (breakAction.isSingleSwf() || breakAction.getStatus() != 1 || !breakAction.isPropagable()) continue;
            try {
                Location location = breakAction.getLocation();
                int n3 = location.getLine();
                SourceFile sourceFile = location.getFile();
                Location location2 = this.findAndEnableBreak(swfInfo, sourceFile, n3);
                if (location2 == null) {
                    throw new RuntimeException("newLock == null");
                }
                breakAction.addLocation(location2);
                this.dumpAddedBreakpoint(breakAction);
                continue;
            }
            catch (InProgressException inProgressException) {
                if (this.breakpointCount() <= 0) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("breakpointNumber", Integer.toString(breakAction.getId()));
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotPropagated", hashMap));
            }
        }
    }

    private void dumpAddedBreakpoint(BreakAction breakAction) {
        String string;
        Location location = breakAction.getLocations().last();
        int n = breakAction.getId();
        String string2 = location.getFile().getName();
        int n2 = this.adjustOffsetForUnitTests(location.getFile().getOffsetForLine(location.getLine()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("breakpointNumber", Integer.toString(n));
        hashMap.put("file", string2);
        hashMap.put("line", Integer.toString(location.getLine()));
        if (n2 != 0) {
            hashMap.put("offset", "0x" + Integer.toHexString(n2));
            string = "createdBreakpointWithOffset";
        } else {
            string = "createdBreakpoint";
        }
        this.out(DebugCLI.getLocalizationManager().getLocalizedTextString(string, hashMap));
    }

    void handleSwfUnloadedEvent(SwfUnloadedEvent swfUnloadedEvent) {
        this.dumpSwfUnloadedLine(swfUnloadedEvent);
    }

    void dumpSwfUnloadedLine(SwfUnloadedEvent swfUnloadedEvent) {
        int n = swfUnloadedEvent.path.lastIndexOf(63);
        String string = n > -1 ? swfUnloadedEvent.path.substring(0, n) : swfUnloadedEvent.path;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenSwfUnloaded"));
        stringBuilder.append(' ');
        stringBuilder.append(string);
        this.out(stringBuilder.toString());
    }

    void doContinue() throws NotConnectedException {
        int n = this.m_activeIsolate;
        this.waitTilHalted(n);
        this.setRequestResume(true, n);
        this.m_repeatLine = this.m_currentLine;
    }

    boolean hasAnythingSuspended() throws NotConnectedException {
        boolean bl = false;
        for (Integer n : this.m_breakIsolates) {
            if (!this.m_session.getWorkerSession(n).isSuspended()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    int hasAnyPendingResumes() throws NotConnectedException {
        int n = -1;
        if (this.m_mainState.m_requestResume) {
            return 1;
        }
        for (Integer n2 : this.m_breakIsolates) {
            if (!this.getIsolateState((int)n2.intValue()).m_requestResume) continue;
            n = n2;
            break;
        }
        return n;
    }

    int hasPendingInitialPrompts() throws NotConnectedException {
        int n = -1;
        for (Integer n2 : this.m_breakIsolates) {
            if (this.getPromptState(n2) == InitialPromptState.DONE) continue;
            n = n2;
            break;
        }
        return n;
    }

    public void runningLoop() throws NoResponseException, NotConnectedException, SuspendedException, NotSupportedException, NotSuspendedException, IOException {
        int n;
        int n2 = this.propertyGet(UPDATE_DELAY);
        boolean bl = this.propertyGet(NO_WAITING) == 1;
        boolean bl2 = false;
        boolean bl3 = !this.haveConnection();
        boolean bl4 = false;
        int n3 = 1;
        if (!bl3) {
            bl4 = this.hasAnythingSuspended();
        }
        if (bl4 && this.m_breakIsolates.size() > 0) {
            n3 = this.m_breakIsolates.get(this.m_breakIsolates.size() - 1);
        }
        if (bl3 || bl4 && this.hasAnyPendingResumes() == -1) {
            this.processEvents();
            bl2 = true;
            if (!bl3) {
                n = -1;
                n = this.m_lastPromptIsolate != -1 && this.getPromptState(this.m_lastPromptIsolate) != InitialPromptState.DONE ? this.m_lastPromptIsolate : this.hasPendingInitialPrompts();
                if (n != -1 && n == this.m_activeIsolate) {
                    this.dumpInitialPrompt(n);
                }
            }
        }
        while (!bl2) {
            Object object;
            IsolateSession isolateSession;
            if (!bl) {
                this.m_keyboardReadRequest = true;
            }
            if ((n = this.hasAnyPendingResumes()) != -1) {
                try {
                    isolateSession = this.m_session.getWorkerSession(n);
                    if (this.getStepResume(n)) {
                        isolateSession.stepContinue();
                    } else {
                        isolateSession.resume();
                    }
                    this.setPromptState(InitialPromptState.DONE, n);
                    this.removeBreakIsolate(n);
                }
                catch (NotSuspendedException notSuspendedException) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("playerAlreadyRunning"));
                }
                this.setRequestResume(false, n);
                this.setRequestHalt(false, n);
                this.setStepResume(false, n);
            }
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.processEvents();
            if (!this.haveConnection()) {
                bl2 = true;
                this.dumpHaltState(false);
                continue;
            }
            if (this.hasAnythingSuspended()) {
                n3 = this.m_breakIsolates.size() > 0 ? this.m_breakIsolates.get(this.m_breakIsolates.size() - 1) : 1;
                int n4 = 3;
                object = this.m_session.getWorkerSession(n3);
                while (n4-- > 0 && object.suspendReason() == 0) {
                    try {
                        Thread.sleep(100L);
                        this.processEvents();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.dumpHaltState(false);
                if (this.getRequestResume(n3)) continue;
                bl2 = true;
                continue;
            }
            if (bl) {
                bl2 = true;
                continue;
            }
            if (this.m_keyboardInput.isEmpty() || System.getProperty("fdbunit") != null) continue;
            this.m_keyboardInput.clear();
            try {
                if (!this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("doYouWantToHalt"))) continue;
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("attemptingToHalt"));
                isolateSession = this.m_session.getWorkerSession(this.m_activeIsolate);
                isolateSession.suspend();
                this.getIsolateState((int)this.m_activeIsolate).m_requestHalt = true;
                if (!this.haveConnection()) {
                    this.dumpHaltState(false);
                    bl2 = true;
                    continue;
                }
                if (isolateSession.isSuspended()) continue;
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotHalt"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("escapingFromDebuggerPendingLoop"));
                this.propertyPut(NO_WAITING, 1);
                bl2 = true;
            }
            catch (IOException iOException) {
                object = new HashMap();
                object.put("error", iOException.getMessage());
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("continuingDueToError", (Map)object));
            }
            catch (SuspendedException suspendedException) {}
        }
        if (bl) {
            this.processEvents();
        }
    }

    private void dumpInitialPrompt(int n) throws NotConnectedException {
        boolean bl = this.m_activeIsolate != n;
        this.m_activeIsolate = n;
        if (bl) {
            this.propertyPut(LIST_WORKER, n);
            this.propertyPut(LIST_LINE, 1);
            this.propertyPut(LIST_MODULE, 1);
            this.propagateBreakpoints(n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getPromptState(n) == InitialPromptState.NEVER_SHOWN) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("additionalCodeLoaded"));
            stringBuilder.append(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " " + (n - 1) + m_newline);
            stringBuilder.append(m_newline);
            this.setPromptState(InitialPromptState.SHOWN_ONCE, n);
        }
        if (this.resolveBreakpoints(stringBuilder)) {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("setAdditionalBreakpoints") + m_newline);
        } else {
            stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("fixBreakpoints") + m_newline);
        }
        if (stringBuilder.length() > 0) {
            this.out(stringBuilder.toString());
        }
    }

    private void removeBreakIsolate(int n) {
        for (int i = 0; i < this.m_breakIsolates.size(); ++i) {
            int n2 = this.m_breakIsolates.get(i);
            if (n2 != n) continue;
            this.m_breakIsolates.remove(i);
            break;
        }
    }

    void doHome() {
        try {
            Location location = this.getCurrentLocationIsolate(this.m_activeIsolate);
            SourceFile sourceFile = location.getFile();
            int n = sourceFile.getId();
            int n2 = location.getLine();
            int n3 = location.getIsolateId();
            this.setListingPosition(n, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("currentLocationUnknown"));
        }
    }

    void dumpStep() throws NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        this.dumpHaltState(true);
    }

    private void stepWithTimeout(AnyKindOfStep anyKindOfStep, int n) throws PlayerDebugException {
        int n2 = this.m_session.getPreference("$responsetimeout");
        long l = System.currentTimeMillis() + (long)n2;
        anyKindOfStep.step();
        IsolateSession isolateSession = this.m_session.getWorkerSession(n);
        while (System.currentTimeMillis() < l && !isolateSession.isSuspended()) {
            this.processEvents();
            if (this.m_session.isSuspended()) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (System.currentTimeMillis() >= l && !isolateSession.isSuspended()) {
            throw new NoResponseException(n2);
        }
    }

    private boolean allowedToStep(int n) throws NotConnectedException {
        int n2 = this.m_session.getWorkerSession(n).suspendReason();
        if (n2 == 7) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("cannotStep"));
            return false;
        }
        return true;
    }

    void doStep() throws PlayerDebugException, IOException {
        this.waitTilHalted(this.m_activeIsolate);
        if (!this.allowedToStep(this.m_activeIsolate)) {
            return;
        }
        int n = 1;
        if (this.hasMoreTokens()) {
            n = this.nextIntToken();
        }
        DebugCLIIsolateState debugCLIIsolateState = this.getIsolateState(this.m_activeIsolate);
        block0: while (n-- > 0) {
            this.stepWithTimeout(new AnyKindOfStep(){

                @Override
                public void step() throws PlayerDebugException {
                    DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepInto();
                }
            }, this.m_activeIsolate);
            while (true) {
                this.dumpStep();
                if (!debugCLIIsolateState.m_requestResume) continue block0;
                debugCLIIsolateState.m_requestResume = false;
                this.stepWithTimeout(new AnyKindOfStep(){

                    @Override
                    public void step() throws PlayerDebugException {
                        DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepContinue();
                    }
                }, this.m_activeIsolate);
            }
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doNext() throws PlayerDebugException, IOException {
        block6: {
            this.waitTilHalted(this.m_activeIsolate);
            if (!this.allowedToStep(this.m_activeIsolate)) {
                return;
            }
            int n = 1;
            if (this.hasMoreTokens()) {
                n = this.nextIntToken();
            }
            DebugCLIIsolateState debugCLIIsolateState = this.getIsolateState(this.m_activeIsolate);
            try {
                block2: while (n-- > 0) {
                    this.stepWithTimeout(new AnyKindOfStep(){

                        @Override
                        public void step() throws PlayerDebugException {
                            DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepOver();
                        }
                    }, this.m_activeIsolate);
                    while (true) {
                        this.dumpStep();
                        if (!debugCLIIsolateState.m_requestResume) continue block2;
                        debugCLIIsolateState.m_requestResume = false;
                        this.stepWithTimeout(new AnyKindOfStep(){

                            @Override
                            public void step() throws PlayerDebugException {
                                DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepContinue();
                            }
                        }, this.m_activeIsolate);
                    }
                }
            }
            catch (NoResponseException noResponseException) {
                if (n <= 0) break block6;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("count", Integer.toString(n));
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("abortingStep", hashMap));
            }
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doFinish() throws PlayerDebugException, IOException {
        this.waitTilHalted(this.m_activeIsolate);
        if (!this.allowedToStep(this.m_activeIsolate)) {
            return;
        }
        DebugCLIIsolateState debugCLIIsolateState = this.getIsolateState(this.m_activeIsolate);
        try {
            int n = this.propertyGet(CURRENT_FRAME_DEPTH);
            if (n < 2) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("finishCommandNotMeaningfulOnOutermostFrame"));
            } else {
                this.stepWithTimeout(new AnyKindOfStep(){

                    @Override
                    public void step() throws PlayerDebugException {
                        DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepOut();
                    }
                }, this.m_activeIsolate);
                while (true) {
                    this.dumpStep();
                    if (!debugCLIIsolateState.m_requestResume) break;
                    debugCLIIsolateState.m_requestResume = false;
                    this.stepWithTimeout(new AnyKindOfStep(){

                        @Override
                        public void step() throws PlayerDebugException {
                            DebugCLI.this.m_session.getWorkerSession(DebugCLI.this.m_activeIsolate).stepContinue();
                        }
                    }, this.m_activeIsolate);
                }
                this.m_repeatLine = this.m_currentLine;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("finishCommandNotMeaningfulWithoutStack"));
        }
    }

    void doDelete() throws IOException, AmbiguousException, NotConnectedException, SuspendedException, NotSupportedException, NotSuspendedException, NoResponseException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            if (!this.hasMoreTokens()) {
                if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askDeleteAllBreakpoints"))) {
                    int n = this.breakpointCount();
                    for (int i = n - 1; i > -1; --i) {
                        this.removeBreakpointAt(i);
                    }
                    this.removeAllWatchpoints();
                    this.removeAllCatchpoints();
                }
            } else {
                String string = this.nextToken();
                int n = this.disableCommandFor(string);
                int n2 = -1;
                if (n == 25) {
                    this.doUnDisplay();
                } else {
                    n2 = n == 6 ? this.nextIntToken() : Integer.parseInt(string);
                    do {
                        try {
                            int n3 = this.breakpointIndexOf(n2);
                            if (n3 > -1) {
                                this.removeBreakpointAt(n3);
                                continue;
                            }
                            n3 = this.watchpointIndexOf(n2);
                            if (n3 > -1) {
                                this.removeWatchpointAt(n3);
                                continue;
                            }
                            n3 = this.catchpointIndexOf(n2);
                            this.removeCatchpointAt(n3);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("breakpointNumber", this.m_currentToken);
                            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", hashMap));
                        }
                    } while ((n2 = this.hasMoreTokens() ? this.nextIntToken() : -1) > -1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doBreak() throws NotConnectedException, NoResponseException, NotSupportedException, NotSuspendedException, IOException, SuspendedException {
        int n;
        int n2 = n = this.propertyGet(LIST_WORKER);
        this.waitTilHalted(n);
        int n3 = this.propertyGet(LIST_MODULE);
        int n4 = this.propertyGet(LIST_LINE);
        FileLocation[] fileLocationArray = new FileLocation[]{};
        boolean bl = false;
        String string = null;
        boolean bl2 = true;
        try {
            if (this.hasMoreTokens()) {
                string = this.nextToken();
                bl2 = !string.contains("@");
                fileLocationArray = this.parseLocationArg(n3, n4, string);
            } else {
                FileLocation fileLocation;
                Location location = this.getCurrentLocationIsolate(n);
                FileLocation[] fileLocationArray2 = location.getFile();
                fileLocationArray[0] = fileLocation = new FileLocation(n, fileLocationArray2.getId(), location.getLine());
            }
            boolean bl3 = false;
            for (FileLocation fileLocation : fileLocationArray) {
                n = fileLocation.getIsolateId();
                n3 = fileLocation.getModule();
                n4 = fileLocation.getLine();
                if (n != n2) {
                    bl3 = true;
                    bl = this.swapActiveWorkerAndStop(n);
                }
                BreakAction breakAction = this.addBreakpoint(n3, n4, n, bl2);
                this.dumpAddedBreakpoint(breakAction);
                this.propertyPut(BPNUM, breakAction.getId());
                if (!bl3) continue;
                this.continueAndSwapActiveWorkerBack(n2, bl);
                bl3 = false;
            }
        }
        catch (ParseException parseException) {
            this.err(parseException.getMessage());
        }
        catch (AmbiguousException ambiguousException) {
            this.err(ambiguousException.getMessage());
        }
        catch (NoMatchException noMatchException) {
            BreakAction breakAction = this.addUnresolvedBreakpoint(string, this.m_activeIsolate);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("breakpointNumber", Integer.toString(breakAction.getId()));
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointCreatedButNotYetResolved", hashMap));
            this.propertyPut(BPNUM, breakAction.getId());
        }
        catch (NullPointerException nullPointerException) {
            String string2;
            try {
                string2 = this.m_fileInfo.getFile(n3, n).getName() + "#" + n3;
            }
            catch (Exception exception) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("fileNumber", Integer.toString(n3));
                string2 = DebugCLI.getLocalizationManager().getLocalizedTextString("fileNumber", hashMap);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("filename", string2);
            hashMap.put("line", Integer.toString(n4));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotSetNoCode", hashMap));
            this.continueAndSwapActiveWorkerBack(n2, bl);
        }
        catch (InProgressException inProgressException) {
            inProgressException.printStackTrace();
        }
    }

    private boolean swapActiveWorkerAndStop(int n) throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException, SuspendedException {
        return this.swapActiveWorkerAndStop(n, true);
    }

    private boolean swapActiveWorkerAndStop(int n, boolean bl) throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException, SuspendedException {
        this.doWorker(n, bl);
        IsolateSession isolateSession = this.m_session.getWorkerSession(this.m_activeIsolate);
        boolean bl2 = isolateSession.isSuspended();
        if (!bl2) {
            isolateSession.suspend();
            this.waitTilHalted(this.m_activeIsolate);
        }
        return bl2;
    }

    private void continueAndSwapActiveWorkerBack(int n, boolean bl) throws NotConnectedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        this.continueAndSwapActiveWorkerBack(n, bl, true);
    }

    private void continueAndSwapActiveWorkerBack(int n, boolean bl, boolean bl2) throws NotConnectedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        if (!bl) {
            this.m_quietMode = !bl2;
            this.doContinue();
        }
        if (this.m_activeIsolate != n) {
            this.doWorker(n, bl2);
        }
    }

    void doClear() throws NotConnectedException, SuspendedException, NoResponseException, NotSupportedException, NotSuspendedException, IOException {
        block9: {
            int n = this.propertyGet(LIST_MODULE);
            int n2 = this.propertyGet(LIST_LINE);
            int n3 = this.propertyGet(LIST_WORKER);
            String string = null;
            this.waitTilHalted(this.m_activeIsolate);
            try {
                if (this.hasMoreTokens()) {
                    FileLocation[] fileLocationArray;
                    string = this.nextToken();
                    for (FileLocation fileLocation : fileLocationArray = this.parseLocationArg(n, n2, string)) {
                        n3 = fileLocation.getIsolateId();
                        n = fileLocation.getModule();
                        n2 = fileLocation.getLine();
                        try {
                            this.removeBreakpoint(n, n2, n3);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointLocationUnknown"));
                        }
                        catch (NullPointerException nullPointerException) {
                            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotCleared"));
                        }
                    }
                }
            }
            catch (ParseException parseException) {
                this.err(parseException.getMessage());
            }
            catch (AmbiguousException ambiguousException) {
                this.err(ambiguousException.getMessage());
            }
            catch (NoMatchException noMatchException) {
                if (this.removeUnresolvedBreakpoint(string) != null) break block9;
                this.err(noMatchException.getMessage());
            }
        }
    }

    BreakAction removeBreakpoint(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException, NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        int n4 = this.breakpointIndexOf(n, n2, n3);
        return this.removeBreakpointAt(n4, n3);
    }

    BreakAction removeUnresolvedBreakpoint(String string) throws NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        int n = this.breakpointCount();
        for (int i = 0; i < n; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            String string2 = breakAction.getBreakpointExpression();
            if (string2 == null || !string2.equals(string)) continue;
            this.m_breakpoints.removeElementAt(i);
            return breakAction;
        }
        return null;
    }

    private BreakAction removeBreakpointAt(int n, int n2) throws ArrayIndexOutOfBoundsException, NotConnectedException, NoResponseException, NotSupportedException, SuspendedException, NotSuspendedException, IOException {
        BreakAction breakAction = this.breakpointAt(n);
        if (breakAction.getStatus() == 1) {
            int n3 = this.m_activeIsolate;
            boolean bl = false;
            Location location = null;
            Iterator<Location> iterator = breakAction.getLocations().iterator();
            while (iterator.hasNext()) {
                location = iterator.next();
                if (location.getIsolateId() != n2) continue;
                boolean bl2 = false;
                if (location.getIsolateId() != n3) {
                    bl2 = true;
                    bl = this.swapActiveWorkerAndStop(location.getIsolateId());
                }
                LocationCollection locationCollection = new LocationCollection();
                locationCollection.add(location);
                this.breakDisableRequest(locationCollection);
                breakAction.getLocations().remove(location);
                if (breakAction.getLocations().isEmpty()) {
                    this.m_breakpoints.removeElementAt(n);
                }
                if (!bl2) continue;
                this.continueAndSwapActiveWorkerBack(n3, bl);
            }
        } else if (breakAction.getStatus() == 2) {
            this.m_breakpoints.removeElementAt(n);
        }
        return breakAction;
    }

    BreakAction removeBreakpointAt(int n) throws ArrayIndexOutOfBoundsException, NotConnectedException, NoResponseException, NotSupportedException, SuspendedException, NotSuspendedException, IOException {
        BreakAction breakAction = this.breakpointAt(n);
        if (breakAction.getStatus() == 1) {
            int n2 = this.m_activeIsolate;
            Iterator<Location> iterator = breakAction.getLocations().iterator();
            while (iterator.hasNext()) {
                Location location = iterator.next();
                if (location.getIsolateId() != n2) {
                    boolean bl = this.swapActiveWorkerAndStop(breakAction.getLocation().getIsolateId());
                    LocationCollection locationCollection = new LocationCollection();
                    locationCollection.add(location);
                    this.breakDisableRequest(locationCollection);
                    this.continueAndSwapActiveWorkerBack(n2, bl);
                    continue;
                }
                this.breakDisableRequest(breakAction.getLocations());
            }
            this.m_breakpoints.removeElementAt(n);
        } else if (breakAction.getStatus() == 2) {
            this.m_breakpoints.removeElementAt(n);
        }
        return breakAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BreakAction addBreakpoint(int n, int n2, int n3, boolean bl) throws NotConnectedException, NullPointerException, InProgressException {
        BreakAction breakAction;
        boolean bl2;
        SourceFile sourceFile = this.m_fileInfo.getFile(n, n3);
        int n4 = this.breakpointIndexOf(n, n2, 0, true, -1);
        int n5 = this.breakpointIndexOf(n, n2, 0, true, n3);
        boolean bl3 = n5 == -1 && n4 == -1;
        boolean bl4 = bl2 = n5 == -1 && n4 > -1;
        if (bl3) {
            LocationCollection locationCollection = this.enableBreak(sourceFile, n2, n3);
            breakAction = new BreakAction(locationCollection);
            breakAction.setEnabled(true);
            breakAction.setSingleSwf(this.m_fileInfo.isSwfFilterOn());
            breakAction.setPropagable(bl);
            this.breakpointAdd(breakAction);
            return breakAction;
        } else {
            if (!bl2) return this.breakpointAt(n5);
            breakAction = this.breakpointAt(n4);
            if (breakAction == null) return breakAction;
            SwfInfo[] swfInfoArray = this.m_fileInfo.getSwfsIsolate(n3);
            SwfInfo swfInfo = swfInfoArray.length > 0 ? swfInfoArray[swfInfoArray.length - 1] : null;
            Location location = this.findAndEnableBreak(swfInfo, sourceFile, n2);
            if (location == null) throw new RuntimeException("newLock == null");
            breakAction.addLocation(location);
        }
        return breakAction;
    }

    private BreakAction addUnresolvedBreakpoint(String string, int n) {
        BreakAction breakAction = new BreakAction(string);
        breakAction.setEnabled(true);
        breakAction.setSingleSwf(this.m_fileInfo.isSwfFilterOn());
        this.breakpointAdd(breakAction);
        return breakAction;
    }

    private boolean resolveBreakpoints(StringBuilder stringBuilder) {
        int n = this.breakpointCount();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            try {
                this.tryResolveBreakpoint(breakAction, stringBuilder);
                continue;
            }
            catch (Exception exception) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("breakpointNumber", Integer.toString(breakAction.getId()));
                hashMap.put("expression", breakAction.getBreakpointExpression());
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("attemptingToResolve", hashMap));
                stringBuilder.append(m_newline);
                stringBuilder.append(exception.getMessage());
                stringBuilder.append(m_newline);
                bl = false;
            }
        }
        return bl;
    }

    private boolean tryResolveBreakpoint(BreakAction breakAction, StringBuilder stringBuilder) throws AmbiguousException {
        boolean bl;
        int n = breakAction.getStatus();
        boolean bl2 = bl = n == 1;
        if (n == 2 || bl) {
            try {
                FileLocation[] fileLocationArray;
                this.waitTilHalted(this.m_activeIsolate);
                int n2 = this.propertyGet(LIST_MODULE);
                int n3 = this.propertyGet(LIST_LINE);
                String string = breakAction.getBreakpointExpression();
                if (string != null && (fileLocationArray = this.parseLocationArg(n2, n3, string, false)).length == 1) {
                    String string2;
                    int n4 = fileLocationArray[0].getIsolateId();
                    n2 = fileLocationArray[0].getModule();
                    n3 = fileLocationArray[0].getLine();
                    SourceFile sourceFile = this.m_fileInfo.getFile(n2, n4);
                    LocationCollection locationCollection = this.enableBreak(sourceFile, n3, n4);
                    if (locationCollection.isEmpty()) {
                        throw new NullPointerException(DebugCLI.getLocalizationManager().getLocalizedTextString("noExecutableCode"));
                    }
                    breakAction.setLocations(locationCollection);
                    Location location = locationCollection.first();
                    SourceFile sourceFile2 = location != null ? location.getFile() : null;
                    String string3 = sourceFile2 == null ? null : sourceFile2.getFunctionNameForLine(this.m_session, location.getLine());
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("breakpointNumber", Integer.toString(breakAction.getId()));
                    if (breakAction.isSingleSwf() && sourceFile2 != null) {
                        String string4 = sourceFile2.getName();
                        string4 = string4 + "#" + sourceFile2.getId();
                        hashMap.put("file", string4);
                    }
                    hashMap.put("line", location.getLine());
                    if (string3 != null) {
                        hashMap.put("functionName", string3);
                        string2 = "resolvedBreakpointToFunction";
                    } else {
                        string2 = "resolvedBreakpointToFile";
                    }
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString(string2, hashMap));
                    stringBuilder.append(m_newline);
                    stringBuilder.append(m_newline);
                    bl |= true;
                }
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (NoMatchException noMatchException) {
            }
            catch (ParseException parseException) {
                if (Trace.error) {
                    Trace.trace(parseException.toString());
                }
            }
            catch (AmbiguousException ambiguousException) {
                breakAction.setStatus(3);
                throw ambiguousException;
            }
            catch (NullPointerException nullPointerException) {
                breakAction.setStatus(4);
                throw nullPointerException;
            }
        }
        return bl;
    }

    LocationCollection enableBreak(SourceFile sourceFile, int n, int n2) throws NotConnectedException {
        LocationCollection locationCollection = new LocationCollection();
        boolean bl = this.m_fileInfo.isSwfFilterOn();
        SwfInfo swfInfo = this.m_fileInfo.getSwfFilter();
        if (bl) {
            Location location;
            block7: {
                location = null;
                try {
                    location = this.findAndEnableBreak(swfInfo, sourceFile, n);
                }
                catch (InProgressException inProgressException) {
                    if (!Trace.error) break block7;
                    Trace.trace((swfInfo == null ? "SWF " : swfInfo.getUrl()) + " still loading, breakpoint at " + sourceFile.getName() + ":" + n + " not set");
                }
            }
            locationCollection.add(location);
        } else {
            SwfInfo[] swfInfoArray;
            for (SwfInfo swfInfo2 : swfInfoArray = this.m_fileInfo.getSwfs(n2)) {
                Location location;
                block8: {
                    swfInfo = swfInfo2;
                    if (swfInfo == null) continue;
                    location = null;
                    try {
                        location = this.findAndEnableBreak(swfInfo, sourceFile, n);
                    }
                    catch (InProgressException inProgressException) {
                        if (!Trace.error) break block8;
                        Trace.trace(swfInfo.getUrl() + " still loading, breakpoint at " + sourceFile.getName() + ":" + n + " not set");
                    }
                }
                if (location == null) continue;
                locationCollection.add(location);
            }
        }
        return locationCollection;
    }

    Location findAndEnableBreak(SwfInfo swfInfo, SourceFile sourceFile, int n) throws NotConnectedException, InProgressException {
        if (swfInfo == null) {
            return this.breakEnableRequest(sourceFile.getId(), n, swfInfo.getIsolateId());
        }
        for (SourceFile sourceFile2 : this.getSimilarSourceFilesInSwf(swfInfo, sourceFile)) {
            Location location = this.breakEnableRequest(sourceFile2.getId(), n, swfInfo.getIsolateId());
            if (location == null) continue;
            return location;
        }
        return null;
    }

    private List<SourceFile> getSimilarSourceFilesInSwf(SwfInfo swfInfo, SourceFile sourceFile) throws InProgressException {
        if (!(swfInfo.isProcessingComplete() || swfInfo instanceof DSwfInfo && ((DSwfInfo)swfInfo).hasAllSource())) {
            throw new InProgressException();
        }
        LinkedList<SourceFile> linkedList = new LinkedList<SourceFile>();
        for (SourceFile sourceFile2 : swfInfo.getSourceList(this.m_session)) {
            if (!this.m_fileInfo.filesMatch(sourceFile, sourceFile2)) continue;
            linkedList.add(sourceFile2);
        }
        return linkedList;
    }

    Location breakEnableRequest(int n, int n2, int n3) throws NotConnectedException {
        Location location = null;
        try {
            location = this.m_session.getWorkerSession(n3).setBreakpoint(n, n2);
        }
        catch (NoResponseException noResponseException) {
            // empty catch block
        }
        return location;
    }

    void breakDisableRequest(LocationCollection locationCollection) throws NotConnectedException {
        int n = 0;
        boolean bl = false;
        Location location = locationCollection.first();
        do {
            if ((n = this.breakpointIndexOf(location, n)) <= -1) continue;
            if (this.breakpointAt(n).isEnabled()) {
                bl = true;
                try {
                    this.m_session.clearBreakpoint(location);
                }
                catch (NoResponseException noResponseException) {}
                continue;
            }
            ++n;
        } while (n > -1 && !bl);
    }

    BreakAction breakpointAt(int n) {
        return this.m_breakpoints.elementAt(n);
    }

    boolean breakpointAdd(BreakAction breakAction) {
        return this.m_breakpoints.add(breakAction);
    }

    int breakpointCount() {
        return this.m_breakpoints.size();
    }

    int breakpointIndexOf(int n, int n2) {
        return this.breakpointIndexOf(n, n2, 0, true);
    }

    int breakpointIndexOf(int n, int n2, int n3) {
        return this.breakpointIndexOf(n, n2, 0, true, n3);
    }

    int breakpointIndexOf(Location location, int n) {
        return this.breakpointIndexOf(location.getFile().getId(), location.getLine(), n, true);
    }

    int enabledBreakpointIndexOf(Location location) {
        return this.breakpointIndexOf(location.getFile().getId(), location.getLine(), 0, false);
    }

    int breakpointIndexOf(int n, int n2, int n3, boolean bl) {
        return this.breakpointIndexOf(n, n2, n3, bl, this.m_activeIsolate);
    }

    int breakpointIndexOf(int n, int n2, int n3, boolean bl, int n4) {
        int n5 = this.breakpointCount();
        int n6 = -1;
        for (int i = n3; n6 < 0 && i < n5; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            if (!breakAction.locationMatches(n, n2, n4) || !bl && !breakAction.isEnabled()) continue;
            n6 = i;
        }
        return n6;
    }

    int breakpointIndexOf(int n) {
        int n2 = this.breakpointCount();
        int n3 = -1;
        for (int i = 0; n3 < 0 && i < n2; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            if (breakAction.getId() != n) continue;
            n3 = i;
        }
        return n3;
    }

    DisplayAction displayAt(int n) {
        return this.m_displays.get(n);
    }

    boolean displayAdd(DisplayAction displayAction) {
        return this.m_displays.add(displayAction);
    }

    void displayRemoveAt(int n) {
        this.m_displays.remove(n);
    }

    int displayCount() {
        return this.m_displays.size();
    }

    int displayIndexOf(int n) {
        int n2 = this.displayCount();
        int n3 = -1;
        for (int i = 0; n3 < 0 && i < n2; ++i) {
            DisplayAction displayAction = this.displayAt(i);
            if (displayAction.getId() != n) continue;
            n3 = i;
        }
        return n3;
    }

    void doSet() throws NotConnectedException {
        try {
            ValueExp valueExp = null;
            if (!this.hasMoreTokens()) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("setCommand"));
            } else {
                String string = this.restOfLine();
                valueExp = this.parseExpression(string);
                if (valueExp != null) {
                    if (!valueExp.containsAssignment()) {
                        throw new IllegalAccessException("=");
                    }
                    this.evalExpression(valueExp, this.m_activeIsolate);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("operator", illegalAccessException.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("missingOperator", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    void doPrint() throws NotConnectedException {
        try {
            Object object;
            Object object2 = null;
            boolean bl = false;
            if (!this.hasMoreTokens()) {
                try {
                    object2 = this.m_exprCache.get("$");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandHistoryIsEmpty"));
                    throw new NullPointerException();
                }
            } else {
                String string = this.restOfLine();
                object = this.parseExpression(string);
                if (object.containsAssignment()) {
                    throw new IllegalAccessException();
                }
                object2 = this.evalExpression((ValueExp)object, (int)this.m_activeIsolate).value;
                bl = object.isLookupMembers();
            }
            int n = this.m_exprCache.add(object2);
            object = new StringBuilder();
            ((StringBuilder)object).append('$');
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(" = ");
            if (object2 instanceof Variable) {
                object2 = ((Variable)object2).getValue();
            }
            if (object2 instanceof InternalProperty) {
                ((StringBuilder)object).append(((InternalProperty)object2).valueOf());
            } else if (bl) {
                ((StringBuilder)object).append(object2);
            } else {
                this.m_exprCache.appendVariableValue((StringBuilder)object, object2, this.m_activeIsolate);
            }
            this.out(((StringBuilder)object).toString());
            this.m_repeatLine = this.m_currentLine;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("number", arrayIndexOutOfBoundsException.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("historyHasNotReached", hashMap));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSideEffectsAllowed"));
        }
        catch (NoSuchVariableException noSuchVariableException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("variable", noSuchVariableException.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    ValueExp parseExpression(String string) {
        ValueExp valueExp = null;
        try {
            valueExp = this.m_exprCache.parse(string);
        }
        catch (ParseException parseException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("expressionCouldNotBeParsed") + " " + parseException.getMessage());
        }
        catch (IOException iOException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("expressionCouldNotBeParsed") + " " + string);
        }
        return valueExp;
    }

    ExpressionCache.EvaluationResult evalExpression(ValueExp valueExp, int n) {
        return this.evalExpression(valueExp, true, n);
    }

    ExpressionCache.EvaluationResult evalExpression(ValueExp valueExp, boolean bl, int n) {
        ExpressionCache.EvaluationResult evaluationResult;
        block8: {
            evaluationResult = null;
            try {
                evaluationResult = this.m_exprCache.evaluate(valueExp, n);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                if (bl) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("variable", noSuchVariableException.getMessage());
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", hashMap));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("value", numberFormatException.getMessage());
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotConvertToNumber", hashMap));
                }
            }
            catch (PlayerFaultException playerFaultException) {
                if (bl) {
                    this.err(playerFaultException.getMessage());
                }
            }
            catch (PlayerDebugException playerDebugException) {
                if (!bl) break block8;
                this.err(playerDebugException.getMessage());
            }
        }
        return evaluationResult;
    }

    void doMcTree() throws NotConnectedException, NotSuspendedException, NoResponseException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            Object object;
            String string = this.nextToken();
            String string2 = "_target";
            boolean bl = false;
            Object object2 = null;
            String string3 = null;
            if (this.hasMoreTokens()) {
                string2 = this.nextToken();
                while (this.hasMoreTokens()) {
                    object = this.nextToken();
                    if (!((String)object).equalsIgnoreCase("fullpath")) continue;
                    bl = true;
                }
            }
            object = this.parseExpression(string);
            object2 = this.evalExpression((ValueExp)object, (int)this.m_activeIsolate).value;
            StringBuilder stringBuilder = new StringBuilder();
            if (object2 instanceof Variable) {
                string3 = ((Variable)object2).getName();
                object2 = ((Variable)object2).getValue();
            }
            if (!(object2 instanceof Value)) {
                throw new NoSuchVariableException(object2);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.dumpTree(new HashMap<Object, String>(), arrayList, string3, (Value)object2, string2);
            this.treeResults(stringBuilder, arrayList, string2, bl);
            this.out(stringBuilder.toString());
        }
        catch (NoSuchVariableException noSuchVariableException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("variable", noSuchVariableException.getMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    void doViewSwf() {
        try {
            if (this.hasMoreTokens()) {
                String string = this.nextToken();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("swf", string);
                if (this.m_fileInfo.setSwfFilter(string)) {
                    this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("commandsLimitedToSpecifiedSwf", hashMap));
                } else {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notValidSwf", hashMap));
                }
            } else {
                this.m_fileInfo.setSwfFilter(null);
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("commandsApplyToAllSwfs"));
            }
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
    }

    void doUp() throws PlayerDebugException {
        int n = this.propertyGet(DISPLAY_FRAME_NUMBER) + 1;
        try {
            this.propertyPut(DISPLAY_FRAME_NUMBER, n);
            this.dumpFrame(n);
            this.setListingToFrame(n);
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("frameNumber", Integer.toString(n));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("frameDoesNotExist", hashMap));
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doDown() throws PlayerDebugException {
        int n = this.propertyGet(DISPLAY_FRAME_NUMBER) - 1;
        try {
            this.propertyPut(DISPLAY_FRAME_NUMBER, n);
            this.dumpFrame(n);
            this.setListingToFrame(n);
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("frameNumber", Integer.toString(n));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("frameDoesNotExist", hashMap));
        }
        this.m_repeatLine = this.m_currentLine;
    }

    void doFrame() throws PlayerDebugException {
        int n = 0;
        try {
            if (this.hasMoreTokens()) {
                n = this.nextIntToken();
            }
            this.propertyPut(DISPLAY_FRAME_NUMBER, n);
            this.dumpFrame(n);
            this.setListingToFrame(n);
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notANumber", hashMap));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("frameNumber", Integer.toString(n));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("frameDoesNotExist", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noActiveSession"));
        }
    }

    void dumpFrame(int n) throws PlayerDebugException, ArrayIndexOutOfBoundsException {
        StringBuilder stringBuilder = new StringBuilder();
        Frame[] frameArray = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
        this.appendFrameInfo(stringBuilder, frameArray[n], n, false, true);
        stringBuilder.append(m_newline);
        this.out(stringBuilder.toString());
    }

    void setListingToFrame(int n) throws PlayerDebugException {
        Frame[] frameArray = this.m_session.getWorkerSession(this.m_activeIsolate).getFrames();
        Frame frame = frameArray[n];
        Location location = frame.getLocation();
        SourceFile sourceFile = location.getFile();
        int n2 = sourceFile.getId();
        int n3 = location.getLine();
        this.setListingPosition(n2, n3, frame.getIsolateId());
    }

    void setListingPosition(int n, int n2, int n3) {
        SourceFile sourceFile;
        this.propertyPut(LIST_MODULE, n);
        this.propertyPut(LIST_LINE, n2);
        this.propertyPut(LIST_WORKER, n3);
        if (this.m_fullnameOption && (sourceFile = this.m_fileInfo.getFile(n)) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendFullnamePosition(stringBuilder, sourceFile, n2);
            stringBuilder.append('\n');
            this.out(stringBuilder.toString());
        }
    }

    void dumpTree(Map<Object, String> map, List<Object> list, String string, Value value, String string2) throws NotSuspendedException, NoResponseException, NotConnectedException {
        String string3;
        Variable variable;
        int n;
        Variable[] variableArray;
        if (string == null) {
            string = "";
        }
        if (map.containsKey(value)) {
            return;
        }
        map.put(value, string);
        Value value2 = value;
        boolean bl = false;
        while (!bl && value2 != null) {
            variableArray = value2.getMembers(this.m_session);
            value2 = null;
            for (n = 0; n < variableArray.length; ++n) {
                variable = variableArray[n];
                string3 = variable.getName();
                if (string3.equals(string2) && !map.containsKey(variable)) {
                    list.add(string);
                    list.add(value);
                    list.add(variable);
                    map.put(variable, string + "." + string3);
                    bl = true;
                    continue;
                }
                if (!string3.equals("__proto__")) continue;
                value2 = variableArray[n].getValue();
            }
        }
        bl = false;
        value2 = value;
        while (!bl && value2 != null) {
            variableArray = value2.getMembers(this.m_session);
            value2 = null;
            for (n = 0; n < variableArray.length; ++n) {
                variable = variableArray[n];
                string3 = variable.getName();
                if (variable.getValue().getType() != 3 && variable.getValue().getType() != 5) continue;
                if (variable.getValue().getId() != -1L) {
                    this.dumpTree(map, list, string, variable.getValue(), string2);
                    continue;
                }
                if (!string3.equals("__proto__")) continue;
                value2 = variable.getValue();
            }
        }
    }

    StringBuilder treeResults(StringBuilder stringBuilder, List<Object> list, String string, boolean bl) {
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Variable variable = (Variable)iterator.next();
            Variable variable2 = (Variable)iterator.next();
            if (bl) {
                stringBuilder.append(string2);
            }
            this.m_exprCache.appendVariableValue(stringBuilder, variable.getValue(), variable.getName(), variable.getIsolateId());
            stringBuilder.append(".");
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            this.m_exprCache.appendVariableValue(stringBuilder, variable2.getValue(), variable2.getName(), variable2.getIsolateId());
            stringBuilder.append(m_newline);
        }
        return stringBuilder;
    }

    public void outputSource(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendSource(stringBuilder, n, n2, string, true);
        this.out(stringBuilder.toString());
    }

    void appendSource(StringBuilder stringBuilder, int n, int n2, String string, boolean bl) {
        String string2 = String.valueOf(n2);
        int n3 = 6 - string2.length();
        if (bl && this.isCurrentLocation(n, n2)) {
            stringBuilder.append('=');
        } else {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string2);
        this.repeat(stringBuilder, ' ', n3);
        stringBuilder.append(string);
    }

    boolean isCurrentLocation(int n, int n2) {
        SourceFile sourceFile;
        boolean bl = false;
        Location location = this.getCurrentLocation();
        if (location != null && (sourceFile = location.getFile()) != null && sourceFile.getId() == n && location.getLine() == n2) {
            bl = true;
        }
        return bl;
    }

    private int parseLineNumber(String string) throws ParseException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", string);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedLineNumber", hashMap), 0);
        }
    }

    private int parseFileNumber(String string) throws ParseException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", string);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedFileNumber", hashMap), 0);
        }
    }

    private int parseWorkerId(String string) throws ParseException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", string);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedIsolateNumber", hashMap), 0);
        }
    }

    private int parseFileName(int n, String string) throws NoMatchException, AmbiguousException {
        SourceFile[] sourceFileArray = this.m_fileInfo.getFiles(string, n);
        int n2 = sourceFileArray.length;
        if (n2 == 0) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", string);
            throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSourceFileWithSpecifiedName", hashMap));
        }
        if (n2 > 1) {
            String string2 = DebugCLI.getLocalizationManager().getLocalizedTextString("ambiguousMatchingFilenames") + m_newline;
            for (int i = 0; i < n2; ++i) {
                SourceFile sourceFile = sourceFileArray[i];
                string2 = string2 + " " + sourceFile.getName() + "#" + sourceFile.getId();
                if (i >= n2 - 1) continue;
                string2 = string2 + m_newline;
            }
            throw new AmbiguousException(string2);
        }
        return sourceFileArray[0].getId();
    }

    private int[] parseFunctionName(int n, String string, boolean bl) throws NoMatchException, AmbiguousException {
        Object[] objectArray;
        Object object;
        Object object2;
        SourceFile sourceFile = this.m_fileInfo.getFile(n, this.m_activeIsolate);
        ArrayList<ModuleFunctionPair> arrayList = new ArrayList<ModuleFunctionPair>();
        this.appendFunctionNamesMatching(arrayList, sourceFile, string);
        if (arrayList.size() == 0) {
            if (!bl) {
                for (Isolate isolate : this.m_session.getWorkers()) {
                    object2 = this.m_fileInfo.getAllFiles(isolate.getId());
                    while (object2.hasNext()) {
                        object = (SourceFile)((Map.Entry)object2.next()).getValue();
                        if (object == sourceFile) continue;
                        this.appendFunctionNamesMatching(arrayList, (SourceFile)object, string);
                    }
                }
            }
            if (arrayList.size() == 0) {
                objectArray = new HashMap();
                objectArray.put("name", string);
                throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noFunctionWithSpecifiedName", (Map)objectArray));
            }
        }
        if (arrayList.size() > 1) {
            objectArray = arrayList.toArray(new ModuleFunctionPair[arrayList.size()]);
            Arrays.sort(objectArray);
            String string2 = DebugCLI.getLocalizationManager().getLocalizedTextString("ambiguousMatchingFunctionNames") + m_newline;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = this.m_fileInfo.getFile(((ModuleFunctionPair)objectArray[i]).moduleId, this.m_activeIsolate).getName();
                object = ((ModuleFunctionPair)objectArray[i]).functionName;
                hashMap.put("functionName", object);
                hashMap.put("filename", (String)object2 + "#" + ((ModuleFunctionPair)objectArray[i]).moduleId);
                string2 = string2 + " " + DebugCLI.getLocalizationManager().getLocalizedTextString("functionInFile", hashMap);
                if (i >= objectArray.length - 1) continue;
                string2 = string2 + m_newline;
            }
            throw new AmbiguousException(string2);
        }
        objectArray = arrayList.get(0);
        n = objectArray.moduleId;
        sourceFile = this.m_fileInfo.getFile(n, this.m_activeIsolate);
        int n2 = sourceFile.getLineForFunctionName(this.m_session, objectArray.functionName);
        return new int[]{n, n2};
    }

    private void appendFunctionNamesMatching(List<ModuleFunctionPair> list, SourceFile sourceFile, String string) {
        int n = -1;
        int n2 = string.lastIndexOf(40);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        String[] stringArray = sourceFile.getFunctionNames(this.m_session);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals(string)) {
                n = i;
                break;
            }
            if (!string2.startsWith(string)) continue;
            list.add(new ModuleFunctionPair(sourceFile.getId(), string2));
        }
        if (n > -1) {
            list.clear();
            list.add(new ModuleFunctionPair(sourceFile.getId(), stringArray[n]));
        }
    }

    public int parseFileArg(int n, int n2, String string) throws ParseException, AmbiguousException, NoMatchException {
        if (string.length() == 0) {
            return n2;
        }
        char c = string.charAt(0);
        if (Character.isDigit(c) || c == '-') {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", string);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedFile", hashMap), 0);
        }
        if (c == '#') {
            if (n == this.m_activeIsolate) {
                return this.parseFileNumber(string.substring(1));
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", string);
            throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", hashMap));
        }
        return this.parseFileName(n, string);
    }

    public int parseLineArg(int n, String string) throws ParseException, AmbiguousException, NoMatchException {
        if (string.length() == 0) {
            return 1;
        }
        char c = string.charAt(0);
        if (Character.isDigit(c) || c == '-') {
            return this.parseLineNumber(string);
        }
        if (c == '#') {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", string);
            throw new ParseException(DebugCLI.getLocalizationManager().getLocalizedTextString("expectedLineNumber", hashMap), 0);
        }
        int[] nArray = this.parseFunctionName(n, string, true);
        return nArray[1];
    }

    public FileLocation[] parseLocationArg(int n, int n2, String string) throws ParseException, AmbiguousException, NoMatchException {
        return this.parseLocationArg(n, n2, string, true);
    }

    public FileLocation[] parseLocationArg(int object, int object2, String string, boolean bl) throws ParseException, AmbiguousException, NoMatchException {
        Object object3;
        int n = -1;
        int n2 = string.indexOf(58);
        int n3 = 0;
        char c = string.charAt(0);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<Integer> iterator = this.m_isolateState.keySet().iterator();
        if (n2 < 0) {
            if (Character.isDigit(c) || c == '-') {
                object2 = this.parseLineNumber(string);
            } else if (c == '#') {
                n = this.m_activeIsolate;
                object = this.parseFileNumber(string.substring(1));
                object2 = 1;
                object3 = new FileLocation(n + 1, (int)object, (int)object2, n3);
                arrayList.add(object3);
            } else {
                try {
                    object3 = this.parseFunctionName((int)object, string, false);
                    object = object3[0];
                    object2 = object3[1];
                    n3 = 1;
                    FileLocation fileLocation = new FileLocation(n + 1, (int)object, (int)object2, n3);
                    arrayList.add(fileLocation);
                }
                catch (NoMatchException noMatchException) {
                    if (bl) {
                        while (iterator.hasNext()) {
                            int n4 = iterator.next();
                            try {
                                object = this.parseFileName(n4, string);
                                object2 = 1;
                                FileLocation fileLocation = new FileLocation(n4, (int)object, (int)object2, n3);
                                arrayList.add(fileLocation);
                            }
                            catch (NoMatchException noMatchException2) {}
                        }
                    }
                    object = this.parseFileName(this.m_activeIsolate, string);
                    object2 = 1;
                    FileLocation fileLocation = new FileLocation(this.m_activeIsolate, (int)object, (int)object2, n3);
                    arrayList.add(fileLocation);
                }
            }
        } else {
            n = this.m_activeIsolate;
            if (c == '@') {
                n = this.parseWorkerId(string.substring(1, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(58)) < 0) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("token", string);
                    throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", hashMap));
                }
                object = this.parseFileArg(n + 1, (int)object, string.substring(0, n2));
                object2 = this.parseLineArg((int)object, string.substring(n2 + 1));
                n3 = string.substring(n2 + 1).length() > 1 && Character.isDigit(string.substring(n2 + 1).charAt(0)) ? 0 : 1;
                object3 = new FileLocation(n + 1, (int)object, (int)object2, n3);
                arrayList.add(object3);
            } else if (bl) {
                while (iterator.hasNext()) {
                    int n5 = iterator.next();
                    try {
                        object = this.parseFileArg(n5, (int)object, string.substring(0, n2));
                        object2 = this.parseLineArg((int)object, string.substring(n2 + 1));
                        n3 = string.substring(n2 + 1).length() > 1 && Character.isDigit(string.substring(n2 + 1).charAt(0)) ? 0 : 1;
                        object3 = new FileLocation(n5, (int)object, (int)object2, n3);
                        arrayList.add(object3);
                    }
                    catch (NoMatchException noMatchException) {}
                }
            } else {
                object = this.parseFileName(this.m_activeIsolate, string.substring(0, n2));
                object2 = this.parseLineArg((int)object, string.substring(n2 + 1));
                n3 = string.substring(n2 + 1).length() > 1 && Character.isDigit(string.substring(n2 + 1).charAt(0)) ? 0 : 1;
                object3 = new FileLocation(this.m_activeIsolate, (int)object, (int)object2, n3);
                arrayList.add(object3);
            }
        }
        if (arrayList.size() == 0) {
            object3 = new HashMap();
            object3.put("token", string);
            throw new NoMatchException(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchFileOrFunction", (Map)object3));
        }
        object3 = arrayList.toArray();
        return (FileLocation[])Arrays.copyOf(object3, ((Object[])object3).length, FileLocation[].class);
    }

    void doWhat() throws NotConnectedException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            Object object = null;
            String string = this.restOfLine();
            ValueExp valueExp = this.parseExpression(string);
            if (valueExp.containsAssignment()) {
                throw new IllegalAccessException();
            }
            object = this.evalExpression((ValueExp)valueExp, (int)this.m_activeIsolate).value;
            StringBuilder stringBuilder = new StringBuilder();
            if (object instanceof Variable) {
                Variable variable = (Variable)object;
                if (variable.isAttributeSet(32)) {
                    string = DebugCLI.getLocalizationManager().getLocalizedTextString("localVariable");
                } else if (variable.isAttributeSet(65536)) {
                    string = DebugCLI.getLocalizationManager().getLocalizedTextString("functionArgumentVariable");
                } else if (!(variable instanceof VariableFacade) || (string = ((VariableFacade)variable).getPath()) == null || string.length() <= 0) {
                    string = "_global";
                }
                stringBuilder.append(string);
            } else {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mustBeOnlyOneVariable"));
            }
            this.out(stringBuilder.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSideEffectsAllowed"));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
        }
    }

    void doList() {
        int n = this.propertyGet(LIST_MODULE);
        int n2 = this.propertyGet(LIST_LINE);
        int n3 = this.propertyGet(LIST_SIZE);
        int n4 = this.propertyGet(LIST_WORKER);
        String string = null;
        int n5 = n;
        int n6 = n2;
        String string2 = null;
        int n7 = n2;
        int n8 = 0;
        try {
            if (this.hasMoreTokens()) {
                string = this.nextToken();
                if (string.equals("-")) {
                    n6 = n7 = n6 - 2 * n3;
                } else {
                    FileLocation[] fileLocationArray = this.parseLocationArg(n, n2, string, false);
                    if (fileLocationArray.length == 1) {
                        n5 = fileLocationArray[0].getModule();
                        n7 = n6 = fileLocationArray[0].getLine();
                    }
                    if (this.hasMoreTokens()) {
                        string2 = this.nextToken();
                        n7 = this.parseLineArg(n5, string2);
                    }
                }
            }
            if (this.hasMoreTokens()) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("lineJunk"));
            } else {
                int n9;
                int n10 = n3 / 2;
                SourceFile sourceFile = this.m_fileInfo.getFile(n5, n4);
                n8 = sourceFile.getLineCount();
                if (n8 == 1 && sourceFile.getLine(1).equals("")) {
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceFileNotFound"));
                    n9 = n2;
                } else {
                    if (n6 > n8 && string != null) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (string2 == null) {
                        n7 = n6 + n10 - 1;
                        n6 -= n3 - n10;
                    }
                    if (n6 < 1) {
                        n7 += -(n6 - 1);
                        n6 = 1;
                    }
                    if (n7 > n8) {
                        n7 = n8;
                    }
                    if (n6 > n7) {
                        throw new IndexOutOfBoundsException();
                    }
                    SourceFile sourceFile2 = this.m_fileInfo.getFile(n5, n4);
                    for (int i = n6; i <= n7; ++i) {
                        this.outputSource(n5, i, sourceFile2.getLine(i));
                    }
                    n9 = n7 + n10 + (n3 % 2 == 0 ? 1 : 2);
                }
                this.propertyPut(LIST_MODULE, n5);
                this.propertyPut(LIST_LINE, n9);
                this.propertyPut(LIST_WORKER, n4);
                this.m_repeatLine = "list";
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string3 = "#" + n5;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("line", Integer.toString(n6));
            hashMap.put("filename", string3);
            hashMap.put("total", Integer.toString(n8));
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("lineNumberOutOfRange", hashMap));
        }
        catch (AmbiguousException ambiguousException) {
            this.err(ambiguousException.getMessage());
        }
        catch (NoMatchException noMatchException) {
            this.err(noMatchException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noFilesFound"));
        }
        catch (ParseException parseException) {
            this.err(parseException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun() throws IOException {
        if (this.m_session != null) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sessionInProgress"));
            return;
        }
        SessionManager sessionManager = Bootstrap.sessionManager();
        if (this.hasMoreTokens() && !this.setLaunchURI(this.restOfLine())) {
            return;
        }
        if (this.m_connectPort == null) {
            sessionManager.startListening();
        }
        try {
            if (this.m_connectPort != null) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("waitingToConnectToPlayer"));
                this.m_session = sessionManager.connect(Integer.valueOf(this.m_connectPort), null);
            } else if (this.m_launchURI == null) {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("waitingForPlayerToConnect"));
                this.m_session = sessionManager.accept(null);
            } else {
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("launchingWithUrl") + m_newline + this.m_launchURI);
                this.m_session = sessionManager.launch(this.m_launchURI, null, true, null, null);
            }
            if (this.m_session == null) {
                throw new SocketTimeoutException();
            }
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("playerConnectedSessionStarting"));
            this.initSession(this.m_session);
            try {
                this.waitTilHalted(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setInitialSourceFile();
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("setBreakpointsThenResume"));
            this.setPromptState(InitialPromptState.DONE, 1);
            try {
                if (this.m_session.getPreference("$playersupportsget") == 0) {
                    this.err(m_newline + DebugCLI.getLocalizationManager().getLocalizedTextString("warningNotAllCommandsSupported"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uri", fileNotFoundException.getLocalizedMessage());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("fileDoesNotExist", hashMap));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("failedToConnect"));
        }
        catch (IOException iOException) {
            this.err(iOException.getLocalizedMessage());
        }
        finally {
            if (this.m_connectPort == null) {
                sessionManager.stopListening();
            }
        }
    }

    void doConnect() throws IOException {
        int n = 0;
        if (this.hasMoreTokens()) {
            try {
                n = this.nextIntToken();
            }
            catch (NumberFormatException numberFormatException) {
                this.err(numberFormatException.getLocalizedMessage());
            }
        } else {
            n = 7936;
        }
        if (n > 0) {
            this.m_connectPort = String.valueOf(n);
            this.doRun();
        }
    }

    private void setInitialSourceFile() {
        int n = -1;
        SourceFile[] sourceFileArray = this.m_fileInfo.getFileList(this.m_activeIsolate);
        for (int i = 0; i < sourceFileArray.length; ++i) {
            SourceFile sourceFile = sourceFileArray[i];
            if (sourceFile.getId() <= n || this.getFileType(sourceFile) != 1) continue;
            n = sourceFile.getId();
        }
        if (n != -1) {
            this.setListingPosition(n, 1, this.m_activeIsolate);
        }
    }

    private boolean setLaunchURI(String string) {
        if (string != null) {
            SessionManager sessionManager = Bootstrap.sessionManager();
            if (!sessionManager.supportsLaunch() && System.getProperty("fdbunit") == null) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("manuallyLaunchPlayer"));
                return false;
            }
            if (this.m_fullnameOption && string.startsWith("//")) {
                string = "http:" + string;
            }
        }
        this.m_launchURI = string;
        return true;
    }

    void doFile() {
        if (!this.hasMoreTokens()) {
            this.setLaunchURI(null);
        } else {
            this.setLaunchURI(this.restOfLine());
        }
    }

    void doSource() {
        String string = "";
        try {
            string = this.nextToken();
            FileReader fileReader = new FileReader(string);
            this.pushStream(this.m_in);
            this.m_in = new LineNumberReader(fileReader);
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceCommandRequiresPath"));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("sourceCommandRequiresPath"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("filename", string);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("fileNotFound", hashMap));
        }
    }

    void listFault(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendFaultTitles(stringBuilder);
        this.appendFault(stringBuilder, string);
        this.out(stringBuilder.toString());
    }

    void appendFault(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        int n = 30 - string.length();
        this.repeat(stringBuilder, ' ', n);
        boolean bl = this.m_faultTable.is(string, "stop");
        boolean bl2 = this.m_faultTable.is(string, "print");
        stringBuilder.append(bl ? "Yes" : "No");
        this.repeat(stringBuilder, ' ', bl ? 0 : 1);
        this.repeat(stringBuilder, ' ', 5);
        stringBuilder.append(bl2 ? "Yes" : "No");
        this.repeat(stringBuilder, ' ', bl2 ? 0 : 1);
        this.repeat(stringBuilder, ' ', 7);
        String string2 = this.m_faultTable.getDescription(string);
        stringBuilder.append(string2);
        stringBuilder.append(m_newline);
    }

    void appendFaultTitles(StringBuilder stringBuilder) {
        stringBuilder.append("Fault                         Stop    Print     Description" + m_newline);
        stringBuilder.append("-----                         ----    -----     -----------" + m_newline);
    }

    void doHandle() {
        if (!this.hasMoreTokens()) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("argumentRequired"));
        } else {
            String string = this.nextToken();
            Object[] objectArray = new Object[]{string};
            if (string.equalsIgnoreCase("all")) {
                objectArray = this.m_faultTable.names();
            }
            if (!this.m_faultTable.exists((String)objectArray[0])) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unrecognizedFault"));
            } else if (!this.hasMoreTokens()) {
                this.listFault((String)objectArray[0]);
            } else {
                String string2 = null;
                try {
                    while (this.hasMoreTokens()) {
                        string2 = this.nextToken();
                        for (int i = 0; i < objectArray.length; ++i) {
                            this.m_faultTable.action((String)objectArray[i], string2);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("action", string2);
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unrecognizedAction", hashMap));
                }
            }
        }
    }

    void doCommands() throws IOException {
        try {
            int n = -1;
            n = this.hasMoreTokens() ? this.nextIntToken() : this.propertyGet(BPNUM);
            int n2 = this.breakpointIndexOf(n);
            BreakAction breakAction = this.breakpointAt(n2);
            breakAction.clearCommands();
            breakAction.setSilent(false);
            String string = null;
            boolean bl = true;
            boolean bl2 = false;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("breakpointNumber", Integer.toString(n));
            this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("typeCommandsForBreakpoint", hashMap));
            do {
                this.displayCommandPrompt();
                string = this.readLine().trim();
                bl2 = string.equalsIgnoreCase("end");
                if (!bl2) {
                    if (bl && string.equalsIgnoreCase("silent")) {
                        breakAction.setSilent(true);
                    } else {
                        breakAction.addCommand(string);
                    }
                }
                bl = false;
            } while (!bl2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", hashMap));
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doCondition() throws IOException {
        try {
            int n = this.nextIntToken();
            int n2 = this.breakpointIndexOf(n);
            BreakAction breakAction = this.breakpointAt(n2);
            if (this.hasMoreTokens()) {
                String string = this.restOfLine();
                ValueExp valueExp = this.parseExpression(string);
                if (valueExp.containsAssignment() && !this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askExpressionContainsAssignment"))) {
                    throw new IllegalAccessException("=");
                }
                breakAction.setCondition(valueExp, string);
            } else {
                breakAction.clearCondition();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("breakpointNumber", Integer.toString(n));
                this.out(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNowUnconditional", hashMap));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointNotChanged"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", hashMap));
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doWatch(boolean bl, boolean bl2) throws PlayerDebugException {
        block15: {
            try {
                if (bl) {
                    this.err("Only break-on-write watchpoints are supported.");
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.restOfLine();
                int n = 3;
                if (bl && bl2) {
                    n = 3;
                } else if (bl) {
                    n = 1;
                } else if (bl2) {
                    n = 2;
                }
                IsolateSession isolateSession = this.m_session.getWorkerSession(this.m_activeIsolate);
                Watch[] watchArray = isolateSession.getWatchList();
                ValueExp valueExp = this.parseExpression(string);
                VariableFacade variableFacade = (VariableFacade)this.evalExpression((ValueExp)valueExp, (int)this.m_activeIsolate).value;
                long l = variableFacade.getContext();
                String string2 = variableFacade.getName();
                Value value = isolateSession.getValue(l);
                Watch watch = this.m_session.setWatch(value, string2, n);
                if (watch == null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("expression", string);
                    this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointCouldNotBeSet", hashMap));
                    break block15;
                }
                Watch[] watchArray2 = isolateSession.getWatchList();
                if (watchArray2.length == watchArray.length) {
                    int n2 = this.missingWatchpointIndexOf(watchArray2);
                    WatchAction watchAction = null;
                    try {
                        watchAction = this.watchpointAt(n2);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        watchAction = new WatchAction(watch);
                    }
                    int n3 = watchAction.getId();
                    watchAction.resetWatch(watch);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("watchpointNumber", Integer.toString(n3));
                    hashMap.put("expression", string);
                    hashMap.put("watchpointMode", this.getWatchpointModeString(watchAction.getKind()));
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("changedWatchpointMode", hashMap));
                } else {
                    WatchAction watchAction = new WatchAction(watch);
                    this.watchpointAdd(watchAction);
                    int n4 = watchAction.getId();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("watchpointNumber", Integer.toString(n4));
                    hashMap.put("expression", string);
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("createdWatchpoint", hashMap));
                }
                this.out(stringBuilder.toString());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badWatchpointNumber"));
            }
            catch (NullPointerException nullPointerException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
            }
            catch (ClassCastException classCastException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotResolveExpression"));
            }
        }
    }

    WatchAction watchpointAt(int n) {
        return this.m_watchpoints.get(n);
    }

    boolean watchpointAdd(WatchAction watchAction) {
        return this.m_watchpoints.add(watchAction);
    }

    int watchpointCount() {
        return this.m_watchpoints.size();
    }

    int watchpointIndexOf(int n) {
        int n2 = this.watchpointCount();
        for (int i = 0; i < n2; ++i) {
            WatchAction watchAction = this.watchpointAt(i);
            if (watchAction.getId() != n) continue;
            return i;
        }
        return -1;
    }

    void removeAllWatchpoints() throws NotConnectedException {
        while (this.watchpointCount() > 0) {
            this.removeWatchpointAt(0);
        }
    }

    void removeWatchpointAt(int n) throws NotConnectedException {
        WatchAction watchAction = this.watchpointAt(n);
        boolean bl = false;
        try {
            bl = this.m_session.clearWatch(watchAction.getWatch()) != null;
        }
        catch (NoResponseException noResponseException) {
            // empty catch block
        }
        if (!bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("variable", watchAction.getExpr());
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotFindWatchpoint", hashMap));
        }
        this.m_watchpoints.remove(n);
    }

    String getWatchpointModeString(int n) {
        switch (n) {
            case 1: {
                return DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointMode_read");
            }
            case 2: {
                return DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointMode_write");
            }
            case 3: {
                return DebugCLI.getLocalizationManager().getLocalizedTextString("watchpointMode_readWrite");
            }
        }
        return "";
    }

    int missingWatchpointIndexOf(Watch[] watchArray) {
        int n = this.watchpointCount();
        int n2 = -1;
        for (int i = 0; i < n && n2 < 0; ++i) {
            WatchAction watchAction = this.watchpointAt(i);
            Watch watch = watchAction.getWatch();
            int n3 = -1;
            for (int j = 0; j < watchArray.length && n3 < 0; ++j) {
                if (watch != watchArray[j]) continue;
                n3 = j;
            }
            if (n3 >= 0) continue;
            n2 = i;
        }
        return n2;
    }

    void doDisplay() {
        try {
            if (!this.hasMoreTokens()) {
                this.doInfoDisplay();
            } else {
                String string = this.restOfLine();
                ValueExp valueExp = this.parseExpression(string);
                if (valueExp.containsAssignment()) {
                    throw new IllegalAccessException();
                }
                DisplayAction displayAction = new DisplayAction(valueExp, string, this.m_activeIsolate);
                displayAction.setEnabled(true);
                this.displayAdd(displayAction);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSideEffectsAllowed"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void doUnDisplay() throws IOException {
        try {
            if (!this.hasMoreTokens()) {
                if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askDeleteAllAutoDisplay"))) {
                    int n = this.displayCount();
                    for (int i = n - 1; i > -1; --i) {
                        this.displayRemoveAt(i);
                    }
                }
            } else {
                while (this.hasMoreTokens()) {
                    int n = this.nextIntToken();
                    int n2 = this.displayIndexOf(n);
                    this.displayRemoveAt(n2);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("displayNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noDisplayNumber", hashMap));
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badDisplayNumber", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void doDisable() throws AmbiguousException, NotConnectedException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            if (!this.hasMoreTokens()) {
                this.disableAllBreakpoints();
            } else {
                String string = this.nextToken();
                int n = this.disableCommandFor(string);
                int n2 = -1;
                if (n == 25) {
                    this.doDisableDisplay();
                } else if (n == 6 && !this.hasMoreTokens()) {
                    this.disableAllBreakpoints();
                } else {
                    n2 = n == 6 ? this.nextIntToken() : Integer.parseInt(string);
                    do {
                        int n3 = this.breakpointIndexOf(n2);
                        this.disableBreakpointAt(n3);
                    } while ((n2 = this.hasMoreTokens() ? this.nextIntToken() : -1) > -1);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", hashMap));
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void disableAllBreakpoints() throws NotConnectedException {
        int n = this.breakpointCount();
        for (int i = 0; i < n; ++i) {
            this.disableBreakpointAt(i);
        }
    }

    void disableBreakpointAt(int n) throws NotConnectedException {
        BreakAction breakAction = this.breakpointAt(n);
        breakAction.setEnabled(false);
        this.breakDisableRequest(breakAction.getLocations());
    }

    void doDisableDisplay() {
        this.doEnableDisableDisplay(false);
    }

    void doEnableDisableDisplay(boolean bl) {
        try {
            if (!this.hasMoreTokens()) {
                int n = this.displayCount();
                for (int i = 0; i < n; ++i) {
                    this.displayAt(i).setEnabled(bl);
                }
            } else {
                while (this.hasMoreTokens()) {
                    int n = this.nextIntToken();
                    int n2 = this.displayIndexOf(n);
                    DisplayAction displayAction = this.displayAt(n2);
                    displayAction.setEnabled(bl);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("displayNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noDisplayNumber", hashMap));
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badDisplayNumber", hashMap));
        }
    }

    void doEnable() throws AmbiguousException, NotConnectedException {
        this.waitTilHalted(this.m_activeIsolate);
        try {
            if (!this.hasMoreTokens()) {
                this.enableAllBreakpoints();
            } else {
                String string = this.nextToken();
                int n = this.enableCommandFor(string);
                int n2 = -1;
                boolean bl = false;
                boolean bl2 = false;
                if (n == 25) {
                    this.doEnableDisplay();
                } else if (n == 6 && !this.hasMoreTokens()) {
                    this.enableAllBreakpoints();
                } else {
                    if (n == 6) {
                        n2 = this.nextIntToken();
                    } else if (n == 15) {
                        bl = true;
                        n2 = this.nextIntToken();
                    } else if (n == 301) {
                        bl2 = true;
                        n2 = this.nextIntToken();
                    } else {
                        n2 = Integer.parseInt(string);
                    }
                    boolean bl3 = true;
                    do {
                        int n3 = this.breakpointIndexOf(n2);
                        bl3 = this.enableBreakpointAt(n3, bl2, bl);
                        n2 = this.hasMoreTokens() ? this.nextIntToken() : -1;
                    } while (bl3 && n2 > -1);
                    if (!bl3) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("breakpointNumber", Integer.toString(n2));
                        this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("breakpointLocationNoLongerExists", hashMap));
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("breakpointNumber", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noBreakpointNumber", hashMap));
        }
        catch (NumberFormatException numberFormatException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("token", this.m_currentToken);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("badBreakpointNumber", hashMap));
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandFailed"));
        }
    }

    void enableAllBreakpoints() throws NotConnectedException {
        int n = this.breakpointCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.enableBreakpointAt(i) ? 1 : 0;
        }
        if (n2 != n) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("notAllBreakpointsEnabled"));
        }
    }

    boolean enableBreakpointAt(int n) throws NotConnectedException {
        return this.enableBreakpointAt(n, false, false);
    }

    boolean enableBreakpointAt(int n, boolean bl, boolean bl2) throws NotConnectedException {
        return this.enableBreakpoint(this.breakpointAt(n), bl, bl2);
    }

    boolean enableBreakpoint(BreakAction breakAction, boolean bl, boolean bl2) throws NotConnectedException {
        boolean bl3 = false;
        LocationCollection locationCollection = breakAction.getLocations();
        Iterator<Location> iterator = locationCollection.iterator();
        while (iterator.hasNext()) {
            LocationCollection locationCollection2;
            Location location = iterator.next();
            if (location == null || (locationCollection2 = this.enableBreak(location.getFile(), location.getLine(), location.getIsolateId())).isEmpty()) continue;
            breakAction.setEnabled(true);
            breakAction.setAutoDisable(bl);
            breakAction.setAutoDelete(bl2);
            breakAction.setSingleSwf(false);
            breakAction.setStatus(1);
            bl3 |= true;
        }
        return bl3;
    }

    void doEnableDisplay() {
        this.doEnableDisableDisplay(true);
    }

    void doPWD() {
        this.out(System.getProperty("user.dir"));
    }

    void doCF() {
        try {
            Object object;
            int n = this.propertyGet(LIST_MODULE);
            int n2 = this.propertyGet(LIST_LINE);
            int n3 = this.propertyGet(LIST_WORKER);
            if (this.hasMoreTokens()) {
                object = this.nextToken();
                n = this.parseFileArg(n3, n, (String)object);
                n2 = 1;
                this.setListingPosition(n, n2, n3);
            }
            object = this.m_fileInfo.getFile(n, n3);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object.getName());
            stringBuilder.append('#');
            stringBuilder.append(object.getId());
            stringBuilder.append(':');
            stringBuilder.append(n2);
            this.out(stringBuilder.toString());
        }
        catch (NullPointerException nullPointerException) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noFilesFound"));
        }
        catch (ParseException parseException) {
            this.err(parseException.getMessage());
        }
        catch (AmbiguousException ambiguousException) {
            this.err(ambiguousException.getMessage());
        }
        catch (NoMatchException noMatchException) {
            this.err(noMatchException.getMessage());
        }
    }

    void doKill() throws IOException {
        if (this.m_session == null) {
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("programNotBeingRun"));
        } else if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askKillProgram"))) {
            this.exitSession();
        }
    }

    boolean doQuit() throws IOException {
        boolean bl = false;
        if (this.m_session == null) {
            bl = true;
        } else {
            bl = this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askProgramIsRunningExitAnyway"));
            if (bl) {
                this.exitSession();
            }
        }
        return bl;
    }

    @Override
    public InputStream locateSource(String string, String string2, String string3) {
        File file = null;
        boolean bl = false;
        String string4 = string2 != null && string2.length() > 0 ? string2 + File.separator + string3 : null;
        for (String string5 : this.m_sourceDirectories) {
            if (string5.equals("")) {
                string5 = ".";
            }
            if (string4 != null) {
                file = new File(string5, string4);
                bl = file.exists();
            }
            if (!bl) {
                file = new File(string5, string3);
                bl = file.exists();
            }
            if (!bl) continue;
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public int getChangeCount() {
        return this.m_sourceDirectoriesChangeCount;
    }

    private void doDirectory() throws IOException {
        if (this.hasMoreTokens()) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.restOfLine(), File.pathSeparator);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.length() > 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                    string = string.substring(1, string.length() - 1);
                }
                if ((string = string.trim()).length() <= 0) continue;
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows") && string.matches("^.*[~$].*$")) {
                    try {
                        Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo " + string});
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        String string2 = bufferedReader.readLine();
                        if (string2 != null && (string2 = string2.trim()).length() > 0) {
                            string = string2;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    string = new File(string).getCanonicalPath();
                    this.m_sourceDirectories.add(n++, string);
                }
                catch (IOException iOException) {
                    this.err(iOException.getMessage());
                }
            }
            ++this.m_sourceDirectoriesChangeCount;
        } else if (this.yesNoQuery(DebugCLI.getLocalizationManager().getLocalizedTextString("askReinitSourcePath"))) {
            this.initSourceDirectoriesList();
        }
        this.doShowDirectories();
    }

    public void initSourceDirectoriesList() {
        this.m_sourceDirectories.clear();
        File file = this.getFlexHomeDirectory();
        if (file != null) {
            try {
                File file2 = new File(file, "frameworks/projects");
                File[] fileArray = file2.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file3;
                        if (!fileArray[i].isDirectory() || !(file3 = new File(fileArray[i], "src")).isDirectory()) continue;
                        this.m_sourceDirectories.add(file3.getCanonicalPath());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ++this.m_sourceDirectoriesChangeCount;
    }

    protected File getFlexHomeDirectory() {
        if (!this.m_initializedFlexHomeDirectory) {
            this.m_initializedFlexHomeDirectory = true;
            this.m_flexHomeDirectory = new File(".");
            String string = System.getProperty("application.home");
            if (string != null && string.length() > 0) {
                try {
                    this.m_flexHomeDirectory = new File(string).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.m_flexHomeDirectory;
    }

    protected String getenv(String string) {
        String[] stringArray = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new String[]{"cmd.exe", "/c", "echo", "%" + string + "%"} : new String[]{"/bin/sh", "-c", "echo $" + string};
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void doCatch() throws NotConnectedException, NotSuspendedException, NoResponseException {
        Object object;
        this.waitTilHalted(this.m_activeIsolate);
        String string = null;
        if (!this.hasMoreTokens()) {
            this.err("Catch requires an exception name.");
            return;
        }
        string = this.nextToken();
        if (string == null || string.length() == 0) {
            this.err("Illegal argument");
            return;
        }
        Value value = null;
        if (string.equals("*")) {
            string = null;
        } else {
            value = this.getSession().getWorkerSession(this.m_activeIsolate).getGlobal(string);
            if (value == null) {
                this.err("Type not found.");
                return;
            }
            object = value.getTypeName();
            int n = ((String)object).indexOf(64);
            if (n != -1) {
                object = ((String)object).substring(0, n);
            }
            if (!((String)object).endsWith("$")) {
                this.err("Not a type: " + value);
                return;
            }
        }
        try {
            object = this.addCatch(string);
        }
        catch (NotSupportedException notSupportedException) {
            notSupportedException.printStackTrace();
            return;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("id", ((CatchAction)object).getId());
        ((CatchAction)object).getId();
    }

    private CatchAction addCatch(String string) throws NotSupportedException, NoResponseException {
        CatchAction catchAction = new CatchAction(string);
        this.catchpointAdd(catchAction);
        return catchAction;
    }

    CatchAction catchpointAt(int n) {
        return this.m_catchpoints.get(n);
    }

    int catchpointCount() {
        return this.m_catchpoints.size();
    }

    boolean catchpointAdd(CatchAction catchAction) throws NotSupportedException, NoResponseException {
        if (this.catchpointCount() == 0) {
            this.getSession().getWorkerSession(this.m_activeIsolate).breakOnCaughtExceptions(true);
        }
        return this.m_catchpoints.add(catchAction);
    }

    int catchpointIndexOf(int n) {
        int n2 = this.catchpointCount();
        for (int i = 0; i < n2; ++i) {
            CatchAction catchAction = this.catchpointAt(i);
            if (catchAction.getId() != n) continue;
            return i;
        }
        return -1;
    }

    void removeAllCatchpoints() throws NotConnectedException {
        while (this.catchpointCount() > 0) {
            this.removeCatchpointAt(0);
        }
    }

    void removeCatchpointAt(int n) throws NotConnectedException {
        this.m_catchpoints.remove(n);
        if (this.catchpointCount() == 0) {
            try {
                this.getSession().getWorkerSession(this.m_activeIsolate).breakOnCaughtExceptions(false);
            }
            catch (NotSupportedException notSupportedException) {
            }
            catch (NoResponseException noResponseException) {
                // empty catch block
            }
        }
    }

    void doUnknown(String string) {
        this.doUnknown("", string);
    }

    void doUnknown(String string, String string2) {
        String string3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("command", string2);
        if (string == null || string.equals("")) {
            string3 = "unknownCommand";
            hashMap.put("commandCategory", string);
        } else {
            string3 = "unknownSubcommand";
        }
        this.err(DebugCLI.getLocalizationManager().getLocalizedTextString(string3, hashMap));
    }

    void processEvents() throws NotConnectedException {
        Object object;
        boolean bl = false;
        int n = 1;
        boolean bl2 = this.getIsolateState((int)n).m_requestHalt;
        while (this.m_session != null && this.m_session.getEventCount() > 0) {
            object = this.m_session.nextEvent();
            if (object instanceof TraceEvent) {
                this.dumpTraceLine(((DebugEvent)object).information);
                continue;
            }
            if (object instanceof SwfLoadedEvent) {
                this.handleSwfLoadedEvent((SwfLoadedEvent)object);
                continue;
            }
            if (object instanceof SwfUnloadedEvent) {
                this.handleSwfUnloadedEvent((SwfUnloadedEvent)object);
                continue;
            }
            if (object instanceof IsolateCreateEvent) {
                this.handleIsolateCreateEvent((IsolateCreateEvent)object);
                continue;
            }
            if (object instanceof IsolateExitEvent) {
                this.handleIsolateExitEvent((IsolateExitEvent)object);
                continue;
            }
            if (object instanceof BreakEvent) {
                n = ((BreakEvent)object).isolateId;
                this.m_breakIsolates.add(n);
                int n2 = 0;
                try {
                    n2 = this.m_session.getWorkerSession(n).suspendReason();
                }
                catch (PlayerDebugException playerDebugException) {
                    // empty catch block
                }
                if (n2 != 7) break;
                this.setPromptState(InitialPromptState.NEVER_SHOWN, n);
                break;
            }
            if (object instanceof FileListModifiedEvent || object instanceof FunctionMetaDataAvailableEvent) continue;
            if (object instanceof FaultEvent) {
                n = ((FaultEvent)object).isolateId;
                this.m_breakIsolates.add(n);
                if (this.handleFault((FaultEvent)object)) {
                    bl = true;
                    break;
                }
                bl2 = true;
                break;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", object);
            hashMap.put("info", ((DebugEvent)object).information);
            this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unknownEvent", hashMap));
        }
        object = null;
        if (this.m_session != null) {
            object = this.m_session.getWorkerSession(n);
        }
        if (bl && !bl2 && object != null && object.isSuspended() && object.suspendReason() == 3) {
            this.getIsolateState((int)n).m_requestResume = true;
        }
    }

    private void handleIsolateExitEvent(IsolateExitEvent isolateExitEvent) {
        this.dumpIsolateExitLine(isolateExitEvent);
    }

    private void handleIsolateCreateEvent(IsolateCreateEvent isolateCreateEvent) {
        this.dumpIsolateCreatedLine(isolateCreateEvent);
    }

    void dumpIsolateCreatedLine(IsolateCreateEvent isolateCreateEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenWorkerCreated"));
        stringBuilder.append(' ');
        stringBuilder.append(isolateCreateEvent.isolate.getId() - 1);
        this.out(stringBuilder.toString());
    }

    void dumpIsolateExitLine(IsolateExitEvent isolateExitEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("linePrefixWhenWorkerExit"));
        stringBuilder.append(' ');
        stringBuilder.append(isolateExitEvent.isolate.getId() - 1);
        this.out(stringBuilder.toString());
    }

    boolean processBreak(boolean bl, StringBuilder stringBuilder, int n) throws NotConnectedException, SuspendedException, IOException, NotSupportedException, NotSuspendedException, NoResponseException {
        int n2;
        Location location = this.getCurrentLocationIsolate(n);
        if (location == null || location.getFile() == null) {
            return false;
        }
        int n3 = location.getFile().getId();
        int n4 = location.getLine();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = this.breakpointCount();
        boolean[] blArray = new boolean[n5];
        DebugCLIIsolateState debugCLIIsolateState = this.getIsolateState(n);
        boolean bl5 = debugCLIIsolateState.m_requestResume;
        IsolateSession isolateSession = this.m_session.getWorkerSession(n);
        for (n2 = 0; n2 < n5; ++n2) {
            BreakAction breakAction = this.breakpointAt(n2);
            if (!breakAction.locationMatches(n3, n4, n)) continue;
            boolean bl6 = bl4 = isolateSession.suspendReason() == 1;
            if (!this.shouldBreak(breakAction, n3, n4, n)) continue;
            bl3 = true;
            breakAction.hit();
            boolean bl7 = bl2 = bl2 ? true : breakAction.isSilent();
            if (breakAction.isAutoDisable()) {
                this.disableBreakpointAt(n2);
            }
            if (breakAction.isAutoDelete()) {
                blArray[n2] = true;
            }
            int n6 = breakAction.getCommandCount();
            for (int i = 0; i < n6; ++i) {
                this.issueCommand(breakAction.commandAt(i), stringBuilder);
            }
        }
        for (n2 = blArray.length - 1; n2 > -1; --n2) {
            if (!blArray[n2]) continue;
            this.removeBreakpointAt(n2);
        }
        if (bl4 && !bl3) {
            debugCLIIsolateState.m_requestResume = true;
            debugCLIIsolateState.m_stepResume = bl;
            bl2 = true;
        } else if (bl4 && bl3 && debugCLIIsolateState.m_requestResume && !bl5) {
            debugCLIIsolateState.m_requestResume = true;
            debugCLIIsolateState.m_stepResume = bl;
            this.processDisplay(stringBuilder);
        }
        if (!debugCLIIsolateState.m_requestResume) {
            this.processDisplay(stringBuilder);
        }
        return bl2;
    }

    void processDisplay(StringBuilder stringBuilder) {
        int n = this.displayCount();
        for (int i = 0; i < n; ++i) {
            HashMap<String, String> hashMap;
            DisplayAction displayAction = this.displayAt(i);
            if (!displayAction.isEnabled()) continue;
            try {
                stringBuilder.append(displayAction.getId());
                stringBuilder.append(": ");
                stringBuilder.append(displayAction.getContent());
                stringBuilder.append(" = ");
                Object object = this.m_exprCache.evaluate((ValueExp)displayAction.getExpression(), (int)displayAction.getIsolateId()).value;
                if (object instanceof Variable) {
                    this.m_exprCache.appendVariableValue(stringBuilder, ((Variable)object).getValue(), displayAction.getIsolateId());
                } else if (object instanceof Value) {
                    this.m_exprCache.appendVariableValue(stringBuilder, (Value)object, displayAction.getIsolateId());
                } else if (object instanceof InternalProperty) {
                    stringBuilder.append(((InternalProperty)object).valueOf());
                } else {
                    stringBuilder.append(object);
                }
                stringBuilder.append(m_newline);
                continue;
            }
            catch (NoSuchVariableException noSuchVariableException) {
                hashMap = new HashMap<String, String>();
                hashMap.put("variable", noSuchVariableException.getMessage());
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("variableUnknown", hashMap));
                stringBuilder.append(m_newline);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                hashMap = new HashMap();
                hashMap.put("value", numberFormatException.getMessage());
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotConvertToNumber", hashMap));
                stringBuilder.append(m_newline);
                continue;
            }
            catch (PlayerFaultException playerFaultException) {
                stringBuilder.append(playerFaultException.getMessage() + m_newline);
                continue;
            }
            catch (PlayerDebugException playerDebugException) {
                stringBuilder.append(playerDebugException.getMessage() + m_newline);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("couldNotEvaluate"));
            }
        }
    }

    boolean shouldBreak(BreakAction breakAction, int n, int n2, int n3) {
        boolean bl = breakAction.isEnabled();
        ValueExp valueExp = breakAction.getCondition();
        if (bl && valueExp != null && !this.getRequestHalt(n3)) {
            try {
                ExpressionCache.EvaluationResult evaluationResult = this.evalExpression(valueExp, false, n3);
                if (evaluationResult != null) {
                    bl = ECMA.toBoolean(evaluationResult.context.toValue(evaluationResult.value));
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    void issueCommand(String string, StringBuilder stringBuilder) {
        PrintStream printStream;
        PrintStream printStream2;
        PrintStream printStream3;
        ByteArrayOutputStream byteArrayOutputStream;
        block7: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            printStream3 = new PrintStream(byteArrayOutputStream);
            printStream2 = this.m_out;
            printStream = this.m_err;
            this.m_out = printStream3;
            this.m_err = printStream3;
            try {
                this.setCurrentLine(string);
                this.processLine();
            }
            catch (AmbiguousException ambiguousException) {
            }
            catch (IllegalStateException illegalStateException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("illegalStateException"));
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("commandNotValidUntilPlayerSuspended"));
            }
            catch (NoSuchElementException noSuchElementException) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("noSuchElementException"));
            }
            catch (SocketException socketException) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("socketErrorMessage", socketException.getMessage());
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("problemWithConnection", hashMap));
            }
            catch (Exception exception) {
                this.err(DebugCLI.getLocalizationManager().getLocalizedTextString("unexpectedErrorWithStackTrace"));
                if (!Trace.error) break block7;
                exception.printStackTrace();
            }
        }
        printStream3.flush();
        stringBuilder.append(byteArrayOutputStream.toString());
        this.m_err = printStream;
        this.m_out = printStream2;
    }

    boolean handleFault(FaultEvent faultEvent) {
        ExceptionFault exceptionFault;
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        block13: {
            bl3 = false;
            String string = faultEvent.name();
            bl2 = true;
            bl = true;
            try {
                bl = this.m_faultTable.is(string, "print");
                bl2 = this.m_faultTable.is(string, "stop");
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.error) break block13;
                object = new HashMap<String, String>();
                object.put("faultName", string);
                Trace.trace(DebugCLI.getLocalizationManager().getLocalizedTextString("faultHasNoTableEntry", (Map)object));
                nullPointerException.printStackTrace();
            }
        }
        if (faultEvent instanceof ExceptionFault && (object = (exceptionFault = (ExceptionFault)faultEvent).getThrownValue()) != null) {
            if (!exceptionFault.willExceptionBeCaught()) {
                bl2 = true;
            } else {
                bl2 = false;
                String string = object.getTypeName();
                int n = string.indexOf(64);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                for (int i = 0; i < this.catchpointCount(); ++i) {
                    CatchAction catchAction = this.catchpointAt(i);
                    String string2 = catchAction.getTypeToCatch();
                    try {
                        if (string2 != null && !this.getSession().getWorkerSession(faultEvent.isolateId).evalIs((Value)object, string2)) continue;
                        bl2 = true;
                        break;
                    }
                    catch (PlayerDebugException playerDebugException) {
                        playerDebugException.printStackTrace();
                        bl2 = true;
                        continue;
                    }
                    catch (PlayerFaultException playerFaultException) {
                        playerFaultException.printStackTrace();
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    bl = false;
                }
            }
        }
        if (!bl2) {
            bl3 = true;
        }
        if (bl) {
            this.dumpFaultLine(faultEvent);
        }
        return bl3;
    }

    void waitTilHalted(int n) throws NotConnectedException {
        boolean bl;
        if (!this.haveConnection()) {
            throw new IllegalStateException();
        }
        int n2 = this.propertyGet(HALT_TIMEOUT);
        int n3 = this.propertyGet(UPDATE_DELAY);
        boolean bl2 = bl = this.propertyGet(NO_WAITING) != 1;
        if (bl) {
            this.waitForSuspend(n2, n3, n);
            if (!this.m_session.getWorkerSession(n).isSuspended()) {
                throw new IllegalMonitorStateException();
            }
        }
    }

    void waitForSuspend(int n, int n2) throws NotConnectedException {
        this.waitForSuspend(n, n2, 1);
    }

    void waitForSuspend(int n, int n2, int n3) throws NotConnectedException {
        IsolateSession isolateSession = this.m_session.getWorkerSession(n3);
        while (n > 0) {
            this.processEvents();
            if (isolateSession.isSuspended()) break;
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n -= n2;
        }
    }

    void exitSession() {
        this.m_displays.clear();
        this.m_watchpoints.clear();
        if (this.m_fileInfo != null) {
            this.m_fileInfo.unbind();
        }
        if (this.m_session != null) {
            this.m_session.terminate();
        }
        this.m_session = null;
        this.m_fileInfo = null;
    }

    void initSession(Session session) {
        session.setSourceLocator(this);
        this.m_fileInfo = new FileInfoCache();
        this.m_exprCache.clear();
        this.m_fileInfo.bind(session);
        this.m_exprCache.bind(session);
        boolean bl = true;
        try {
            session.bind();
        }
        catch (VersionException versionException) {
            bl = false;
        }
        this.propertyPut(LIST_LINE, 1);
        this.propertyPut(LIST_MODULE, 1);
        this.propertyPut(BPNUM, 0);
        this.propertyPut(LAST_FRAME_DEPTH, 0);
        this.propertyPut(CURRENT_FRAME_DEPTH, 0);
        this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
        this.propertyPut(PLAYER_FULL_SUPPORT, bl ? 1 : 0);
        String string = this.m_mruURI;
        this.m_mruURI = this.m_session.getURI();
        if (string != null && this.m_mruURI != null && string.equalsIgnoreCase(this.m_mruURI)) {
            this.reapplyBreakpoints();
        } else {
            while (this.m_breakpoints.size() > 0) {
                this.m_breakpoints.removeElementAt(0);
            }
        }
        this.m_mainState.m_requestResume = false;
        this.m_mainState.m_stepResume = false;
        this.initIsolateState();
    }

    private void initIsolateState() {
        this.m_activeIsolate = 1;
        this.m_breakIsolates = new Vector();
        this.m_isolateState = new HashMap();
        this.m_isolateState.put(1, this.m_mainState);
    }

    void reapplyBreakpoints() {
        int n = this.breakpointCount();
        for (int i = 0; i < n; ++i) {
            BreakAction breakAction = this.breakpointAt(i);
            breakAction.clearHits();
            breakAction.setStatus(2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.resolveBreakpoints(stringBuilder);
        this.out(stringBuilder.toString());
    }

    public boolean processLine() throws IOException, AmbiguousException, PlayerDebugException {
        if (!this.hasMoreTokens()) {
            return false;
        }
        String string = this.nextToken();
        boolean bl = false;
        int n = this.commandFor(string);
        this.m_repeatLine = null;
        switch (n) {
            case 1: {
                bl = this.doQuit();
                break;
            }
            case 2: {
                this.doContinue();
                break;
            }
            case 12: {
                this.doHome();
                break;
            }
            case 19: {
                this.doHelp();
                break;
            }
            case 20: {
                this.doShow();
                break;
            }
            case 3: {
                this.doStep();
                break;
            }
            case 4: {
                this.doNext();
                break;
            }
            case 5: {
                this.doFinish();
                break;
            }
            case 6: {
                this.doBreak();
                break;
            }
            case 18: {
                this.doClear();
                break;
            }
            case 7: {
                this.doSet();
                break;
            }
            case 8: {
                this.doList();
                break;
            }
            case 9: {
                this.doPrint();
                break;
            }
            case 10: {
                this.doTutorial();
                break;
            }
            case 11: {
                this.doInfo();
                break;
            }
            case 14: {
                this.doFile();
                break;
            }
            case 15: {
                this.doDelete();
                break;
            }
            case 13: {
                this.doRun();
                break;
            }
            case 16: {
                this.doSource();
                break;
            }
            case 21: {
                this.doKill();
                break;
            }
            case 22: {
                this.doHandle();
                break;
            }
            case 23: {
                this.doEnable();
                break;
            }
            case 24: {
                this.doDisable();
                break;
            }
            case 25: {
                this.doDisplay();
                break;
            }
            case 26: {
                this.doUnDisplay();
                break;
            }
            case 27: {
                this.doCommands();
                break;
            }
            case 28: {
                this.doPWD();
                break;
            }
            case 29: {
                this.doCF();
                break;
            }
            case 32: {
                this.doWatch(false, true);
                break;
            }
            case 30: {
                this.doCondition();
                break;
            }
            case 34: {
                this.doWhat();
                break;
            }
            case 35: {
                this.doDisassemble();
                break;
            }
            case 36: {
                this.doHalt();
                break;
            }
            case 37: {
                this.doMcTree();
                break;
            }
            case 38: {
                this.doViewSwf();
                break;
            }
            case 39: {
                this.doDown();
                break;
            }
            case 40: {
                this.doUp();
                break;
            }
            case 41: {
                this.doFrame();
                break;
            }
            case 17: {
                break;
            }
            case 109: {
                this.doInfoStack();
                break;
            }
            case 42: {
                this.doDirectory();
                break;
            }
            case 43: {
                this.doCatch();
                break;
            }
            case 44: {
                this.doConnect();
                break;
            }
            case 45: {
                this.doWorker();
                break;
            }
            default: {
                this.doUnknown(string);
            }
        }
        return bl;
    }

    void doWorker() throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException {
        String string;
        if (this.hasMoreTokens() && (string = this.nextToken()) != null && string.length() > 0) {
            int n = Integer.parseInt(string);
            this.doWorker(++n, true);
        }
    }

    void doWorker(int n, boolean bl) throws IOException, NotSupportedException, NotSuspendedException, NoResponseException, NotConnectedException {
        try {
            boolean bl2 = false;
            for (Isolate isolate : this.m_session.getWorkers()) {
                if (isolate.getId() != n) continue;
                bl2 = true;
                break;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                this.m_activeIsolate = n;
                this.propertyPut(LIST_WORKER, n);
                this.propertyPut(LIST_LINE, 1);
                this.propertyPut(LIST_MODULE, 1);
                this.propertyPut(BPNUM, 0);
                this.propertyPut(LAST_FRAME_DEPTH, 0);
                this.propertyPut(CURRENT_FRAME_DEPTH, 0);
                this.propertyPut(DISPLAY_FRAME_NUMBER, 0);
                if (bl) {
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("workerChanged") + " ");
                    if (n == 1) {
                        stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("mainThread"));
                    } else {
                        stringBuilder.append(n - 1);
                    }
                    stringBuilder.append(m_newline);
                }
            } else if (bl) {
                stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("workerNotFound") + " " + (n - 1));
                stringBuilder.append(m_newline);
            }
            if (bl) {
                this.out(stringBuilder.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.err(numberFormatException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getHelpTopic(String string) {
        CharSequence charSequence;
        InputStream inputStream = Help.getResourceAsStream();
        if (inputStream == null) {
            return DebugCLI.getLocalizationManager().getLocalizedTextString("noHelpFileFound");
        }
        string = "[" + string + "]";
        Vector<CharSequence> vector = new Vector<CharSequence>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((charSequence = bufferedReader.readLine()) != null && !((String)charSequence).startsWith(string)) {
            }
            while ((charSequence = bufferedReader.readLine()) != null) {
                if (((String)charSequence).startsWith("[")) {
                    break;
                }
                vector.add(charSequence);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.err(fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            this.err(iOException.getLocalizedMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        charSequence = new StringBuilder();
        int n = vector.size();
        for (int i = 1; i < n - 1; ++i) {
            String string2 = (String)vector.get(i);
            ((StringBuilder)charSequence).append(string2);
            if (i == n - 2) continue;
            ((StringBuilder)charSequence).append(m_newline);
        }
        return ((StringBuilder)charSequence).toString();
    }

    void doHelp() throws AmbiguousException {
        String string = "help";
        if (this.hasMoreTokens()) {
            String string2;
            int n = this.commandFor(this.nextToken());
            string = string2 = this.commandNumberToCommandName(g_commandArray, n);
            if (n == 11 && this.hasMoreTokens()) {
                n = this.infoCommandFor(this.nextToken());
                string2 = this.commandNumberToCommandName(g_infoCommandArray, n);
                string = string + " " + string2;
            } else if (n == 20 && this.hasMoreTokens()) {
                n = this.showCommandFor(this.nextToken());
                string2 = this.commandNumberToCommandName(g_showCommandArray, n);
                string = string + " " + string2;
            }
        }
        this.out(this.getHelpTopic(string));
    }

    void doTutorial() {
        this.out(this.getHelpTopic("Tutorial"));
    }

    int commandFor(String string) throws AmbiguousException {
        return this.determineCommand(g_commandArray, string, 0);
    }

    int showCommandFor(String string) throws AmbiguousException {
        return this.determineCommand(g_showCommandArray, string, 200);
    }

    int infoCommandFor(String string) throws AmbiguousException {
        return this.determineCommand(g_infoCommandArray, string, 100);
    }

    int enableCommandFor(String string) throws AmbiguousException {
        return this.determineCommand(g_enableCommandArray, string, 0);
    }

    int disableCommandFor(String string) throws AmbiguousException {
        return this.determineCommand(g_disableCommandArray, string, 0);
    }

    int determineCommand(StringIntArray stringIntArray, String string, int n) throws AmbiguousException {
        int n2 = n;
        if (string.charAt(0) == '#') {
            n2 = 17;
        } else {
            ArrayList<Integer> arrayList = stringIntArray.elementsStartingWith(string);
            int n3 = arrayList.size();
            if (n3 != 0) {
                if (n3 == 1 || string.length() == 1 || stringIntArray.getString(arrayList.get(0)).compareTo(string) == 0) {
                    n2 = stringIntArray.getInteger(arrayList.get(0));
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("input", string);
                    stringBuilder.append(DebugCLI.getLocalizationManager().getLocalizedTextString("ambiguousCommand", hashMap));
                    stringBuilder.append(' ');
                    stringBuilder.append(string);
                    for (int i = 0; i < n3; ++i) {
                        String string2 = stringIntArray.getString(arrayList.get(i));
                        stringBuilder.append(string2);
                        if (i + 1 >= n3) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append('.');
                    this.err(stringBuilder.toString());
                    throw new AmbiguousException();
                }
            }
        }
        return n2;
    }

    String commandNumberToCommandName(StringIntArray stringIntArray, int n) {
        for (int i = 0; i < stringIntArray.size(); ++i) {
            if (stringIntArray.getInt(i) != n) continue;
            return stringIntArray.getString(i);
        }
        return "?";
    }

    void appendBreakInfo(StringBuilder stringBuilder, int n) throws NotConnectedException {
        Extensions.appendBreakInfo(this, stringBuilder, false, n);
    }

    void doShowStats() {
        Extensions.doShowStats(this);
    }

    void doShowFuncs() {
        Extensions.doShowFuncs(this);
    }

    void doShowProperties() {
        Extensions.doShowProperties(this);
    }

    void doShowVariable() throws PlayerDebugException {
        Extensions.doShowVariable(this);
    }

    void doShowBreak() throws NotConnectedException {
        Extensions.doShowBreak(this);
    }

    void doDisassemble() throws PlayerDebugException {
        Extensions.doDisassemble(this);
    }

    static {
        m_localizationManager.addLocalizer(new DebuggerLocalizer("flex.tools.debugger.cli.fdb."));
        FRAMEWORK_FILE_PACKAGES = new String[]{"mx", "flex", "text"};
        g_commandArray = new StringIntArray((Object[])new Object[][]{{"awatch", new Integer(31)}, {"break", new Integer(6)}, {"bt", new Integer(109)}, {"continue", new Integer(2)}, {"catch", new Integer(43)}, {"cf", new Integer(29)}, {"clear", new Integer(18)}, {"commands", new Integer(27)}, {"condition", new Integer(30)}, {"connect", new Integer(44)}, {"delete", new Integer(15)}, {"disable", new Integer(24)}, {"disassemble", new Integer(35)}, {"display", new Integer(25)}, {"directory", new Integer(42)}, {"down", new Integer(39)}, {"enable", new Integer(23)}, {"finish", new Integer(5)}, {"file", new Integer(14)}, {"frame", new Integer(41)}, {"help", new Integer(19)}, {"halt", new Integer(36)}, {"handle", new Integer(22)}, {"home", new Integer(12)}, {"info", new Integer(11)}, {"kill", new Integer(21)}, {"list", new Integer(8)}, {"next", new Integer(4)}, {"nexti", new Integer(4)}, {"mctree", new Integer(37)}, {"print", new Integer(9)}, {"pwd", new Integer(28)}, {"quit", new Integer(1)}, {"run", new Integer(13)}, {"rwatch", new Integer(33)}, {"step", new Integer(3)}, {"stepi", new Integer(3)}, {"set", new Integer(7)}, {"show", new Integer(20)}, {"source", new Integer(16)}, {"tutorial", new Integer(10)}, {"undisplay", new Integer(26)}, {"up", new Integer(40)}, {"where", new Integer(109)}, {"watch", new Integer(32)}, {"what", new Integer(34)}, {"viewswf", new Integer(38)}, {"worker", new Integer(45)}});
        g_infoCommandArray = new StringIntArray((Object[])new Object[][]{{"arguments", new Integer(101)}, {"breakpoints", new Integer(102)}, {"display", new Integer(111)}, {"files", new Integer(103)}, {"functions", new Integer(105)}, {"handle", new Integer(104)}, {"locals", new Integer(106)}, {"stack", new Integer(109)}, {"scopechain", new Integer(107)}, {"sources", new Integer(108)}, {"swfs", new Integer(113)}, {"targets", new Integer(112)}, {"variables", new Integer(110)}, {"workers", new Integer(114)}});
        g_showCommandArray = new StringIntArray((Object[])new Object[][]{{"break", new Integer(206)}, {"directories", new Integer(210)}, {"files", new Integer(205)}, {"functions", new Integer(202)}, {"locations", new Integer(209)}, {"memory", new Integer(208)}, {"net", new Integer(201)}, {"properties", new Integer(204)}, {"uri", new Integer(203)}, {"variable", new Integer(207)}});
        g_enableCommandArray = new StringIntArray((Object[])new Object[][]{{"breakpoints", new Integer(6)}, {"display", new Integer(25)}, {"delete", new Integer(15)}, {"once", new Integer(301)}});
        g_disableCommandArray = new StringIntArray((Object[])new Object[][]{{"display", new Integer(25)}, {"breakpoints", new Integer(6)}});
    }

    private static class ModuleFunctionPair
    implements Comparable<ModuleFunctionPair> {
        public int moduleId;
        public String functionName;

        public ModuleFunctionPair(int n, String string) {
            this.moduleId = n;
            this.functionName = string;
        }

        @Override
        public int compareTo(ModuleFunctionPair moduleFunctionPair) {
            return this.functionName.compareTo(moduleFunctionPair.functionName);
        }
    }

    private static interface AnyKindOfStep {
        public void step() throws PlayerDebugException;
    }

    class DebugCLIIsolateState {
        public boolean m_requestResume;
        public boolean m_requestHalt;
        public boolean m_stepResume;
        public InitialPromptState m_promptState;

        public DebugCLIIsolateState(DebugCLI debugCLI2) {
            DebugCLI.this.m_faultTable = faultActionsBuilder.build();
        }
    }

    public static enum InitialPromptState {
        NEVER_SHOWN,
        SHOWN_ONCE,
        DONE;

    }
}

