/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.ArrayList;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BinaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class MemberAccessEmitter
extends JSSubEmitter
implements ISubEmitter<IMemberAccessExpressionNode> {
    public MemberAccessEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IMemberAccessExpressionNode node) {
        IASNode parentNode;
        boolean forceXmlCheck;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        IExpressionNode leftNode = node.getLeftOperandNode();
        IExpressionNode rightNode = node.getRightOperandNode();
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (fjs.isDateProperty((IExpressionNode)node, false)) {
            this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
            String rightName = ((IIdentifierNode)rightNode).getName();
            BinaryOperatorEmitter.DatePropertiesGetters propGetter = BinaryOperatorEmitter.DatePropertiesGetters.valueOf(rightName.toUpperCase());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(propGetter.getFunctionName());
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                this.write(ASEmitterTokens.PAREN_CLOSE);
            }
            return;
        }
        IDefinition def = node.resolve(this.getProject());
        boolean bl = forceXmlCheck = def != null && node.getRightOperandNode().getNodeID() == ASTNodeID.IdentifierID && SemanticUtils.isXMLish((IDefinition)def.getParent(), (ICompilerProject)this.getProject()) && def instanceof IFunctionDefinition && !def.isStatic() && (this.getModel().getCurrentClass() == null || !this.getModel().getCurrentClass().getQualifiedName().equals("XML") && !this.getModel().getCurrentClass().getQualifiedName().equals("XMLList"));
        if (def == null || forceXmlCheck) {
            IASNode parentNode2 = node.getParent();
            boolean isXML = false;
            boolean isProxy = false;
            if (leftNode instanceof MemberAccessExpressionNode) {
                isXML = fjs.isLeftNodeXMLish(leftNode);
            } else if (leftNode != null) {
                isXML = fjs.isXMLish(leftNode);
            }
            if (!isXML) {
                if (leftNode instanceof MemberAccessExpressionNode) {
                    isProxy = fjs.isProxy(leftNode);
                } else if (leftNode instanceof IExpressionNode) {
                    isProxy = fjs.isProxy(leftNode);
                }
            }
            if (isXML) {
                boolean child;
                boolean descendant = node.getOperator() == IOperatorNode.OperatorType.DESCENDANT_ACCESS;
                boolean bl2 = child = !descendant && node.getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS && !(parentNode2 instanceof FunctionCallNode) && rightNode.getNodeID() != ASTNodeID.Op_AtID && (rightNode.getNodeID() != ASTNodeID.ArrayIndexExpressionID || ((DynamicAccessNode)rightNode).getLeftOperandNode().getNodeID() != ASTNodeID.Op_AtID);
                if (descendant || child) {
                    this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    if (descendant) {
                        this.write(".descendants(");
                    }
                    if (child) {
                        this.write(".child(");
                    }
                    String closeMethodCall = "')";
                    String s = "";
                    boolean isNamespaceAccessNode = rightNode instanceof INamespaceAccessExpressionNode;
                    ArrayList<INamespaceDefinition> usedNamespaceDefs = null;
                    if (!isNamespaceAccessNode) {
                        for (NamespaceDefinition.INamespaceDirective item = ((NodeBase)node).getASScope().getFirstNamespaceDirective(); item != null; item = item.getNext()) {
                            if (!(item instanceof NamespaceDefinition.IUseNamespaceDirective)) continue;
                            INamespaceDefinition itemDef = ((NamespaceDefinition.IUseNamespaceDirective)item).resolveNamespaceReference(this.getProject());
                            if (itemDef == null) {
                                IDefinition iDefinition = ((NodeBase)node).getASScope().findProperty(this.getProject(), ((NamespaceDefinition.IUseNamespaceDirective)item).getBaseName(), DependencyType.NAMESPACE);
                                if (!(iDefinition instanceof IVariableDefinition)) continue;
                            }
                            if (usedNamespaceDefs == null) {
                                usedNamespaceDefs = new ArrayList<INamespaceDefinition>();
                            }
                            if (usedNamespaceDefs.contains(itemDef)) continue;
                            usedNamespaceDefs.add(itemDef);
                        }
                    }
                    if (isNamespaceAccessNode || usedNamespaceDefs != null) {
                        if (isNamespaceAccessNode) {
                            NamespaceIdentifierNode namespaceIdentifierNode = (NamespaceIdentifierNode)((INamespaceAccessExpressionNode)rightNode).getLeftOperandNode();
                            IDefinition nsDef = namespaceIdentifierNode.resolve(this.getProject());
                            if (nsDef instanceof INamespaceDefinition && ((INamespaceDefinition)nsDef).getNamespaceClassification().equals((Object)INamespaceDefinition.NamespaceClassification.LANGUAGE)) {
                                String string = ((NamespaceIdentifierNode)((INamespaceAccessExpressionNode)rightNode).getLeftOperandNode()).getName();
                                if (string.equals("*")) {
                                    this.write("new QName(null,'");
                                    rightNode = ((INamespaceAccessExpressionNode)rightNode).getRightOperandNode();
                                    closeMethodCall = "'))";
                                } else if (string.equals("public") || string.equals("protected")) {
                                    this.write("/* as3 " + string + " */ '");
                                    rightNode = ((INamespaceAccessExpressionNode)rightNode).getRightOperandNode();
                                } else {
                                    this.write("new QName('");
                                    this.write("_as3Lang_" + fjs.stringifyNode((IASNode)namespaceIdentifierNode));
                                    this.write(s + "','");
                                    rightNode = ((INamespaceAccessExpressionNode)rightNode).getRightOperandNode();
                                    closeMethodCall = "'))";
                                }
                            } else {
                                this.write("new QName(");
                                s = fjs.stringifyNode((IASNode)namespaceIdentifierNode);
                                this.write(s + ",'");
                                rightNode = ((INamespaceAccessExpressionNode)rightNode).getRightOperandNode();
                                closeMethodCall = "'))";
                            }
                        } else {
                            this.write("XML.multiQName([");
                            int count = 0;
                            for (IDefinition iDefinition : usedNamespaceDefs) {
                                if (count > 0) {
                                    this.write(",");
                                }
                                if (iDefinition instanceof INamespaceDefinition) {
                                    this.write("'" + ((INamespaceDefinition)iDefinition).getURI() + "'");
                                } else {
                                    String varName = this.getEmitter().stringifyNode((IASNode)((IVariableDefinition)iDefinition).getVariableNode().getNameExpressionNode());
                                    this.write(varName);
                                }
                                ++count;
                            }
                            this.write("]");
                            this.write(", '");
                            closeMethodCall = "'))";
                        }
                    } else if (this.getModel().defaultXMLNamespaceActive.booleanValue() && ((MemberAccessExpressionNode)node).getASScope() instanceof FunctionScope && this.getModel().getDefaultXMLNamespace((FunctionScope)((MemberAccessExpressionNode)node).getASScope()) != null) {
                        this.write("new QName(");
                        this.getEmitter().getWalker().walk((IASNode)this.getModel().getDefaultXMLNamespace((FunctionScope)((MemberAccessExpressionNode)node).getASScope()));
                        this.write(",'");
                        closeMethodCall = "'))";
                    } else {
                        this.write("'");
                    }
                    s = fjs.stringifyNode((IASNode)rightNode);
                    int dot = s.indexOf(46);
                    if (dot != -1) {
                        String name = s.substring(0, dot);
                        String string = s.substring(dot);
                        this.write(name);
                        this.write(closeMethodCall);
                        this.write(string);
                    } else {
                        this.write(s);
                        this.write(closeMethodCall);
                    }
                    if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    }
                    return;
                }
            } else if (isProxy) {
                boolean child;
                boolean bl3 = child = node.getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS && !(parentNode2 instanceof FunctionCallNode) && rightNode.getNodeID() != ASTNodeID.Op_AtID;
                if (child) {
                    String s;
                    int dot;
                    this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    if (child) {
                        this.write(".getProperty(");
                    }
                    if ((dot = (s = fjs.stringifyNode((IASNode)rightNode)).indexOf(46)) != -1) {
                        String name = s.substring(0, dot);
                        String afterDot = s.substring(dot);
                        this.write("'");
                        this.write(name);
                        this.write("'");
                        this.write(")");
                        this.write(afterDot);
                    } else {
                        if (s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) {
                            this.write(s);
                        } else {
                            this.write("'");
                            this.write(s);
                            this.write("'");
                        }
                        this.write(")");
                    }
                    return;
                }
            } else if (rightNode instanceof NamespaceAccessExpressionNode) {
                NamespaceAccessExpressionNode naen = (NamespaceAccessExpressionNode)rightNode;
                IDefinition d = naen.getLeftOperandNode().resolve(this.getProject());
                IdentifierNode r = (IdentifierNode)naen.getRightOperandNode();
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                if (((NamespaceAccessExpressionNode)rightNode).resolve(this.getProject()) instanceof IVariableDefinition) {
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(d.toString(), r.getName(), true));
                } else {
                    this.write(ASEmitterTokens.SQUARE_OPEN);
                    this.write(ASEmitterTokens.NEW);
                    this.write(ASEmitterTokens.SPACE);
                    this.write("QName");
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(fjs.formatQualifiedName(d.getQualifiedName()));
                    this.write(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(r.getName());
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(".objectAccessFormat()");
                    this.write(ASEmitterTokens.SQUARE_CLOSE);
                }
                return;
            }
        } else {
            if (def.getParent() instanceof IPackageDefinition) {
                this.write(fjs.formatQualifiedName(def.getQualifiedName()));
                return;
            }
            if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array")) {
                if (def.getBaseName().equals("removeAt")) {
                    this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    this.write(".splice");
                    return;
                }
                if (def.getBaseName().equals("insertAt")) {
                    this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    this.write(".splice");
                    return;
                }
            } else if (rightNode instanceof NamespaceAccessExpressionNode) {
                IASNode parentNode3;
                boolean isStatic = false;
                if (def != null && def.isStatic()) {
                    isStatic = true;
                }
                boolean needClosure = false;
                if (def instanceof FunctionDefinition && !(def instanceof AccessorDefinition) && !def.getBaseName().equals("constructor") && (parentNode3 = node.getParent()) != null) {
                    ASTNodeID parentNodeId = parentNode3.getNodeID();
                    boolean bl4 = needClosure = !isStatic && parentNodeId != ASTNodeID.FunctionCallID && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.ArrayIndexExpressionID;
                }
                if (needClosure && this.getEmitter().getDocEmitter() instanceof JSRoyaleDocEmitter && ((JSRoyaleDocEmitter)this.getEmitter().getDocEmitter()).getSuppressClosure().booleanValue()) {
                    needClosure = false;
                }
                if (needClosure) {
                    this.getEmitter().emitClosureStart();
                }
                NamespaceAccessExpressionNode naen = (NamespaceAccessExpressionNode)rightNode;
                IDefinition d = naen.getLeftOperandNode().resolve(this.getProject());
                IdentifierNode r = (IdentifierNode)naen.getRightOperandNode();
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                if (!d.getBaseName().equals(ASEmitterTokens.PRIVATE.getToken())) {
                    if (naen.resolve(this.getProject()) instanceof IVariableDefinition) {
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(d.toString(), r.getName(), true));
                    } else {
                        this.write(ASEmitterTokens.SQUARE_OPEN);
                        this.write(ASEmitterTokens.NEW);
                        this.write(ASEmitterTokens.SPACE);
                        this.write("QName");
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        this.write(fjs.formatQualifiedName(d.getQualifiedName()));
                        this.write(ASEmitterTokens.COMMA);
                        this.write(ASEmitterTokens.SPACE);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(r.getName());
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(".objectAccessFormat()");
                        this.write(ASEmitterTokens.SQUARE_CLOSE);
                    }
                } else {
                    this.write(node.getOperator().getOperatorText());
                    this.write(r.getName());
                }
                if (needClosure) {
                    this.write(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.SPACE);
                    if (leftNode.getNodeID() == ASTNodeID.SuperID) {
                        this.write(ASEmitterTokens.THIS);
                    } else {
                        this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
                    }
                    this.getEmitter().emitClosureEnd((IASNode)leftNode, def);
                }
                return;
            }
        }
        boolean isCustomNamespace = false;
        if (def instanceof FunctionDefinition && node.getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS) {
            isCustomNamespace = fjs.isCustomNamespace((FunctionDefinition)def);
        }
        boolean isStatic = false;
        if (def != null && def.isStatic()) {
            isStatic = true;
        }
        boolean needClosure = false;
        if (def instanceof FunctionDefinition && !(def instanceof AccessorDefinition) && !def.getBaseName().equals("constructor") && (parentNode = node.getParent()) != null) {
            ASTNodeID parentNodeId = parentNode.getNodeID();
            boolean bl5 = needClosure = !isStatic && parentNodeId != ASTNodeID.FunctionCallID && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.ArrayIndexExpressionID;
            if (needClosure && this.getEmitter().getDocEmitter() instanceof JSRoyaleDocEmitter && ((JSRoyaleDocEmitter)this.getEmitter().getDocEmitter()).getSuppressClosure().booleanValue()) {
                needClosure = false;
            }
        }
        boolean continueWalk = true;
        if (!isStatic) {
            if (needClosure) {
                this.getEmitter().emitClosureStart();
            }
            continueWalk = this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
        }
        if (continueWalk) {
            IIdentifierNode identifierNode;
            IDefinition resolvedDefinition;
            boolean emitDynamicAccess = false;
            boolean dynamicAccessUnknownMembers = false;
            ICompilerProject project = this.getProject();
            if (project instanceof RoyaleJSProject) {
                RoyaleJSProject fjsProject = (RoyaleJSProject)project;
                if (fjsProject.config != null) {
                    dynamicAccessUnknownMembers = fjsProject.config.getJsDynamicAccessUnknownMembers();
                }
                if (!dynamicAccessUnknownMembers) {
                    TypeDefinitionBase type;
                    VariableDefinition varDef;
                    IIdentifierNode checkNode = null;
                    if (leftNode instanceof IIdentifierNode) {
                        checkNode = (IIdentifierNode)leftNode;
                    } else if (leftNode instanceof MemberAccessExpressionNode) {
                        MemberAccessExpressionNode mae = (MemberAccessExpressionNode)leftNode;
                        while (mae != null) {
                            if (mae.getRightOperandNode().resolve(this.getProject()) == null) {
                                if (mae.getLeftOperandNode() instanceof IIdentifierNode) {
                                    checkNode = (IIdentifierNode)mae.getLeftOperandNode();
                                    break;
                                }
                                if (mae.getLeftOperandNode() instanceof MemberAccessExpressionNode) {
                                    mae = (MemberAccessExpressionNode)mae.getLeftOperandNode();
                                    continue;
                                }
                                mae = null;
                                continue;
                            }
                            mae = null;
                        }
                    }
                    if (checkNode != null && checkNode.resolve(this.getProject()) instanceof VariableDefinition && (varDef = (VariableDefinition)checkNode.resolve(this.getProject())).isMXMLDeclared() && (type = varDef.resolveType(this.getProject())) instanceof IClassDefinition && type.equals(this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT))) {
                        dynamicAccessUnknownMembers = true;
                    }
                }
            }
            if (dynamicAccessUnknownMembers && rightNode instanceof IIdentifierNode && (resolvedDefinition = (identifierNode = (IIdentifierNode)node.getRightOperandNode()).resolve(this.getProject())) == null) {
                emitDynamicAccess = true;
                IExpressionNode expressionNode = node.getLeftOperandNode();
                while (expressionNode != null) {
                    ITypeDefinition expressionType = expressionNode.resolveType(this.getProject());
                    if (SemanticUtils.isXMLish((IDefinition)expressionType, (ICompilerProject)this.getProject())) {
                        emitDynamicAccess = false;
                        break;
                    }
                    if (expressionNode instanceof IMemberAccessExpressionNode) {
                        IMemberAccessExpressionNode iMemberAccessExpressionNode = (IMemberAccessExpressionNode)expressionNode;
                        expressionNode = iMemberAccessExpressionNode.getLeftOperandNode();
                        continue;
                    }
                    if (expressionNode instanceof IDynamicAccessNode) {
                        IDynamicAccessNode iDynamicAccessNode = (IDynamicAccessNode)expressionNode;
                        expressionNode = iDynamicAccessNode.getLeftOperandNode();
                        continue;
                    }
                    expressionNode = null;
                    break;
                }
            }
            if (emitDynamicAccess) {
                identifierNode = (IIdentifierNode)node.getRightOperandNode();
                this.startMapping((ISourceLocation)node, (ISourceLocation)rightNode);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.write(ASEmitterTokens.DOUBLE_QUOTE);
                this.write(identifierNode.getName());
                this.write(ASEmitterTokens.DOUBLE_QUOTE);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
                this.endMapping((ISourceLocation)node);
            } else {
                if (!isStatic && !isCustomNamespace) {
                    this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
                    this.write(node.getOperator().getOperatorText());
                    this.endMapping((ISourceLocation)node);
                }
                this.getWalker().walk((IASNode)node.getRightOperandNode());
            }
        }
        if (needClosure) {
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            if (leftNode.getNodeID() == ASTNodeID.SuperID) {
                this.write(ASEmitterTokens.THIS);
            } else {
                this.writeLeftSide(node, (IASNode)leftNode, (IASNode)rightNode);
            }
            this.getEmitter().emitClosureEnd((IASNode)node, def);
        }
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    private boolean writeLeftSide(IMemberAccessExpressionNode node, IASNode leftNode, IASNode rightNode) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (!(leftNode instanceof ILanguageIdentifierNode) || ((ILanguageIdentifierNode)leftNode).getKind() != ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
            IDefinition rightDef = null;
            if (rightNode instanceof IIdentifierNode) {
                rightDef = ((IIdentifierNode)rightNode).resolve(this.getProject());
            }
            if (leftNode.getNodeID() != ASTNodeID.SuperID) {
                this.getWalker().walk((IASNode)node.getLeftOperandNode());
            } else {
                if (rightNode.getNodeID() == ASTNodeID.GetterID || rightDef != null && rightDef instanceof AccessorDefinition) {
                    this.write(this.getEmitter().formatQualifiedName(this.getEmitter().getModel().getCurrentClass().getQualifiedName()));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSGoogEmitterTokens.SUPERCLASS);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    if (rightDef != null) {
                        this.write(fjs.formatGetter(rightDef.getBaseName()));
                    } else {
                        this.write(fjs.formatGetter(((IGetterNode)rightNode).getName()));
                    }
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.APPLY);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.THIS);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    return false;
                }
                if (rightDef != null && rightDef instanceof FunctionDefinition) {
                    this.write(this.getEmitter().formatQualifiedName(this.getEmitter().getModel().getCurrentClass().getQualifiedName()));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSGoogEmitterTokens.SUPERCLASS);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(rightDef.getBaseName());
                    return false;
                }
                if (rightDef != null && rightDef instanceof VariableDefinition) {
                    this.startMapping((ISourceLocation)leftNode);
                    this.write(ASEmitterTokens.THIS);
                    this.endMapping((ISourceLocation)leftNode);
                }
            }
        } else {
            this.startMapping((ISourceLocation)leftNode);
            this.write(ASEmitterTokens.THIS);
            this.endMapping((ISourceLocation)leftNode);
        }
        return true;
    }
}

