/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.clients.PlayerglobalcConfiguration;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.config.PlayerglobalcConfigurator;
import org.apache.royale.compiler.targets.ITarget;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

class PLAYERGLOBALC
implements FlexTool {
    private static final List<String> VECTOR_SUFFIXES = Arrays.asList("$double", "$int", "$uint", "$object");
    private static final List<String> OBJECT_PROTOTYPE_METHODS = Arrays.asList("setPropertyIsEnumerable", "toString", "toLocaleString", "valueOf");
    private static final List<String> OBJECT_AS3_METHODS = Arrays.asList("hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable");
    private static final List<String> ANY_CONSTRUCTORS = Arrays.asList("ArgumentError", "Boolean", "Date", "DefinitionError", "Error", "EvalError", "int", "Number", "RangeError", "ReferenceError", "RegExp", "SecurityError", "String", "SyntaxError", "TypeError", "uint", "URIError", "VerifyError", "XML", "XMLList");
    private static final Map<String, String> GLOBAL_CONSTANTS = new HashMap<String, String>();
    private static final Map<String, List<String>> WRITABLE_VARIABLES = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> REST_METHODS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> NULL_DEFAULT_METHODS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> ANY_METHODS = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> ANY_VARIABLES = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> EXTRA_MEMBERS = new HashMap<String, List<String>>();
    protected ProblemQuery problems;
    protected Configurator projectConfigurator;
    protected PlayerglobalcConfiguration configuration;
    private File sourceFolder;
    private File targetFolder;
    private File currentFile;

    public static void main(String[] args) {
        PLAYERGLOBALC compiler = new PLAYERGLOBALC();
        int exitCode = compiler.execute(args);
        System.exit(exitCode);
    }

    public PLAYERGLOBALC() {
        GLOBAL_CONSTANTS.put("Infinity", "1 / 0");
        GLOBAL_CONSTANTS.put("NaN", "0 / 0");
        GLOBAL_CONSTANTS.put("undefined", "void 0");
        WRITABLE_VARIABLES.put("flash.external.ExternalInterface", Arrays.asList("marshallExceptions"));
        REST_METHODS.put("Array", Arrays.asList("splice"));
        REST_METHODS.put("__AS3__.vec.Vector$object", Arrays.asList("sort"));
        REST_METHODS.put("__AS3__.vec.Vector$double", Arrays.asList("sort"));
        REST_METHODS.put("__AS3__.vec.Vector$int", Arrays.asList("sort"));
        REST_METHODS.put("__AS3__.vec.Vector$uint", Arrays.asList("sort"));
        NULL_DEFAULT_METHODS.put("Date", Arrays.asList("setFullYear", "setMonth", "setDate", "setHours", "setMinutes", "setSeconds", "setMilliseconds", "setUTCFullYear", "setUTCMonth", "setUTCDate", "setUTCHours", "setUTCMinutes", "setUTCSeconds", "setUTCMilliseconds", "setTime"));
        NULL_DEFAULT_METHODS.put("Number", Arrays.asList("toExponential", "toFixed", "toPrecision"));
        NULL_DEFAULT_METHODS.put("Object", Arrays.asList("hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable"));
        ANY_METHODS.put("Date", Arrays.asList("setFullYear", "setMonth", "setDate", "setHours", "setMinutes", "setSeconds", "setMilliseconds", "setUTCFullYear", "setUTCMonth", "setUTCDate", "setUTCHours", "setUTCMinutes", "setUTCSeconds", "setUTCMilliseconds", "setTime", "UTC", "parse"));
        ANY_METHODS.put("Number", Arrays.asList("toExponential", "toFixed", "toPrecision", "toString"));
        ANY_METHODS.put("Object", Arrays.asList("hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable"));
        ANY_METHODS.put("XML", Arrays.asList("addNamespace", "appendChild", "attribute", "child", "contains", "descendants", "elements", "insertChildAfter", "insertChildBefore", "namespace", "prependChild", "processingInstructions", "removeNamespace", "replace", "setChildren", "setName", "setNamespace"));
        ANY_METHODS.put("XMLList", Arrays.asList("addNamespace", "appendChild", "attribute", "child", "contains", "descendants", "elements", "insertChildAfter", "insertChildBefore", "namespace", "prependChild", "processingInstructions", "removeNamespace", "replace", "setChildren", "setName", "setNamespace"));
        ANY_VARIABLES.put("Object", Arrays.asList("constructor"));
        EXTRA_MEMBERS.put("Array", Arrays.asList("AS3 native function insertAt(index:int, element:*):void", "AS3 native function removeAt(index:int):*"));
        EXTRA_MEMBERS.put("Function", Arrays.asList("public native function get prototype():*", "public native function set prototype(value:*):void", "public native function get length():int;"));
        EXTRA_MEMBERS.put("String", Arrays.asList("AS3 native function toString():String"));
        EXTRA_MEMBERS.put("__AS3__.vec.Vector$double", Arrays.asList("AS3 native function insertAt(index:int, element:Number):void", "AS3 native function removeAt(index:int):Number"));
        EXTRA_MEMBERS.put("__AS3__.vec.Vector$int", Arrays.asList("AS3 native function insertAt(index:int, element:int):void", "AS3 native function removeAt(index:int):int"));
        EXTRA_MEMBERS.put("__AS3__.vec.Vector$uint", Arrays.asList("AS3 native function insertAt(index:int, element:uint):void", "AS3 native function removeAt(index:int):uint"));
        EXTRA_MEMBERS.put("__AS3__.vec.Vector$object", Arrays.asList("AS3 native function insertAt(index:int, element:Object):void", "AS3 native function removeAt(index:int):Object"));
        EXTRA_MEMBERS.put("flash.display.DisplayObjectContainer", Arrays.asList("public native function removeChildren(beginIndex:int = 0, endIndex:int = 0x7fffffff):void"));
        EXTRA_MEMBERS.put("flash.display.Graphics", Arrays.asList("public native function cubicCurveTo(controlX1:Number, controlY1:Number, controlX2:Number, controlY2:Number, anchorX:Number, anchorY:Number):void", "public native function drawRoundRectComplex(x:Number, y:Number, width:Number, height:Number, topLeftRadius:Number, topRightRadius:Number, bottomLeftRadius:Number, bottomRightRadius:Number):void"));
        EXTRA_MEMBERS.put("flash.display.MovieClip", Arrays.asList("public native function addFrameScript(...args):void"));
        EXTRA_MEMBERS.put("flash.display.Stage", Arrays.asList("public native function get contentsScaleFactor():Number", "public native function get browserZoomFactor():Number"));
        EXTRA_MEMBERS.put("flash.events.Event", Arrays.asList("public static const BROWSER_ZOOM_CHANGE:String = \"browserZoomChange\""));
        EXTRA_MEMBERS.put("flash.events.EventDispatcher", Arrays.asList("public native function toString():String"));
        EXTRA_MEMBERS.put("flash.geom.Matrix", Arrays.asList("public native function copyFrom(sourceMatrix:flash.geom.Matrix):void", "public native function copyColumnFrom(column:uint, vector3D:flash.geom.Vector3D):void", "public native function copyColumnTo(column:uint, vector3D:flash.geom.Vector3D):void", "public native function copyRowFrom(row:uint, vector3D:flash.geom.Vector3D):void", "public native function copyRowTo(row:uint, vector3D:flash.geom.Vector3D):void", "public native function setTo(a:Number, b:Number, c:Number, d:Number, tx:Number, ty:Number):void"));
        EXTRA_MEMBERS.put("flash.geom.Matrix3D", Arrays.asList("public native function copyFrom(sourceMatrix3D:flash.geom.Matrix3D):void", "public native function copyColumnFrom(column:uint, vector3D:flash.geom.Vector3D):void", "public native function copyColumnTo(column:uint, vector3D:flash.geom.Vector3D):void", "public native function copyRowFrom(row:uint, vector3D:flash.geom.Vector3D):void", "public native function copyRowTo(row:uint, vector3D:flash.geom.Vector3D):void", "public native function copyRawDataFrom(vector:Vector.<Number>, index:uint = 0, transpose:Boolean = false):void", "public native function copyRawDataTo(vector:Vector.<Number>, index:uint = 0, transpose:Boolean = false):void"));
        EXTRA_MEMBERS.put("flash.geom.Point", Arrays.asList("public native function copyFrom(sourcePoint:flash.geom.Point):void", "public native function setTo(x:Number, y:Number):void"));
        EXTRA_MEMBERS.put("flash.geom.Rectangle", Arrays.asList("public native function copyFrom(sourceRect:flash.geom.Rectangle):void", "public native function setTo(x:Number, y:Number, width:Number, height:Number):void"));
        EXTRA_MEMBERS.put("flash.geom.Vector3D", Arrays.asList("public native function copyFrom(sourceVector3D:flash.geom.Vector3D):void", "public native function setTo(x:Number, y:Number, z:Number):void"));
        EXTRA_MEMBERS.put("flash.media.Camera", Arrays.asList("public native function copyToByteArray(rect:Rectangle, destination:ByteArray):void"));
        EXTRA_MEMBERS.put("flash.text.TextFormatAlign", Arrays.asList("public static const START:String = \"start\"", "public static const END:String = \"end\""));
    }

    public String getName() {
        return "PLAYERGLOBALC";
    }

    protected Configurator createConfigurator() {
        return new PlayerglobalcConfigurator(PlayerglobalcConfiguration.class);
    }

    protected boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        this.projectConfigurator.setConfiguration(args, "asdoc-root", false);
        this.projectConfigurator.getTargetSettings(ITarget.TargetType.SWC);
        this.configuration = (PlayerglobalcConfiguration)this.projectConfigurator.getConfiguration();
        this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
        this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
        return !this.problems.hasErrors() && this.configuration != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) {
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueGeneration = this.configure(args);
            if (continueGeneration) {
                this.sourceFolder = this.configuration.getASDocRoot();
                this.targetFolder = this.configuration.getAsRoot();
                this.generateSources();
            } else {
                exitCode = this.problems.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
        }
        finally {
            ProblemFormatter formatter = new ProblemFormatter();
            ProblemPrinter printer = new ProblemPrinter(formatter, (OutputStream)System.err);
            printer.printProblems(this.problems.getFilteredProblems());
        }
        return exitCode.getCode();
    }

    public void generateSources() throws Exception {
        this.preclean();
        for (File sourceFile : this.sourceFolder.listFiles()) {
            String sourceFileName;
            if (sourceFile.isDirectory() || !(sourceFileName = sourceFile.getName()).endsWith(".xml") || sourceFileName.endsWith(".dita.xml")) continue;
            this.parseFile(sourceFile);
        }
    }

    private void preclean() throws Exception {
        FileUtils.deleteDirectory((File)this.targetFolder);
    }

    private void writeFileForDefinition(String fullyQualifiedName, boolean airOnly, String contents) throws IOException {
        String[] parts;
        StringBuilder fileNameBuilder = new StringBuilder();
        for (String part : parts = fullyQualifiedName.split("\\.")) {
            fileNameBuilder.append("/");
            fileNameBuilder.append(part);
        }
        fileNameBuilder.append(".as");
        File targetFile = new File(this.targetFolder, fileNameBuilder.toString());
        FileUtils.writeStringToFile((File)targetFile, (String)contents);
    }

    private boolean isAIROnly(Element prologElement) {
        if (prologElement == null) {
            return false;
        }
        Element asMetadataElement = prologElement.element("asMetadata");
        if (asMetadataElement == null) {
            return false;
        }
        Element apiVersionElement = asMetadataElement.element("apiVersion");
        if (apiVersionElement == null) {
            return false;
        }
        List apiPlatformElements = apiVersionElement.elements("apiPlatform");
        if (apiPlatformElements == null || apiPlatformElements.size() == 0) {
            return false;
        }
        for (Element apiPlatformElement : apiPlatformElements) {
            if ("AIR".equals(apiPlatformElement.attributeValue("name"))) continue;
            return false;
        }
        return true;
    }

    private void parseFile(File ditaFile) throws Exception {
        this.currentFile = ditaFile;
        String contents = null;
        try {
            contents = FileUtils.readFileToString((File)ditaFile, (Charset)Charset.forName("utf8"));
        }
        catch (Exception e) {
            System.err.println("Failed to read XML file: " + ditaFile.getAbsolutePath());
            return;
        }
        SAXReader xmlReader = new SAXReader();
        Document xmlDoc = xmlReader.read((Reader)new StringReader(contents));
        Element apiPackageElement = xmlDoc.getRootElement();
        if (!"apiPackage".equals(apiPackageElement.getName())) {
            throw new Exception("No apiPackage root element: " + ditaFile.getAbsolutePath());
        }
        this.parsePackage(apiPackageElement);
        this.currentFile = null;
    }

    private void parsePackage(Element apiPackageElement) throws Exception {
        List apiOperationElements = apiPackageElement.elements("apiOperation");
        for (Object apiOperationElement : apiOperationElements) {
            this.parsePackageFunction((Element)apiOperationElement);
        }
        List apiValueElements = apiPackageElement.elements("apiValue");
        for (Element apiValueElement : apiValueElements) {
            this.parsePackageVariable(apiValueElement);
        }
        List apiClassifierElements = apiPackageElement.elements("apiClassifier");
        for (Element apiClassifierElement : apiClassifierElements) {
            Element apiClassifierDetailElement = apiClassifierElement.element("apiClassifierDetail");
            if (apiClassifierDetailElement == null) {
                String fullyQualifiedName = apiClassifierElement.attributeValue("id");
                throw new Exception("Not found: " + fullyQualifiedName);
            }
            Element apiClassifierDefElement = apiClassifierDetailElement.element("apiClassifierDef");
            if (apiClassifierDefElement == null) {
                String fullyQualifiedName = apiClassifierElement.attributeValue("id");
                throw new Exception("Not found: " + fullyQualifiedName);
            }
            Element apiInterfaceElement = apiClassifierDefElement.element("apiInterface");
            if (apiInterfaceElement != null) {
                this.parseInterface(apiClassifierElement);
                continue;
            }
            this.parseClass(apiClassifierElement);
        }
    }

    private void parseClass(Element apiClassifierElement) throws Exception {
        String fullyQualifiedName = apiClassifierElement.attributeValue("id");
        if (fullyQualifiedName.startsWith("globalClassifier:")) {
            fullyQualifiedName = fullyQualifiedName.substring(17);
        }
        if (fullyQualifiedName.equals("Vector")) {
            fullyQualifiedName = "__AS3__.vec:Vector";
            StringBuilder vectorBuilder = new StringBuilder();
            vectorBuilder.append("// generated from: ");
            vectorBuilder.append(this.currentFile.getName());
            vectorBuilder.append("\n");
            vectorBuilder.append("package __AS3__.vec {\n");
            vectorBuilder.append("\tpublic final dynamic class Vector {\n");
            vectorBuilder.append("\tpublic native function Vector();\n");
            vectorBuilder.append("\t}\n");
            vectorBuilder.append("}\n");
            this.writeFileForDefinition("__AS3__.vec.Vector", false, vectorBuilder.toString());
            for (String suffix : VECTOR_SUFFIXES) {
                this.parseClassWithFullyQualifiedName(apiClassifierElement, fullyQualifiedName + suffix);
            }
            return;
        }
        this.parseClassWithFullyQualifiedName(apiClassifierElement, fullyQualifiedName);
    }

    private void parseClassWithFullyQualifiedName(Element apiClassifierElement, String fullyQualifiedName) throws Exception {
        Element apiDynamicElement;
        Element apiFinalElement;
        boolean isAIROnly;
        String[] parts = fullyQualifiedName.split(":");
        String packageName = "";
        String className = fullyQualifiedName;
        if (parts.length > 1) {
            packageName = parts[0];
            className = parts[1];
            fullyQualifiedName = packageName + "." + className;
        }
        if ((isAIROnly = this.isAIROnly(apiClassifierElement.element("prolog"))) && !this.configuration.getAir() && !fullyQualifiedName.equals("flash.display.NativeMenu") && !fullyQualifiedName.equals("flash.display.NativeMenuItem")) {
            return;
        }
        boolean isVector = fullyQualifiedName.startsWith("__AS3__.vec.Vector$");
        HashSet<String> importFullyQualifiedNames = new HashSet<String>();
        this.collectImports(apiClassifierElement, packageName, importFullyQualifiedNames);
        String baseClassFullyQualifiedName = "";
        ArrayList<String> interfaceFullyQualifiedNames = new ArrayList<String>();
        String access = null;
        boolean isFinal = false;
        boolean isDynamic = false;
        Element apiClassifierDetailElement = apiClassifierElement.element("apiClassifierDetail");
        if (apiClassifierDetailElement == null) {
            throw new Exception("apiClassifierDetail not found for: " + className);
        }
        Element apiClassifierDefElement = apiClassifierDetailElement.element("apiClassifierDef");
        if (apiClassifierDefElement == null) {
            throw new Exception("apiClassifierDef not found for: " + className);
        }
        Element apiBaseClassifierElement = apiClassifierDefElement.element("apiBaseClassifier");
        if (apiBaseClassifierElement != null) {
            baseClassFullyQualifiedName = apiBaseClassifierElement.getTextTrim();
            baseClassFullyQualifiedName = baseClassFullyQualifiedName.replace(":", ".");
        }
        List apiBaseInterfaceElements = apiClassifierDefElement.elements("apiBaseInterface");
        for (Element apiBaseInterfaceElement : apiBaseInterfaceElements) {
            String interfaceFullyQualifiedName = apiBaseInterfaceElement.getTextTrim();
            interfaceFullyQualifiedName = interfaceFullyQualifiedName.replace(":", ".");
            interfaceFullyQualifiedNames.add(interfaceFullyQualifiedName);
        }
        Element apiAccessElement = apiClassifierDefElement.element("apiAccess");
        if (apiAccessElement != null) {
            access = apiAccessElement.attributeValue("value");
        }
        if (isVector) {
            access = "internal";
        }
        if ((apiFinalElement = apiClassifierDefElement.element("apiFinal")) != null) {
            isFinal = true;
        }
        if ((apiDynamicElement = apiClassifierDefElement.element("apiDynamic")) != null) {
            isDynamic = true;
        }
        List apiConstructorElements = apiClassifierElement.elements("apiConstructor");
        List apiOperationElements = apiClassifierElement.elements("apiOperation");
        List apiValueElements = apiClassifierElement.elements("apiValue");
        List adobeApiEventElements = apiClassifierElement.elements("adobeApiEvent");
        StringBuilder classBuilder = new StringBuilder();
        classBuilder.append("// generated from: ");
        classBuilder.append(this.currentFile.getName());
        classBuilder.append("\n");
        classBuilder.append("package");
        if (packageName.length() > 0) {
            classBuilder.append(" ");
            classBuilder.append(packageName);
        }
        classBuilder.append(" ");
        classBuilder.append("{");
        classBuilder.append("\n");
        this.writeImports(importFullyQualifiedNames, classBuilder);
        for (Element adobeApiEventElement : adobeApiEventElements) {
            this.parseEvent(adobeApiEventElement, classBuilder);
        }
        classBuilder.append("\t");
        if (access != null && access.length() > 0) {
            classBuilder.append(access);
            classBuilder.append(" ");
        }
        if (isFinal) {
            classBuilder.append("final ");
        }
        if (isDynamic) {
            classBuilder.append("dynamic ");
        }
        classBuilder.append("class ");
        classBuilder.append(className);
        if (baseClassFullyQualifiedName != null && baseClassFullyQualifiedName.length() > 0 && !"Object".equals(baseClassFullyQualifiedName)) {
            classBuilder.append(" extends ");
            classBuilder.append(baseClassFullyQualifiedName);
        }
        for (int i = 0; i < interfaceFullyQualifiedNames.size(); ++i) {
            String interfaceFullyQualifiedName = (String)interfaceFullyQualifiedNames.get(i);
            if (i == 0) {
                classBuilder.append(" implements ");
            } else {
                classBuilder.append(", ");
            }
            classBuilder.append(interfaceFullyQualifiedName);
        }
        classBuilder.append(" ");
        classBuilder.append("{");
        classBuilder.append("\n");
        if (apiConstructorElements.size() > 0) {
            this.parseConstructor(apiConstructorElements, fullyQualifiedName, classBuilder);
        }
        for (Element apiOperationElement : apiOperationElements) {
            this.parseFunction(apiOperationElement, fullyQualifiedName, false, classBuilder);
        }
        for (Element apiValueElement : apiValueElements) {
            this.parseVariable(apiValueElement, fullyQualifiedName, false, classBuilder);
        }
        if (EXTRA_MEMBERS.containsKey(fullyQualifiedName)) {
            for (String member : EXTRA_MEMBERS.get(fullyQualifiedName)) {
                classBuilder.append("\t");
                classBuilder.append(member);
                classBuilder.append(";");
                classBuilder.append("\n");
            }
        }
        classBuilder.append("\t");
        classBuilder.append("}");
        classBuilder.append("\n");
        classBuilder.append("}");
        classBuilder.append("\n");
        this.writeFileForDefinition(fullyQualifiedName, isAIROnly, classBuilder.toString());
    }

    private void parseInterface(Element apiClassifierElement) throws Exception {
        boolean isAIROnly;
        String fullyQualifiedName = apiClassifierElement.attributeValue("id");
        if (fullyQualifiedName.startsWith("globalClassifier:")) {
            fullyQualifiedName = fullyQualifiedName.substring(17);
        }
        String[] parts = fullyQualifiedName.split(":");
        String packageName = "";
        String interfaceName = fullyQualifiedName;
        if (parts.length > 1) {
            packageName = parts[0];
            interfaceName = parts[1];
            fullyQualifiedName = packageName + "." + interfaceName;
        }
        if ((isAIROnly = this.isAIROnly(apiClassifierElement.element("prolog"))) && !this.configuration.getAir()) {
            return;
        }
        HashSet<String> importFullyQualifiedNames = new HashSet<String>();
        this.collectImports(apiClassifierElement, packageName, importFullyQualifiedNames);
        ArrayList<String> interfaceFullyQualifiedNames = new ArrayList<String>();
        String access = null;
        Element apiClassifierDetailElement = apiClassifierElement.element("apiClassifierDetail");
        if (apiClassifierDetailElement == null) {
            throw new Exception("apiClassifierDetail not found for: " + interfaceName);
        }
        Element apiClassifierDefElement = apiClassifierDetailElement.element("apiClassifierDef");
        if (apiClassifierDefElement == null) {
            throw new Exception("apiClassifierDef not found for: " + interfaceName);
        }
        List apiBaseInterfaceElements = apiClassifierDefElement.elements("apiBaseInterface");
        for (Element apiBaseInterfaceElement : apiBaseInterfaceElements) {
            String baseInterfaceFullyQualifiedName = apiBaseInterfaceElement.getTextTrim();
            baseInterfaceFullyQualifiedName = baseInterfaceFullyQualifiedName.replace(":", ".");
            interfaceFullyQualifiedNames.add(baseInterfaceFullyQualifiedName);
        }
        Element apiAccessElement = apiClassifierDefElement.element("apiAccess");
        if (apiAccessElement != null) {
            access = apiAccessElement.attributeValue("value");
        }
        List apiOperationElements = apiClassifierElement.elements("apiOperation");
        List apiValueElements = apiClassifierElement.elements("apiValue");
        StringBuilder interfaceBuilder = new StringBuilder();
        interfaceBuilder.append("// generated from: ");
        interfaceBuilder.append(this.currentFile.getName());
        interfaceBuilder.append("\n");
        interfaceBuilder.append("package");
        if (packageName.length() > 0) {
            interfaceBuilder.append(" ");
            interfaceBuilder.append(packageName);
        }
        interfaceBuilder.append(" ");
        interfaceBuilder.append("{");
        interfaceBuilder.append("\n");
        this.writeImports(importFullyQualifiedNames, interfaceBuilder);
        interfaceBuilder.append("\t");
        if (access != null && access.length() > 0) {
            interfaceBuilder.append(access);
            interfaceBuilder.append(" ");
        }
        interfaceBuilder.append("interface ");
        interfaceBuilder.append(interfaceName);
        for (int i = 0; i < interfaceFullyQualifiedNames.size(); ++i) {
            String interfaceFullyQualifiedName = (String)interfaceFullyQualifiedNames.get(i);
            if (i == 0) {
                interfaceBuilder.append(" extends ");
            } else {
                interfaceBuilder.append(", ");
            }
            interfaceBuilder.append(interfaceFullyQualifiedName);
        }
        interfaceBuilder.append(" ");
        interfaceBuilder.append("{");
        interfaceBuilder.append("\n");
        for (Element apiOperationElement : apiOperationElements) {
            this.parseFunction(apiOperationElement, null, true, interfaceBuilder);
        }
        for (Element apiValueElement : apiValueElements) {
            this.parseVariable(apiValueElement, fullyQualifiedName, true, interfaceBuilder);
        }
        interfaceBuilder.append("\t");
        interfaceBuilder.append("}");
        interfaceBuilder.append("\n");
        interfaceBuilder.append("}");
        interfaceBuilder.append("\n");
        this.writeFileForDefinition(fullyQualifiedName, isAIROnly, interfaceBuilder.toString());
    }

    private void parsePackageFunction(Element apiOperationElement) throws Exception {
        boolean isAIROnly;
        String fullyQualifiedName = apiOperationElement.attributeValue("id");
        if (fullyQualifiedName.startsWith("globalOperation:")) {
            fullyQualifiedName = fullyQualifiedName.substring(16);
        }
        if (fullyQualifiedName.equals("Vector")) {
            return;
        }
        String[] parts = fullyQualifiedName.split(":");
        String packageName = "";
        if (parts.length > 1) {
            packageName = parts[0];
            fullyQualifiedName = packageName + "." + parts[1];
        }
        if ((isAIROnly = this.isAIROnly(apiOperationElement.element("prolog"))) && !this.configuration.getAir()) {
            return;
        }
        HashSet<String> importFullyQualifiedNames = new HashSet<String>();
        this.collectImports(apiOperationElement, packageName, importFullyQualifiedNames);
        StringBuilder functionBuilder = new StringBuilder();
        functionBuilder.append("// generated from: ");
        functionBuilder.append(this.currentFile.getName());
        functionBuilder.append("\n");
        functionBuilder.append("package");
        if (packageName != null && packageName.length() > 0) {
            functionBuilder.append(" ");
            functionBuilder.append(packageName);
        }
        functionBuilder.append(" ");
        functionBuilder.append("{");
        functionBuilder.append("\n");
        this.writeImports(importFullyQualifiedNames, functionBuilder);
        this.parseFunction(apiOperationElement, null, false, functionBuilder);
        functionBuilder.append("}");
        functionBuilder.append("\n");
        this.writeFileForDefinition(fullyQualifiedName, isAIROnly, functionBuilder.toString());
    }

    private void parsePackageVariable(Element apiValueElement) throws Exception {
        String fullyQualifiedName = apiValueElement.attributeValue("id");
        if (fullyQualifiedName.startsWith("globalValue:")) {
            fullyQualifiedName = fullyQualifiedName.substring(12);
        }
        String[] parts = fullyQualifiedName.split(":");
        String packageName = "";
        String variableName = fullyQualifiedName;
        if (parts.length > 1) {
            packageName = parts[0];
            variableName = parts[1];
            fullyQualifiedName = packageName + "." + variableName;
        }
        if (variableName.startsWith("-")) {
            return;
        }
        boolean isAIROnly = this.isAIROnly(apiValueElement.element("prolog"));
        if (isAIROnly && !this.configuration.getAir()) {
            return;
        }
        HashSet<String> importFullyQualifiedNames = new HashSet<String>();
        this.collectImports(apiValueElement, packageName, importFullyQualifiedNames);
        StringBuilder variableBuilder = new StringBuilder();
        variableBuilder.append("// generated from: ");
        variableBuilder.append(this.currentFile.getName());
        variableBuilder.append("\n");
        variableBuilder.append("package");
        if (packageName != null && packageName.length() > 0) {
            variableBuilder.append(" ");
            variableBuilder.append(packageName);
        }
        variableBuilder.append(" ");
        variableBuilder.append("{");
        variableBuilder.append("\n");
        this.writeImports(importFullyQualifiedNames, variableBuilder);
        this.parseVariable(apiValueElement, null, false, variableBuilder);
        variableBuilder.append("}");
        variableBuilder.append("\n");
        this.writeFileForDefinition(fullyQualifiedName, isAIROnly, variableBuilder.toString());
    }

    private void parseVariable(Element apiValueElement, String contextClassName, boolean forInterface, StringBuilder variableBuilder) throws Exception {
        Element apiIsOverrideElement;
        Element apiValueAccessElement;
        Element apiDynamicElement;
        boolean isAIROnly = this.isAIROnly(apiValueElement.element("prolog"));
        if (isAIROnly && !this.configuration.getAir()) {
            return;
        }
        String variableName = apiValueElement.element("apiName").getTextTrim();
        boolean isGetter = false;
        boolean isSetter = false;
        boolean isConst = !this.isVariableThatShouldBeWritable(contextClassName, variableName);
        boolean isStatic = false;
        boolean isOverride = false;
        String variableType = "*";
        boolean forceAnyType = this.isVariableTypedAsAny(contextClassName, variableName);
        String access = null;
        Element apiValueDetailElement = apiValueElement.element("apiValueDetail");
        if (apiValueDetailElement == null) {
            throw new Exception("apiValueDetail not found for: " + variableName);
        }
        Element apiValueDefElement = apiValueDetailElement.element("apiValueDef");
        if (apiValueDefElement == null) {
            throw new Exception("apiValueDef not found for: " + variableName);
        }
        Element apiValueClassifierElement = apiValueDefElement.element("apiValueClassifier");
        if (apiValueClassifierElement != null) {
            variableType = apiValueClassifierElement.getTextTrim();
            variableType = variableType.replace(":", ".");
        }
        Element apiAccessElement = apiValueDefElement.element("apiAccess");
        if (!forInterface && apiAccessElement != null) {
            access = apiAccessElement.attributeValue("value");
        }
        Element apiStaticElement = apiValueDefElement.element("apiStatic");
        if (!forInterface && apiStaticElement != null) {
            isStatic = true;
        }
        if ((apiDynamicElement = apiValueDefElement.element("apiDynamic")) != null) {
            isConst = false;
        }
        if ((apiValueAccessElement = apiValueDefElement.element("apiValueAccess")) != null) {
            String readwrite = apiValueAccessElement.attributeValue("value");
            isGetter = "readwrite".equals(readwrite) || "read".equals(readwrite);
            boolean bl = isSetter = "readwrite".equals(readwrite) || "write".equals(readwrite);
        }
        if ((apiIsOverrideElement = apiValueDefElement.element("apiIsOverride")) != null) {
            isOverride = true;
        }
        if (!forInterface && isGetter && isSetter && !isOverride && apiValueElement.attributeValue("id").endsWith(":set")) {
            isGetter = false;
        }
        Element apiDataElement = apiValueDefElement.element("apiData");
        if (isGetter) {
            variableBuilder.append("\t");
            if (access != null && access.length() > 0) {
                variableBuilder.append(access);
                variableBuilder.append(" ");
            }
            if (isStatic) {
                variableBuilder.append("static ");
            }
            if (!forInterface) {
                variableBuilder.append("native ");
            }
            if (isOverride) {
                variableBuilder.append("override ");
            }
            variableBuilder.append("function ");
            variableBuilder.append("get ");
            variableBuilder.append(variableName);
            variableBuilder.append("(");
            variableBuilder.append(")");
            variableBuilder.append(":");
            if (forceAnyType) {
                variableBuilder.append("*");
            } else {
                variableBuilder.append(variableType);
            }
            variableBuilder.append(";");
            variableBuilder.append("\n");
        }
        if (isSetter) {
            variableBuilder.append("\t");
            if (access != null && access.length() > 0) {
                variableBuilder.append(access);
                variableBuilder.append(" ");
            }
            if (isStatic) {
                variableBuilder.append("static ");
            }
            if (!forInterface) {
                variableBuilder.append("native ");
            }
            if (isOverride) {
                variableBuilder.append("override ");
            }
            variableBuilder.append("function ");
            variableBuilder.append("set ");
            variableBuilder.append(variableName);
            variableBuilder.append("(");
            variableBuilder.append("value");
            variableBuilder.append(":");
            if (forceAnyType) {
                variableBuilder.append("*");
            } else {
                variableBuilder.append(variableType);
            }
            variableBuilder.append(")");
            variableBuilder.append(":");
            variableBuilder.append("void");
            variableBuilder.append(";");
            variableBuilder.append("\n");
        }
        if (!isGetter && !isSetter) {
            variableBuilder.append("\t");
            if (access != null && access.length() > 0) {
                variableBuilder.append(access);
                variableBuilder.append(" ");
            }
            if (isStatic) {
                variableBuilder.append("static ");
            }
            if (isConst || contextClassName == null && GLOBAL_CONSTANTS.containsKey(variableName)) {
                variableBuilder.append("const ");
            } else {
                variableBuilder.append("var ");
            }
            variableBuilder.append(variableName);
            variableBuilder.append(":");
            if (forceAnyType) {
                variableBuilder.append("*");
            } else {
                variableBuilder.append(variableType);
            }
            if (contextClassName == null && GLOBAL_CONSTANTS.containsKey(variableName)) {
                variableBuilder.append(" = ");
                variableBuilder.append(GLOBAL_CONSTANTS.get(variableName));
            } else if (apiDataElement != null) {
                this.writeVariableOrParameterValue(apiDataElement, variableType, variableBuilder);
            }
            variableBuilder.append(";");
            variableBuilder.append("\n");
        }
    }

    private void parseFunction(Element apiOperationElement, String contextClassName, boolean forInterface, StringBuilder functionBuilder) throws Exception {
        Element apiReturnElement;
        boolean isAIROnly = this.isAIROnly(apiOperationElement.element("prolog"));
        if (isAIROnly && !this.configuration.getAir()) {
            return;
        }
        String functionName = apiOperationElement.element("apiName").getTextTrim();
        boolean isStatic = false;
        boolean isOverride = false;
        String returnType = "*";
        String access = null;
        Element apiOperationDetailElement = apiOperationElement.element("apiOperationDetail");
        if (apiOperationDetailElement == null) {
            throw new Exception("apiOperationDetail not found for: " + functionName);
        }
        Element apiOperationDefElement = apiOperationDetailElement.element("apiOperationDef");
        if (apiOperationDefElement == null) {
            throw new Exception("apiOperationDef not found for: " + functionName);
        }
        Element apiIsOverrideElement = apiOperationDefElement.element("apiIsOverride");
        if (apiIsOverrideElement != null) {
            isOverride = true;
            if (!this.configuration.getAir() && "clone".equals(functionName) && "flash.ui.ContextMenuItem".equals(contextClassName)) {
                isOverride = false;
            }
        }
        if ((apiReturnElement = apiOperationDefElement.element("apiReturn")) != null) {
            Element apiOperationClassifierElement;
            Element apiTypeElement = apiReturnElement.element("apiType");
            if (apiTypeElement != null) {
                returnType = this.parseReturnOrParamType(apiTypeElement, contextClassName);
            }
            if ((apiOperationClassifierElement = apiReturnElement.element("apiOperationClassifier")) != null) {
                returnType = apiOperationClassifierElement.getTextTrim();
                returnType = returnType.replace(":", ".");
            }
        }
        Element apiAccessElement = apiOperationDefElement.element("apiAccess");
        if (!forInterface && apiAccessElement != null) {
            access = apiAccessElement.attributeValue("value");
        }
        Element apiStaticElement = apiOperationDefElement.element("apiStatic");
        if (!forInterface && apiStaticElement != null) {
            isStatic = true;
        }
        List apiParamElements = apiOperationDefElement.elements("apiParam");
        if (OBJECT_AS3_METHODS.contains(functionName)) {
            if ("Object".equals(contextClassName)) {
                access = "AS3";
            } else {
                return;
            }
        }
        if ("Object".equals(contextClassName) && OBJECT_PROTOTYPE_METHODS.contains(functionName)) {
            return;
        }
        if ("toString".equals(functionName) && isOverride) {
            return;
        }
        functionBuilder.append("\t");
        if (access != null && access.length() > 0) {
            functionBuilder.append(access);
            functionBuilder.append(" ");
        }
        if (isStatic) {
            functionBuilder.append("static ");
        }
        if (!forInterface) {
            functionBuilder.append("native ");
        }
        if (isOverride) {
            functionBuilder.append("override ");
        }
        functionBuilder.append("function ");
        functionBuilder.append(functionName);
        functionBuilder.append("(");
        this.parseParameters(apiParamElements, contextClassName, functionName, functionBuilder);
        functionBuilder.append(")");
        functionBuilder.append(":");
        functionBuilder.append(returnType);
        functionBuilder.append(";");
        functionBuilder.append("\n");
    }

    private void parseConstructor(List<Element> apiConstructorElements, String contextClassName, StringBuilder functionBuilder) throws Exception {
        String constructorName = null;
        String access = null;
        List<Element> apiParamElements = null;
        for (Element apiConstructorElement : apiConstructorElements) {
            Element apiConstructorDetailElement;
            if (constructorName == null) {
                constructorName = apiConstructorElement.element("apiName").getTextTrim();
            }
            if ((apiConstructorDetailElement = apiConstructorElement.element("apiConstructorDetail")) == null) {
                throw new Exception("apiConstructorDetail not found for: " + constructorName);
            }
            Element apiConstructorDefElement = apiConstructorDetailElement.element("apiConstructorDef");
            if (apiConstructorDefElement == null) {
                throw new Exception("apiConstructorDef not found for: " + constructorName);
            }
            Element apiAccessElement = apiConstructorDefElement.element("apiAccess");
            if (apiAccessElement != null) {
                access = apiAccessElement.attributeValue("value");
            }
            List newApiParamElements = apiConstructorDefElement.elements("apiParam");
            apiParamElements = this.mergeParameters(apiParamElements, newApiParamElements);
        }
        functionBuilder.append("\t");
        if (access != null && access.length() > 0) {
            functionBuilder.append(access);
            functionBuilder.append(" ");
        }
        functionBuilder.append("native ");
        functionBuilder.append("function ");
        functionBuilder.append(constructorName);
        functionBuilder.append("(");
        this.parseParameters(apiParamElements, contextClassName, constructorName, functionBuilder);
        functionBuilder.append(")");
        functionBuilder.append(";");
        functionBuilder.append("\n");
    }

    private List<Element> mergeParameters(List<Element> apiParamElements1, List<Element> apiParamElements2) throws Exception {
        if (apiParamElements1 == null) {
            return apiParamElements2;
        }
        if (apiParamElements2 == null) {
            return apiParamElements1;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        int count = Math.max(apiParamElements1.size(), apiParamElements2.size());
        for (int i = 0; i < count; ++i) {
            String apiTypeValue2;
            Element apiTypeElement2;
            String apiTypeValue1;
            Element apiTypeElement1;
            boolean isRest;
            Element apiParamElement2;
            Element apiParamElement1 = apiParamElements1.size() > i ? apiParamElements1.get(i) : null;
            Element element = apiParamElement2 = apiParamElements2.size() > i ? apiParamElements2.get(i) : null;
            if (apiParamElement1 == null) {
                Element apiDataElement2 = apiParamElement2.element("apiData");
                if (apiDataElement2 == null) {
                    apiDataElement2 = DocumentHelper.createElement((String)"apiData");
                    apiDataElement2.setText("null");
                    apiParamElement2.add(apiDataElement2);
                }
                isRest = false;
                Element apiTypeElement22 = apiParamElement2.element("apiType");
                if (apiTypeElement22 != null) {
                    String apiTypeValue22 = apiTypeElement22.attributeValue("value");
                    if ("restParam".equals(apiTypeValue22)) {
                        isRest = true;
                    }
                    apiParamElement2.remove(apiTypeElement22);
                }
                apiTypeElement22 = DocumentHelper.createElement((String)"apiType");
                if (isRest) {
                    apiTypeElement22.addAttribute("value", "restParam");
                } else {
                    apiTypeElement22.addAttribute("value", "any");
                }
                apiParamElement2.add(apiTypeElement22);
                Element apiOperationClassifierElement2 = apiParamElement2.element("apiOperationClassifier");
                if (apiOperationClassifierElement2 != null) {
                    apiParamElement2.remove(apiOperationClassifierElement2);
                }
                result.add(apiParamElement2);
                if (!isRest) continue;
                break;
            }
            if (apiParamElement2 == null) {
                Element apiDataElement1 = apiParamElement1.element("apiData");
                if (apiDataElement1 == null) {
                    apiDataElement1 = DocumentHelper.createElement((String)"apiData");
                    apiDataElement1.setText("null");
                    apiParamElement1.add(apiDataElement1);
                }
                isRest = false;
                apiTypeElement1 = apiParamElement1.element("apiType");
                if (apiTypeElement1 != null) {
                    apiTypeValue1 = apiTypeElement1.attributeValue("value");
                    if ("restParam".equals(apiTypeValue1)) {
                        isRest = true;
                    }
                    apiParamElement1.remove(apiTypeElement1);
                }
                apiTypeElement1 = DocumentHelper.createElement((String)"apiType");
                if (isRest) {
                    apiTypeElement1.addAttribute("value", "restParam");
                } else {
                    apiTypeElement1.addAttribute("value", "any");
                }
                apiParamElement1.add(apiTypeElement1);
                Element apiOperationClassifierElement1 = apiParamElement1.element("apiOperationClassifier");
                if (apiOperationClassifierElement1 != null) {
                    apiParamElement1.remove(apiOperationClassifierElement1);
                }
                result.add(apiParamElement1);
                if (!isRest) continue;
                break;
            }
            String paramName = "param" + i;
            isRest = false;
            apiTypeElement1 = apiParamElement1.element("apiType");
            if (apiTypeElement1 != null && "restParam".equals(apiTypeValue1 = apiTypeElement1.attributeValue("value"))) {
                isRest = true;
                Element apiItemNameElement1 = apiParamElement1.element("apiItemName");
                if (apiItemNameElement1 != null) {
                    paramName = apiItemNameElement1.getTextTrim();
                }
            }
            if ((apiTypeElement2 = apiParamElement2.element("apiType")) != null && "restParam".equals(apiTypeValue2 = apiTypeElement2.attributeValue("value"))) {
                isRest = true;
                Element apiItemNameElement2 = apiParamElement2.element("apiItemName");
                if (apiItemNameElement2 != null) {
                    paramName = apiItemNameElement2.getTextTrim();
                }
            }
            Element newApiParamElement = DocumentHelper.createElement((String)"apiParam");
            Element apiItemNameElement = DocumentHelper.createElement((String)"apiItemName");
            apiItemNameElement.setText(paramName);
            newApiParamElement.add(apiItemNameElement);
            Element newApiTypeElement = DocumentHelper.createElement((String)"apiType");
            if (isRest) {
                newApiTypeElement.addAttribute("value", "restParam");
            } else {
                newApiTypeElement.addAttribute("value", "any");
            }
            newApiParamElement.add(newApiTypeElement);
            if (!isRest) {
                Element newApiDataElement = DocumentHelper.createElement((String)"apiData");
                newApiDataElement.setText("null");
                newApiParamElement.add(newApiDataElement);
            }
            result.add(newApiParamElement);
            if (isRest) break;
        }
        return result;
    }

    private String parseReturnOrParamType(Element apiTypeElement, String contextClassName) throws Exception {
        String apiTypeValue = apiTypeElement.attributeValue("value");
        if ("restParam".equals(apiTypeValue)) {
            return null;
        }
        if ("any".equals(apiTypeValue)) {
            return "*";
        }
        if ("T".equals(apiTypeValue)) {
            return "T";
        }
        if ("void".equals(apiTypeValue)) {
            return "void";
        }
        if (apiTypeValue.startsWith("Vector$")) {
            String[] parts = apiTypeValue.split("\\$");
            String vectorItemType = parts[1];
            vectorItemType = vectorItemType.replace(":", ".");
            if (contextClassName != null && contextClassName.startsWith("__AS3__.vec.Vector$") && vectorItemType.equals("T")) {
                return contextClassName;
            }
            return "Vector.<" + vectorItemType + ">";
        }
        throw new Exception("Unknown apiType value: " + apiTypeValue);
    }

    private void parseEvent(Element adobeApiEventElement, StringBuilder eventBuilder) throws Exception {
        Element adobeApiEventClassifierElement;
        Element adobeApiEventDefElement;
        String eventName = null;
        Element apiNameElement = adobeApiEventElement.element("apiName");
        if (apiNameElement != null) {
            eventName = apiNameElement.getTextTrim();
        }
        String eventType = null;
        Element adobeApiEventDetailElement = adobeApiEventElement.element("adobeApiEventDetail");
        if (adobeApiEventDetailElement != null && (adobeApiEventDefElement = adobeApiEventDetailElement.element("adobeApiEventDef")) != null && (adobeApiEventClassifierElement = adobeApiEventDefElement.element("adobeApiEventClassifier")) != null) {
            eventType = adobeApiEventClassifierElement.getTextTrim();
        }
        eventBuilder.append("\t");
        eventBuilder.append("[Event(");
        if (eventName != null) {
            eventBuilder.append("name=\"");
            eventBuilder.append(eventName);
            eventBuilder.append("\"");
        }
        if (eventType != null) {
            eventBuilder.append(", type=\"");
            eventBuilder.append(eventType);
            eventBuilder.append("\"");
        }
        eventBuilder.append(")]");
        eventBuilder.append("\n");
    }

    private boolean isConstructorThatNeedsParamsTypedAsAny(String contextClassName, String contextFunctionName) {
        if (!contextFunctionName.equals(contextClassName)) {
            return false;
        }
        return ANY_CONSTRUCTORS.contains(contextFunctionName);
    }

    private boolean isMethodThatNeedsParamsTypedAsAny(String contextClassName, String contextFunctionName) {
        if (!ANY_METHODS.containsKey(contextClassName)) {
            return false;
        }
        return ANY_METHODS.get(contextClassName).contains(contextFunctionName);
    }

    private boolean isMethodThatNeedsParamsWithDefaultNull(String contextClassName, String contextFunctionName) {
        if (!NULL_DEFAULT_METHODS.containsKey(contextClassName)) {
            return false;
        }
        return NULL_DEFAULT_METHODS.get(contextClassName).contains(contextFunctionName);
    }

    private boolean isMethodThatNeedsRestParamOnly(String contextClassName, String contextFunctionName) {
        if (!REST_METHODS.containsKey(contextClassName)) {
            return false;
        }
        return REST_METHODS.get(contextClassName).contains(contextFunctionName);
    }

    private boolean isVariableTypedAsAny(String contextClassName, String contextVariableName) {
        if (!ANY_VARIABLES.containsKey(contextClassName)) {
            return false;
        }
        return ANY_VARIABLES.get(contextClassName).contains(contextVariableName);
    }

    private boolean isVariableThatShouldBeWritable(String contextClassName, String contextVariableName) {
        if (!WRITABLE_VARIABLES.containsKey(contextClassName)) {
            return false;
        }
        return WRITABLE_VARIABLES.get(contextClassName).contains(contextVariableName);
    }

    private void parseParameters(List<Element> apiParamElements, String contextClassName, String contextFunctionName, StringBuilder functionBuilder) throws Exception {
        boolean forceOptionalConstructor = this.isConstructorThatNeedsParamsTypedAsAny(contextClassName, contextFunctionName);
        boolean forceRest = this.isMethodThatNeedsRestParamOnly(contextClassName, contextFunctionName);
        boolean forceAnyType = this.isMethodThatNeedsParamsTypedAsAny(contextClassName, contextFunctionName);
        boolean forceNullDefault = this.isMethodThatNeedsParamsWithDefaultNull(contextClassName, contextFunctionName);
        for (int i = 0; i < apiParamElements.size(); ++i) {
            Element apiItemNameElement;
            if (i > 0) {
                functionBuilder.append(", ");
            }
            Element apiParamElement = apiParamElements.get(i);
            Element apiTypeElement = apiParamElement.element("apiType");
            String paramType = null;
            if (forceRest) {
                functionBuilder.append("...args");
                break;
            }
            if (apiTypeElement != null) {
                String apiTypeValue = apiTypeElement.attributeValue("value");
                if ("restParam".equals(apiTypeValue)) {
                    functionBuilder.append("...");
                }
                paramType = this.parseReturnOrParamType(apiTypeElement, contextClassName);
            }
            if ((apiItemNameElement = apiParamElement.element("apiItemName")) == null) {
                throw new Exception("apiItemName not found");
            }
            functionBuilder.append(apiItemNameElement.getTextTrim());
            if (forceOptionalConstructor) {
                functionBuilder.append(":* = null");
                continue;
            }
            Element apiOperationClassifierElement = apiParamElement.element("apiOperationClassifier");
            if (apiOperationClassifierElement != null) {
                paramType = apiOperationClassifierElement.getTextTrim();
                paramType = paramType.replace(":", ".");
            }
            if (forceAnyType) {
                paramType = "*";
            }
            if (paramType != null) {
                functionBuilder.append(":");
                functionBuilder.append(paramType);
            }
            Element apiDataElement = apiParamElement.element("apiData");
            if (forceNullDefault) {
                functionBuilder.append(" = null");
                continue;
            }
            if (apiDataElement != null) {
                this.writeVariableOrParameterValue(apiDataElement, paramType, functionBuilder);
                continue;
            }
            if (!"int".equals(contextClassName) && !"uint".equals(contextClassName) || !"toString".equals(contextFunctionName)) continue;
            functionBuilder.append(" = 10");
        }
    }

    private void writeVariableOrParameterValue(Element apiDataElement, String varType, StringBuilder builder) {
        boolean isString;
        builder.append(" = ");
        String paramValue = apiDataElement.getTextTrim();
        if ("unknown".equals(paramValue)) {
            paramValue = "null";
        }
        boolean bl = isString = ("String".equals(varType) || paramValue.matches("[A-Za-z\\*]+")) && !"undefined".equals(paramValue) && !"null".equals(paramValue) && !"NaN".equals(paramValue) && !"true".equals(paramValue) && !"false".equals(paramValue);
        if (isString) {
            builder.append("\"");
        }
        builder.append(paramValue);
        if (isString) {
            builder.append("\"");
        }
    }

    private void collectImport(String fullyQualifiedName, String forPackage, Set<String> result) throws Exception {
        String[] parts = fullyQualifiedName.split(":");
        if (parts.length == 1) {
            return;
        }
        String packageName = parts[0];
        if (packageName.equals(forPackage)) {
            return;
        }
        result.add(packageName + "." + parts[1]);
    }

    private void collectImports(Element element, String forPackage, Set<String> result) throws Exception {
        String elementName = element.getName();
        if ("apiClassifier".equals(elementName)) {
            String className = element.element("apiName").getTextTrim();
            Element apiClassifierDetailElement = element.element("apiClassifierDetail");
            if (apiClassifierDetailElement == null) {
                throw new Exception("apiClassifierDetail not found for: " + className);
            }
            Element apiClassifierDefElement = apiClassifierDetailElement.element("apiClassifierDef");
            if (apiClassifierDefElement == null) {
                throw new Exception("apiClassifierDef not found for: " + className);
            }
            Element apiBaseClassifierElement = apiClassifierDefElement.element("apiBaseClassifier");
            if (apiBaseClassifierElement != null) {
                String baseClassType = apiBaseClassifierElement.getTextTrim();
                this.collectImport(baseClassType, forPackage, result);
            }
            List apiBaseInterfaceElements = apiClassifierDefElement.elements("apiBaseInterface");
            for (Element apiBaseInterfaceElement : apiBaseInterfaceElements) {
                String interfaceType = apiBaseInterfaceElement.getTextTrim();
                this.collectImport(interfaceType, forPackage, result);
            }
            Element apiConstructorElement = element.element("apiConstructor");
            if (apiConstructorElement != null) {
                this.collectImports(apiConstructorElement, forPackage, result);
            }
            List apiOperationElements = element.elements("apiOperation");
            for (Object apiOperationElement : apiOperationElements) {
                this.collectImports((Element)apiOperationElement, forPackage, result);
            }
            List apiValueElements = element.elements("apiValue");
            for (Element apiValueElement : apiValueElements) {
                this.collectImports(apiValueElement, forPackage, result);
            }
        }
        if ("apiOperation".equals(elementName)) {
            boolean isAIROnly = this.isAIROnly(element.element("prolog"));
            if (isAIROnly && !this.configuration.getAir()) {
                return;
            }
            String functionName = element.element("apiName").getTextTrim();
            Element apiOperationDetailElement = element.element("apiOperationDetail");
            if (apiOperationDetailElement == null) {
                throw new Exception("apiOperationDetail not found for: " + functionName);
            }
            Element apiOperationDefElement = apiOperationDetailElement.element("apiOperationDef");
            if (apiOperationDefElement == null) {
                throw new Exception("apiOperationDef not found for: " + functionName);
            }
            Element apiReturnElement = apiOperationDefElement.element("apiReturn");
            if (apiReturnElement != null) {
                Element apiOperationClassifierElement;
                String apiTypeValue;
                Element apiTypeElement = apiOperationDefElement.element("apiType");
                if (apiTypeElement != null && (apiTypeValue = apiTypeElement.attributeValue("value")).startsWith("Vector$")) {
                    String[] parts = apiTypeValue.split("\\$");
                    String vectorItemType = parts[1];
                    this.collectImport(vectorItemType, forPackage, result);
                }
                if ((apiOperationClassifierElement = apiReturnElement.element("apiOperationClassifier")) != null) {
                    String returnType = apiOperationClassifierElement.getTextTrim();
                    this.collectImport(returnType, forPackage, result);
                }
            }
            List apiParamElements = apiOperationDefElement.elements("apiParam");
            for (Element apiParamElement : apiParamElements) {
                Element apiOperationClassifierElement;
                String apiTypeValue;
                Element apiTypeElement = apiParamElement.element("apiType");
                if (apiTypeElement != null && (apiTypeValue = apiTypeElement.attributeValue("value")).startsWith("Vector$")) {
                    String[] parts = apiTypeValue.split("\\$");
                    String vectorItemType = parts[1];
                    this.collectImport(vectorItemType, forPackage, result);
                }
                if ((apiOperationClassifierElement = apiParamElement.element("apiOperationClassifier")) == null) continue;
                String paramType = apiOperationClassifierElement.getTextTrim();
                this.collectImport(paramType, forPackage, result);
            }
        }
        if ("apiConstructor".equals(elementName)) {
            String functionName = element.element("apiName").getTextTrim();
            Element aapiConstructorDetailElement = element.element("apiConstructorDetail");
            if (aapiConstructorDetailElement == null) {
                throw new Exception("apiConstructor not found for: " + functionName);
            }
            Element apiConstructorDefElement = aapiConstructorDetailElement.element("apiConstructorDef");
            if (apiConstructorDefElement == null) {
                throw new Exception("apiConstructorDef not found for: " + functionName);
            }
            List apiParamElements = apiConstructorDefElement.elements("apiParam");
            for (Element apiParamElement : apiParamElements) {
                Element apiOperationClassifierElement;
                String apiTypeValue;
                Element apiTypeElement = apiParamElement.element("apiType");
                if (apiTypeElement != null && (apiTypeValue = apiTypeElement.attributeValue("value")).startsWith("Vector$")) {
                    String[] parts = apiTypeValue.split("\\$");
                    String vectorItemType = parts[1];
                    this.collectImport(vectorItemType, forPackage, result);
                }
                if ((apiOperationClassifierElement = apiParamElement.element("apiOperationClassifier")) == null) continue;
                String paramType = apiOperationClassifierElement.getTextTrim();
                this.collectImport(paramType, forPackage, result);
            }
        }
        if ("apiValue".equals(elementName)) {
            boolean isAIROnly = this.isAIROnly(element.element("prolog"));
            if (isAIROnly && !this.configuration.getAir()) {
                return;
            }
            String variableName = element.element("apiName").getTextTrim();
            Element apiValueDetailElement = element.element("apiValueDetail");
            if (apiValueDetailElement == null) {
                throw new Exception("apiValueDetail not found for: " + variableName);
            }
            Element apiValueDefElement = apiValueDetailElement.element("apiValueDef");
            if (apiValueDefElement == null) {
                throw new Exception("apiValueDef not found for: " + variableName);
            }
            Element apiValueClassifierElement = apiValueDefElement.element("apiValueClassifier");
            if (apiValueClassifierElement != null) {
                String variableType = apiValueClassifierElement.getTextTrim();
                this.collectImport(variableType, forPackage, result);
            }
        }
    }

    private void writeImports(Set<String> imports, StringBuilder builder) {
        for (String importName : imports) {
            builder.append("\t");
            builder.append("import ");
            builder.append(importName);
            builder.append(";");
            builder.append("\n");
        }
        if (imports.size() > 0) {
            builder.append("\n");
        }
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

