/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import java.util.Arrays;

public final class FlashUUID {
    private static final int kUUIDSize = 16;
    public final byte[] bytes;

    public FlashUUID(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.bytes = bytes;
    }

    public FlashUUID() {
        this.bytes = new byte[16];
    }

    public String toString() {
        return FlashUUID.stringify(this.bytes);
    }

    private static String stringify(byte[] buf) {
        StringBuilder sb = new StringBuilder(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }

    public int hashCode() {
        int length;
        int code = length = this.bytes.length;
        for (int i = 0; i < length; ++i) {
            code = code << 1 ^ this.bytes[i];
        }
        return code;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof FlashUUID) {
            FlashUUID flashUUID = (FlashUUID)object;
            if (Arrays.equals(flashUUID.bytes, this.bytes)) {
                isEqual = true;
            }
        }
        return isEqual;
    }
}

