// Copyright 2016 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


goog.provide('goog.dom.Attr');


/**
 * Enum of all html attribute names specified by the HTML specifications.
 * @enum {string}
 */
goog.dom.Attr = {
  ACCEPT: 'accept',
  ACCEPT_CHARSET: 'accept-charset',
  ACCESSKEY: 'accesskey',
  ACTION: 'action',
  ALIGN: 'align',
  ALT: 'alt',
  ASYNC: 'async',
  AUTOCOMPLETE: 'autocomplete',
  AUTOFOCUS: 'autofocus',
  AUTOPLAY: 'autoplay',
  AUTOSAVE: 'autosave',
  BGCOLOR: 'bgcolor',
  BORDER: 'border',
  BUFFERED: 'buffered',
  CHALLENGE: 'challenge',
  CHARSET: 'charset',
  CHECKED: 'checked',
  CITE: 'cite',
  CLASS: 'class',
  CODE: 'code',
  CODEBASE: 'codebase',
  COLOR: 'color',
  COLS: 'cols',
  COLSPAN: 'colspan',
  CONTENT: 'content',
  CONTENTEDITABLE: 'contenteditable',
  CONTEXTMENU: 'contextmenu',
  CONTROLS: 'controls',
  COORDS: 'coords',
  DATA: 'data',
  DATETIME: 'datetime',
  DEFAULT: 'default',
  DEFER: 'defer',
  DIR: 'dir',
  DIRNAME: 'dirname',
  DISABLED: 'disabled',
  DOWNLOAD: 'download',
  DRAGGABLE: 'draggable',
  DROPZONE: 'dropzone',
  ENCTYPE: 'enctype',
  FOR: 'for',
  FORM: 'form',
  FORMACTION: 'formaction',
  HEADERS: 'headers',
  HEIGHT: 'height',
  HIDDEN: 'hidden',
  HIGH: 'high',
  HREF: 'href',
  HREFLANG: 'hreflang',
  HTTP_EQUIV: 'http-equiv',
  ICON: 'icon',
  ID: 'id',
  ISMAP: 'ismap',
  ITEMPROP: 'itemprop',
  KEYTYPE: 'keytype',
  KIND: 'kind',
  LABEL: 'label',
  LANG: 'lang',
  LANGUAGE: 'language',
  LIST: 'list',
  LOOP: 'loop',
  LOW: 'low',
  MANIFEST: 'manifest',
  MAX: 'max',
  MAXLENGTH: 'maxlength',
  MEDIA: 'media',
  METHOD: 'method',
  MIN: 'min',
  MULTIPLE: 'multiple',
  MUTED: 'muted',
  NAME: 'name',
  NOVALIDATE: 'novalidate',
  OPEN: 'open',
  OPTIMUM: 'optimum',
  PATTERN: 'pattern',
  PING: 'ping',
  PLACEHOLDER: 'placeholder',
  POSTER: 'poster',
  PRELOAD: 'preload',
  RADIOGROUP: 'radiogroup',
  READONLY: 'readonly',
  REL: 'rel',
  REQUIRED: 'required',
  REVERSED: 'reversed',
  ROWS: 'rows',
  ROWSPAN: 'rowspan',
  SANDBOX: 'sandbox',
  SCOPE: 'scope',
  SCOPED: 'scoped',
  SEAMLESS: 'seamless',
  SELECTED: 'selected',
  SHAPE: 'shape',
  SIZE: 'size',
  SIZES: 'sizes',
  SPAN: 'span',
  SPELLCHECK: 'spellcheck',
  SRC: 'src',
  SRCDOC: 'srcdoc',
  SRCLANG: 'srclang',
  SRCSET: 'srcset',
  START: 'start',
  STEP: 'step',
  STYLE: 'style',
  SUMMARY: 'summary',
  TABINDEX: 'tabindex',
  TARGET: 'target',
  TITLE: 'title',
  TYPE: 'type',
  USEMAP: 'usemap',
  VALUE: 'value',
  WIDTH: 'width',
  WRAP: 'wrap'
};
