/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoBooleanEqualityRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.Op_EqualID, (node, tokenQuery, problems) -> this.checkBinaryOperatorNode((IBinaryOperatorNode)node, tokenQuery, problems));
        result.put(ASTNodeID.Op_NotEqualID, (node, tokenQuery, problems) -> this.checkBinaryOperatorNode((IBinaryOperatorNode)node, tokenQuery, problems));
        return result;
    }

    private void checkBinaryOperatorNode(IBinaryOperatorNode operatorNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IExpressionNode rightOperandNode;
        IExpressionNode leftOperandNode = operatorNode.getLeftOperandNode();
        if (ASTNodeID.LiteralBooleanID.equals((Object)leftOperandNode.getNodeID())) {
            problems.add(new NoBooleanEqualityLinterProblem(leftOperandNode));
        }
        if (ASTNodeID.LiteralBooleanID.equals((Object)(rightOperandNode = operatorNode.getRightOperandNode()).getNodeID())) {
            problems.add(new NoBooleanEqualityLinterProblem(rightOperandNode));
        }
    }

    public static class NoBooleanEqualityLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must simplify statement to remove redundant comparison with true or false";

        public NoBooleanEqualityLinterProblem(IExpressionNode node) {
            super((ISourceLocation)node);
        }
    }
}

