/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ModificationVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.util.ArrayDeque;

public class TemplateTypeMapReplacer
extends ModificationVisitor {
    private final TemplateTypeMap replacements;
    private final ArrayDeque<TemplateType> visitedTypes;
    private TemplateType keyType = null;
    private boolean replaceMissingTypesWithUnknown = false;

    public TemplateTypeMapReplacer(JSTypeRegistry registry, TemplateTypeMap replacements) {
        super(registry, false);
        this.replacements = replacements;
        this.visitedTypes = new ArrayDeque();
    }

    public TemplateTypeMapReplacer(JSTypeRegistry registry, TemplateTypeMap replacements, boolean replaceMissingTypesWithUnknown) {
        this(registry, replacements);
        this.replaceMissingTypesWithUnknown = replaceMissingTypesWithUnknown;
    }

    void setKeyType(TemplateType keyType) {
        this.keyType = keyType;
    }

    @Override
    public JSType caseTemplateType(TemplateType type) {
        if (this.replacements.hasTemplateKey(type)) {
            if (this.hasVisitedType(type)) {
                return type;
            }
            if (!this.replacements.hasTemplateType(type)) {
                return this.replaceMissingTypesWithUnknown ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : type;
            }
            JSType replacement = this.replacements.getUnresolvedOriginalTemplateType(type);
            if (replacement == this.keyType || this.isRecursive(type, replacement)) {
                return type;
            }
            this.visitedTypes.push(type);
            JSType visitedReplacement = replacement.visit(this);
            this.visitedTypes.pop();
            Preconditions.checkState(visitedReplacement != this.keyType, "Trying to replace key %s with the same value", (Object)this.keyType);
            return visitedReplacement;
        }
        return type;
    }

    private boolean isRecursive(TemplateType currentType, JSType replacementType) {
        TemplatizedType replacementTemplatizedType = replacementType.restrictByNotNullOrUndefined().toMaybeTemplatizedType();
        if (replacementTemplatizedType == null) {
            return false;
        }
        ImmutableList<JSType> replacementTemplateTypes = replacementTemplatizedType.getTemplateTypes();
        for (JSType replacementTemplateType : replacementTemplateTypes) {
            if (!replacementTemplateType.isTemplateType() || !this.isSameType(currentType, replacementTemplateType.toMaybeTemplateType())) continue;
            return true;
        }
        return false;
    }

    private boolean isSameType(TemplateType currentType, TemplateType replacementType) {
        return currentType == replacementType || currentType == this.replacements.getUnresolvedOriginalTemplateType(replacementType);
    }

    private boolean hasVisitedType(TemplateType type) {
        for (TemplateType visitedType : this.visitedTypes) {
            if (visitedType != type) continue;
            return true;
        }
        return false;
    }
}

