/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.Settings;
import apache.rocketmq.v2.Subscription;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.java.impl.ClientType;
import org.apache.rocketmq.client.java.impl.consumer.LitePushConsumerBuilderImpl;
import org.apache.rocketmq.client.java.impl.consumer.PushSubscriptionSettings;
import org.apache.rocketmq.client.java.message.protocol.Resource;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.misc.ExcludeFromJacocoGeneratedReport;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LitePushConsumerSettings
extends PushSubscriptionSettings {
    private static final Logger log = LoggerFactory.getLogger(LitePushConsumerSettings.class);
    final Resource bindTopic;
    private final Set<String> liteTopicSet = ConcurrentHashMap.newKeySet();
    private int liteSubscriptionQuota;
    private int maxLiteTopicSize = 64;
    private final AtomicLong version = new AtomicLong(System.currentTimeMillis());

    public LitePushConsumerSettings(LitePushConsumerBuilderImpl builder, ClientId clientId, Endpoints endpoints) {
        super(builder.clientConfiguration, clientId, ClientType.LITE_PUSH_CONSUMER, endpoints, builder.consumerGroup, builder.subscriptionExpressions);
        this.bindTopic = new Resource(this.namespace, builder.bindTopic);
    }

    public boolean containsLiteTopic(String liteTopic) {
        return this.liteTopicSet.contains(liteTopic);
    }

    public void addLiteTopic(String liteTopic) {
        if (!this.liteTopicSet.add(liteTopic)) {
            return;
        }
        this.version.set(System.currentTimeMillis());
    }

    public void removeLiteTopic(String liteTopic) {
        if (!this.liteTopicSet.remove(liteTopic)) {
            return;
        }
        this.version.set(System.currentTimeMillis());
    }

    public Set<String> getLiteTopicSet() {
        return ImmutableSet.copyOf(this.liteTopicSet);
    }

    public int getLiteSubscriptionQuota() {
        return this.liteSubscriptionQuota;
    }

    public int getMaxLiteTopicSize() {
        return this.maxLiteTopicSize;
    }

    public int getLiteTopicSetSize() {
        return this.liteTopicSet.size();
    }

    public long getVersion() {
        return this.version.get();
    }

    @Override
    public void sync(Settings settings) {
        super.sync(settings);
        Subscription subscription = settings.getSubscription();
        if (subscription.hasLiteSubscriptionQuota()) {
            this.liteSubscriptionQuota = subscription.getLiteSubscriptionQuota();
        }
        if (subscription.hasMaxLiteTopicSize()) {
            this.maxLiteTopicSize = subscription.getMaxLiteTopicSize();
        }
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("clientType", (Object)this.clientType).add("accessPoint", (Object)this.accessPoint).add("retryPolicy", (Object)this.retryPolicy).add("requestTimeout", (Object)this.requestTimeout).add("group", (Object)this.group).add("receiveBatchSize", this.receiveBatchSize).add("longPollingTimeout", (Object)this.longPollingTimeout).add("bindTopic", (Object)this.bindTopic).add("liteSubscriptionQuota", this.liteSubscriptionQuota).add("maxLiteTopicSize", this.maxLiteTopicSize).add("interestSet", this.liteTopicSet).add("version", (Object)this.version).toString();
    }
}

