/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller;

import io.netty.channel.Channel;
import java.util.Map;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.controller.helper.BrokerLifecycleListener;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerLiveInfo;
import org.apache.rocketmq.controller.impl.heartbeat.DefaultBrokerHeartbeatManager;
import org.apache.rocketmq.controller.impl.heartbeat.RaftBrokerHeartBeatManager;

public interface BrokerHeartbeatManager {
    public static final long DEFAULT_BROKER_CHANNEL_EXPIRED_TIME = 10000L;

    public static BrokerHeartbeatManager newBrokerHeartbeatManager(ControllerConfig controllerConfig) {
        if (controllerConfig.getControllerType().equals("jRaft")) {
            return new RaftBrokerHeartBeatManager(controllerConfig);
        }
        return new DefaultBrokerHeartbeatManager(controllerConfig);
    }

    public void initialize();

    public void onBrokerHeartbeat(String var1, String var2, String var3, Long var4, Long var5, Channel var6, Integer var7, Long var8, Long var9, Integer var10);

    public void start();

    public void shutdown();

    public void registerBrokerLifecycleListener(BrokerLifecycleListener var1);

    public void onBrokerChannelClose(Channel var1);

    public BrokerLiveInfo getBrokerLiveInfo(String var1, String var2, Long var3);

    public boolean isBrokerActive(String var1, String var2, Long var3);

    public Map<String, Map<String, Integer>> getActiveBrokersNum();
}

