/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol.exceptions;

import java.util.Collection;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.exceptions.RaftException;

public class NotReplicatedException
extends RaftException {
    private final long callId;
    private final RaftProtos.ReplicationLevel requiredReplication;
    private final long logIndex;
    private Collection<RaftProtos.CommitInfoProto> commitInfos;

    public NotReplicatedException(long callId, RaftProtos.ReplicationLevel requiredReplication, long logIndex) {
        super("Request with call Id " + callId + " and log index " + logIndex + " is not yet replicated to " + requiredReplication);
        this.callId = callId;
        this.requiredReplication = requiredReplication;
        this.logIndex = logIndex;
    }

    public NotReplicatedException(long callId, RaftProtos.ReplicationLevel requiredReplication, long logIndex, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this(callId, requiredReplication, logIndex);
        this.commitInfos = commitInfos;
    }

    public long getCallId() {
        return this.callId;
    }

    public RaftProtos.ReplicationLevel getRequiredReplication() {
        return this.requiredReplication;
    }

    public long getLogIndex() {
        return this.logIndex;
    }

    public Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        return this.commitInfos;
    }
}

