/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcherWrapper;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPathResourceMatcher
extends RangerDefaultResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPathResourceMatcher.class);
    public static final String OPTION_PATH_SEPARATOR = "pathSeparatorChar";
    public static final char DEFAULT_PATH_SEPARATOR_CHAR = '/';
    private boolean policyIsRecursive;
    private Character pathSeparatorChar = Character.valueOf('/');

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPathResourceMatcher.init()");
        }
        Map<String, String> options = this.resourceDef == null ? null : this.resourceDef.getMatcherOptions();
        this.policyIsRecursive = this.policyResource != null && this.policyResource.getIsRecursive() != false;
        this.pathSeparatorChar = Character.valueOf(ServiceDefUtil.getCharOption(options, OPTION_PATH_SEPARATOR, '/'));
        super.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPathResourceMatcher.init()");
        }
    }

    @Override
    protected ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher;
            if (this.optWildCard && this.policyIsRecursive && policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar.charValue()) {
                policyValue = policyValue + "*";
            }
            if ((matcher = this.getMatcher(policyValue)) == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        Collections.sort(resourceMatchers, new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    @Override
    ResourceMatcher getMatcher(String policyValue) {
        int len;
        if (!this.policyIsRecursive) {
            return this.getPathMatcher(policyValue);
        }
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        if (this.optWildCard && "*".equals(policyValue)) {
            return new CaseInsensitiveStringMatcher("", this.getOptions());
        }
        boolean isWildcardPresent = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c != '?' && c != '*') continue;
                isWildcardPresent = true;
                break;
            }
        }
        AbstractPathResourceMatcher ret = isWildcardPresent ? new RecursiveWildcardResourceMatcher(policyValue, this.getOptions(), this.pathSeparatorChar.charValue(), this.optIgnoreCase, RangerPathResourceMatcher::isRecursiveWildCardMatch, this.optIgnoreCase ? 8 : 7) : new RecursivePathResourceMatcher(policyValue, this.getOptions(), this.pathSeparatorChar.charValue(), this.optIgnoreCase, this.optIgnoreCase ? 8 : 7);
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, Character pathSeparatorChar, IOCase caseSensitivity, String[] wildcardPathElements) {
        boolean ret = false;
        if (!StringUtils.isEmpty((CharSequence)pathToCheck)) {
            Object[] pathElements = StringUtils.split((String)pathToCheck, (char)pathSeparatorChar.charValue());
            if (!ArrayUtils.isEmpty((Object[])pathElements)) {
                StringBuilder sb = new StringBuilder();
                if (pathToCheck.charAt(0) == pathSeparatorChar.charValue()) {
                    sb.append(pathSeparatorChar);
                }
                int pathElementIndex = 0;
                boolean useStringMatching = true;
                for (Object p : pathElements) {
                    sb.append((String)p);
                    if (useStringMatching) {
                        if (wildcardPathElements.length > pathElementIndex) {
                            String wp = wildcardPathElements[pathElementIndex];
                            if (!StringUtils.contains((CharSequence)wp, (int)42) && !StringUtils.contains((CharSequence)wp, (int)63)) {
                                boolean isMatch;
                                boolean bl = isMatch = caseSensitivity.isCaseSensitive() ? StringUtils.equals((CharSequence)p, (CharSequence)wp) : StringUtils.equalsIgnoreCase((CharSequence)p, (CharSequence)wp);
                                if (!isMatch) {
                                    useStringMatching = false;
                                    break;
                                }
                            } else {
                                useStringMatching = false;
                            }
                        } else {
                            useStringMatching = false;
                        }
                    }
                    if (!useStringMatching && (ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity))) break;
                    sb.append(pathSeparatorChar);
                    ++pathElementIndex;
                }
                if (useStringMatching) {
                    if (pathElements.length == wildcardPathElements.length) {
                        ret = true;
                    } else if (pathToCheck.charAt(pathToCheck.length() - 1) == pathSeparatorChar.charValue()) {
                        ret = pathElements.length == wildcardPathElements.length - 1 && "*".equals(wildcardPathElements[wildcardPathElements.length - 1]);
                    }
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch((String)pathToCheck, (String)wildcardPath, (IOCase)caseSensitivity);
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPathResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }

    private ResourceMatcher getPathMatcher(String policyValue) {
        AbstractPathResourceMatcher ret;
        int len;
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        int wildcardStartIdx = -1;
        int wildcardEndIdx = -1;
        boolean needWildcardMatch = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c == '?') {
                    needWildcardMatch = true;
                    break;
                }
                if (c != '*') continue;
                if (wildcardEndIdx == -1 || wildcardEndIdx == i - 1) {
                    wildcardEndIdx = i;
                    if (wildcardStartIdx != -1) continue;
                    wildcardStartIdx = i;
                    continue;
                }
                needWildcardMatch = true;
                break;
            }
        }
        if (needWildcardMatch) {
            ret = new WildcardResourceMatcher(policyValue, this.getOptions(), this.pathSeparatorChar.charValue(), this.optIgnoreCase, FilenameUtils::wildcardMatch, 6);
        } else if (wildcardStartIdx == -1) {
            ret = new PathResourceMatcher(policyValue, this.getOptions(), this.pathSeparatorChar.charValue(), this.optIgnoreCase ? StringUtils::equalsIgnoreCase : StringUtils::equals, !this.optIgnoreCase, this.optIgnoreCase ? 2 : 1);
        } else if (wildcardStartIdx == 0) {
            String matchStr = policyValue.substring(wildcardEndIdx + 1);
            ret = new PathEndsWithResourceMatcher(matchStr, this.getOptions(), this.pathSeparatorChar.charValue(), !this.optIgnoreCase, this.optIgnoreCase ? 4 : 3);
        } else if (wildcardEndIdx != len - 1) {
            ret = new WildcardResourceMatcher(policyValue, this.getOptions(), this.pathSeparatorChar.charValue(), this.optIgnoreCase, FilenameUtils::wildcardMatch, 6);
        } else {
            String matchStr = policyValue.substring(0, wildcardStartIdx);
            ret = new PathStartsWithResourceMatcher(matchStr, this.getOptions(), this.pathSeparatorChar.charValue(), !this.optIgnoreCase, this.optIgnoreCase ? 4 : 3);
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static class RecursivePathResourceMatcher
    extends AbstractPathResourceMatcher {
        final IOCase ioCase;
        final BiFunction<String, String, Boolean> primaryFunction;
        final BiFunction<String, String, Boolean> fallbackFunction;
        final String valueWithoutSeparator;
        final String valueWithSeparator;

        RecursivePathResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, boolean optIgnoreCase, int priority) {
            super(value, options, pathSeparatorChar, true, priority);
            this.ioCase = optIgnoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
            this.primaryFunction = optIgnoreCase ? StringUtils::equalsIgnoreCase : StringUtils::equals;
            BiFunction<String, String, Boolean> biFunction = this.fallbackFunction = optIgnoreCase ? StringUtils::startsWithIgnoreCase : StringUtils::startsWith;
            if (this.value == null || this.getNeedsDynamicEval()) {
                this.valueWithoutSeparator = null;
                this.valueWithSeparator = null;
            } else {
                this.valueWithoutSeparator = this.getStringToCompare(this.value);
                this.valueWithSeparator = this.valueWithoutSeparator + pathSeparatorChar;
            }
        }

        String getStringToCompare(String policyValue) {
            if (StringUtils.isEmpty((CharSequence)policyValue)) {
                return policyValue;
            }
            return policyValue.lastIndexOf(this.pathSeparatorChar) == policyValue.length() - 1 ? policyValue.substring(0, policyValue.length() - 1) : policyValue;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String expandedPolicyValue;
            String noSeparator;
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RecursivePathResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")");
            }
            if (!(ret = this.primaryFunction.apply(resourceValue, noSeparator = this.getNeedsDynamicEval() ? ((expandedPolicyValue = this.getExpandedValue(evalContext)) != null ? this.getStringToCompare(expandedPolicyValue) : null) : this.valueWithoutSeparator).booleanValue()) && noSeparator != null) {
                String withSeparator = this.getNeedsDynamicEval() ? noSeparator + this.pathSeparatorChar : this.valueWithSeparator;
                ret = this.fallbackFunction.apply(resourceValue, withSeparator);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RecursivePathResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValueWithoutTrailingSeparatorChar=" + noSeparator + ") : result:[" + ret + "]");
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RecursiveWildcardResourceMatcher.isPrefixMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")");
            }
            boolean ret = ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), this.ioCase);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RecursiveWildcardResourceMatcher.isPrefixMatch(resourceValue=" + resourceValue + ", expandedValue=" + this.getExpandedValue(evalContext) + ") : result:[" + ret + "]");
            }
            return ret;
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            int lastLevelSeparatorIndex;
            String expandedPolicyValue;
            boolean ret = false;
            String noSeparator = this.getNeedsDynamicEval() ? ((expandedPolicyValue = this.getExpandedValue(evalContext)) != null ? this.getStringToCompare(expandedPolicyValue) : null) : this.valueWithoutSeparator;
            int n = lastLevelSeparatorIndex = noSeparator != null ? noSeparator.lastIndexOf(this.pathSeparatorChar) : -1;
            if (lastLevelSeparatorIndex != -1) {
                String shorterExpandedValue = noSeparator.substring(0, lastLevelSeparatorIndex);
                if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                    resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                }
                ret = this.primaryFunction.apply(resourceValue, shorterExpandedValue);
            }
            return ret;
        }
    }

    static class RecursiveWildcardResourceMatcher
    extends AbstractPathResourceMatcher {
        final QuintFunction<String, String, Character, IOCase, Boolean, String[]> function;
        final IOCase ioCase;
        String[] wildcardPathElements;

        RecursiveWildcardResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, boolean optIgnoreCase, QuintFunction<String, String, Character, IOCase, Boolean, String[]> function, int priority) {
            super(value, options, pathSeparatorChar, !optIgnoreCase, priority);
            this.function = function;
            IOCase iOCase = this.ioCase = optIgnoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
            if (!this.getNeedsDynamicEval()) {
                this.wildcardPathElements = StringUtils.split((String)value, (char)pathSeparatorChar);
            }
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String expandedValue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RecursiveWildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")");
            }
            if (this.getNeedsDynamicEval()) {
                expandedValue = this.getExpandedValue(evalContext);
                this.wildcardPathElements = StringUtils.split((String)expandedValue, (char)this.pathSeparatorChar);
            } else {
                expandedValue = this.value;
            }
            boolean ret = this.function.apply(resourceValue, expandedValue, Character.valueOf(this.pathSeparatorChar), this.ioCase, this.wildcardPathElements);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RecursiveWildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValue=" + expandedValue + ") : result:[" + ret + "]");
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RecursiveWildcardResourceMatcher.isPrefixMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")");
            }
            boolean ret = ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), this.ioCase);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RecursiveWildcardResourceMatcher.isPrefixMatch(resourceValue=" + resourceValue + ", expandedValue=" + this.getExpandedValue(evalContext) + ") : result:[" + ret + "]");
            }
            return ret;
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            boolean ret = false;
            String expandedValue = this.getExpandedValue(evalContext);
            int lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar);
            if (lastLevelSeparatorIndex != -1) {
                String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                    resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                }
                String[] shorterWildCardPathElements = StringUtils.split((String)shorterExpandedValue, (char)this.pathSeparatorChar);
                ret = this.function.apply(resourceValue, shorterExpandedValue, Character.valueOf(this.pathSeparatorChar), this.ioCase, shorterWildCardPathElements);
            }
            return ret;
        }
    }

    static class WildcardResourceMatcher
    extends AbstractPathResourceMatcher {
        final TriFunction<String, String, IOCase, Boolean> function;
        final IOCase ioCase;

        WildcardResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, boolean optIgnoreCase, TriFunction<String, String, IOCase, Boolean> function, int priority) {
            super(value, options, pathSeparatorChar, !optIgnoreCase, priority);
            this.function = function;
            this.ioCase = optIgnoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
        }

        @Override
        public boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> WildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")");
            }
            String expandedValue = this.getExpandedValue(evalContext);
            boolean ret = this.function.apply(resourceValue, expandedValue, this.ioCase);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== WildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValue=" + expandedValue + ") : result:[" + ret + "]");
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> WildcardResourceMatcher.isPrefixMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")");
            }
            boolean ret = ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), this.ioCase);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== WildcardResourceMatcher.isPrefixMatch(resourceValue=" + resourceValue + ", expandedValue=" + this.getExpandedValue(evalContext) + ") : result:[" + ret + "]");
            }
            return ret;
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            boolean ret = false;
            String expandedValue = this.getExpandedValue(evalContext);
            int lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar);
            if (lastLevelSeparatorIndex != -1) {
                String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                    resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                }
                ret = this.function.apply(resourceValue, shorterExpandedValue, this.ioCase);
            }
            return ret;
        }
    }

    static class PathEndsWithResourceMatcher
    extends AbstractPathResourceMatcher {
        PathEndsWithResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, boolean isCaseSensitive, int priority) {
            super(value, options, pathSeparatorChar, isCaseSensitive, priority);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathEndsWithResourceMatcher.isMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean bl = ret = this.isCaseSensitive ? StringUtils.endsWith((CharSequence)resourceValue, (CharSequence)this.getExpandedValue(evalContext)) : StringUtils.endsWithIgnoreCase((CharSequence)resourceValue, (CharSequence)this.getExpandedValue(evalContext));
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathEndsWithResourceMatcher.isMatch(resourceValue={}, expandedValue={}): ret={}", new Object[]{resourceValue, this.getExpandedValue(evalContext), ret});
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathEndsWithResourceMatcher.isPrefixMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean ret = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathEndsWithResourceMatcher.isPrefixMatch(resourceValue={}, expandedValue={}): ret={}", new Object[]{resourceValue, this.getExpandedValue(evalContext), ret});
            }
            return ret;
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathEndsWithResourceMatcher.isChildMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean ret = false;
            String expandedValue = this.getExpandedValue(evalContext);
            int lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar);
            if (lastLevelSeparatorIndex != -1) {
                String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                    resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                }
                boolean bl = ret = this.isCaseSensitive ? StringUtils.endsWith((CharSequence)resourceValue, (CharSequence)shorterExpandedValue) : StringUtils.endsWithIgnoreCase((CharSequence)resourceValue, (CharSequence)shorterExpandedValue);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathEndsWithResourceMatcher.isChildMatch(resourceValue={}, lastLevelSeparatorIndex={}): ret={}", new Object[]{resourceValue, lastLevelSeparatorIndex, ret});
            }
            return ret;
        }
    }

    static class PathStartsWithResourceMatcher
    extends AbstractPathResourceMatcher {
        PathStartsWithResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, boolean isCaseSensitive, int priority) {
            super(value, options, pathSeparatorChar, isCaseSensitive, priority);
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathStartsWithResourceMatcher.isMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean bl = ret = this.isCaseSensitive ? StringUtils.startsWith((CharSequence)resourceValue, (CharSequence)this.getExpandedValue(evalContext)) : StringUtils.startsWithIgnoreCase((CharSequence)resourceValue, (CharSequence)this.getExpandedValue(evalContext));
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathStartsWithResourceMatcher.isMatch(resourceValue={}, expandedValue={}): ret={}", new Object[]{resourceValue, this.getExpandedValue(evalContext), ret});
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathStartsWithResourceMatcher.isPrefixMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean bl = ret = this.isCaseSensitive ? StringUtils.startsWith((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue) : StringUtils.startsWithIgnoreCase((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathStartsWithResourceMatcher.isPrefixMatch(resourceValue={}, expandedValue={}): ret={}", new Object[]{resourceValue, this.getExpandedValue(evalContext), ret});
            }
            return ret;
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathStartsWithResourceMatcher.isChildMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean ret = false;
            String expandedValue = this.getExpandedValue(evalContext);
            int lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar);
            if (lastLevelSeparatorIndex != -1) {
                String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                    resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                }
                boolean bl = ret = this.isCaseSensitive ? StringUtils.startsWith((CharSequence)resourceValue, (CharSequence)shorterExpandedValue) : StringUtils.startsWithIgnoreCase((CharSequence)resourceValue, (CharSequence)shorterExpandedValue);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathStartsWithResourceMatcher.isChildMatch(resourceValue={}, lastLevelSeparatorIndex={}): ret={}", new Object[]{resourceValue, lastLevelSeparatorIndex, ret});
            }
            return ret;
        }
    }

    static class PathResourceMatcher
    extends AbstractPathResourceMatcher {
        final BiFunction<String, String, Boolean> function;

        PathResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, BiFunction<String, String, Boolean> function, boolean isCaseSensitive, int priority) {
            super(value, options, pathSeparatorChar, isCaseSensitive, priority);
            this.function = function;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathResourceMatcher.isMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            String expandedValue = this.getExpandedValue(evalContext);
            boolean ret = this.function.apply(resourceValue, expandedValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathResourceMatcher.isMatch(resourceValue={}, expandedValue={}): ret={}", new Object[]{resourceValue, this.getExpandedValue(evalContext), ret});
            }
            return ret;
        }

        @Override
        public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathResourceMatcher.isPrefixMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean bl = ret = this.isCaseSensitive ? StringUtils.startsWith((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue) : StringUtils.startsWithIgnoreCase((CharSequence)this.getExpandedValue(evalContext), (CharSequence)resourceValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathResourceMatcher.isPrefixMatch(resourceValue={}, expandedValue={}): ret={}", new Object[]{resourceValue, this.getExpandedValue(evalContext), ret});
            }
            return ret;
        }

        @Override
        public boolean isChildMatch(String resourceValue, Map<String, Object> evalContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> PathResourceMatcher.isChildMatch(resourceValue={}, evalContext={})", (Object)resourceValue, evalContext);
            }
            boolean ret = false;
            String expandedValue = this.getExpandedValue(evalContext);
            int lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar);
            if (lastLevelSeparatorIndex != -1) {
                String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                    resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                }
                ret = this.function.apply(resourceValue, shorterExpandedValue);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== PathResourceMatcher.isChildMatch(resourceValue={}, lastLevelSeparatorIndex={}): ret={}", new Object[]{resourceValue, lastLevelSeparatorIndex, ret});
            }
            return ret;
        }
    }

    static abstract class AbstractPathResourceMatcher
    extends ResourceMatcher {
        final char pathSeparatorChar;
        final int priority;
        final boolean isCaseSensitive;

        AbstractPathResourceMatcher(String value, Map<String, String> options, char pathSeparatorChar, boolean isCaseSensitive, int priority) {
            super(value, options);
            this.pathSeparatorChar = pathSeparatorChar;
            this.priority = priority;
            this.isCaseSensitive = isCaseSensitive;
        }

        @Override
        int getPriority() {
            return this.priority + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static interface QuintFunction<T, U, V, W, R, X> {
        public R apply(T var1, U var2, V var3, W var4, X var5);
    }

    static interface QuadFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

