/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.BucketScriptPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BucketScriptPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<BucketScriptPipelineAggregationBuilder> {
    public static final String NAME = "bucket_script";
    private final Script script;
    private final Map<String, String> bucketsPathsMap;
    private String format = null;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    public static final ConstructingObjectParser<BucketScriptPipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser("bucket_script", false, (args, name) -> {
        Map bucketsPathsMap = (Map)args[0];
        return new BucketScriptPipelineAggregationBuilder((String)name, bucketsPathsMap, (Script)args[1]);
    });

    public BucketScriptPipelineAggregationBuilder(String name, Map<String, String> bucketsPathsMap, Script script) {
        super(name, NAME, new TreeMap<String, String>(bucketsPathsMap).values().toArray(new String[bucketsPathsMap.size()]));
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
    }

    public BucketScriptPipelineAggregationBuilder(String name, Script script, String ... bucketsPaths) {
        this(name, BucketScriptPipelineAggregationBuilder.convertToBucketsPathMap(bucketsPaths), script);
    }

    public BucketScriptPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        int mapSize = in.readVInt();
        this.bucketsPathsMap = new HashMap<String, String>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            this.bucketsPathsMap.put(in.readString(), in.readString());
        }
        this.script = new Script(in);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.bucketsPathsMap.size());
        for (Map.Entry<String, String> e : this.bucketsPathsMap.entrySet()) {
            out.writeString(e.getKey());
            out.writeString(e.getValue());
        }
        this.script.writeTo(out);
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
    }

    private static Map<String, String> extractBucketPath(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Collections.singletonMap("_value", parser.text());
        }
        if (token == XContentParser.Token.START_ARRAY) {
            HashMap<String, String> bucketsPathsMap = new HashMap<String, String>();
            int i = 0;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                String path = parser.text();
                bucketsPathsMap.put("_value" + i++, path);
            }
            return bucketsPathsMap;
        }
        return parser.mapStrings();
    }

    private static Map<String, String> convertToBucketsPathMap(String[] bucketsPaths) {
        HashMap<String, String> bucketsPathsMap = new HashMap<String, String>();
        for (int i = 0; i < bucketsPaths.length; ++i) {
            bucketsPathsMap.put("_value" + i, bucketsPaths[i]);
        }
        return bucketsPathsMap;
    }

    public BucketScriptPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public BucketScriptPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new BucketScriptPipelineAggregator(this.name, this.bucketsPathsMap, this.script, this.formatter(), this.gapPolicy, metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), this.bucketsPathsMap);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        if (this.format != null) {
            builder.field(PipelineAggregator.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        return builder;
    }

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        context.validateHasParent(NAME, this.name);
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketsPathsMap, this.script, this.format, this.gapPolicy);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BucketScriptPipelineAggregationBuilder other = (BucketScriptPipelineAggregationBuilder)obj;
        return Objects.equals(this.bucketsPathsMap, other.bucketsPathsMap) && Objects.equals(this.script, other.script) && Objects.equals(this.format, other.format) && Objects.equals(this.gapPolicy, other.gapPolicy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), BucketScriptPipelineAggregationBuilder::extractBucketPath, BUCKETS_PATH_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        Script.declareScript(PARSER, ConstructingObjectParser.constructorArg());
        PARSER.declareString(BucketScriptPipelineAggregationBuilder::format, PipelineAggregator.Parser.FORMAT);
        PARSER.declareField(BucketScriptPipelineAggregationBuilder::gapPolicy, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return BucketHelpers.GapPolicy.parse(p.text().toLowerCase(Locale.ROOT), p.getTokenLocation());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, PipelineAggregator.Parser.GAP_POLICY, ObjectParser.ValueType.STRING);
    }
}

