/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.rollup.job.config.RollupJobConfig;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PutRollupJobRequest
implements Validatable,
ToXContentObject {
    private final RollupJobConfig config;

    public PutRollupJobRequest(RollupJobConfig config) {
        this.config = Objects.requireNonNull(config, "rollup job configuration is required");
    }

    public RollupJobConfig getConfig() {
        return this.config;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.config.toXContent(builder, params);
    }

    @Override
    public Optional<ValidationException> validate() {
        return this.config.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutRollupJobRequest that = (PutRollupJobRequest)o;
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }
}

