/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.yarn.client.json.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class YarnSchedulerResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FAIR_SCHEDULER = "fairScheduler";
    private static final String CAPACITY_SCHEDULER = "capacityScheduler";
    private static final String CAPACITY_SCHEDULER_LEAF_QUEUE = "capacitySchedulerLeafQueueInfo";
    private YarnScheduler scheduler;

    public YarnScheduler getScheduler() {
        return this.scheduler;
    }

    public List<String> getQueueNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.scheduler != null) {
            this.scheduler.collectQueueNames(ret);
        }
        return ret;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ChildQueues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RootQueue> queue;

        public List<RootQueue> getQueue() {
            return this.queue;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.queue != null) {
                for (RootQueue queue : this.queue) {
                    queue.collectQueueNames(queueNames);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RootQueue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String queueName;
        private ChildQueues childQueues;

        public String getQueueName() {
            return this.queueName;
        }

        public ChildQueues getChildQueues() {
            return this.childQueues;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.queueName != null) {
                queueNames.add(this.queueName);
                if (this.childQueues != null) {
                    this.childQueues.collectQueueNames(queueNames);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class YarnQueues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<YarnSchedulerInfo> queue = null;

        public List<YarnSchedulerInfo> getQueue() {
            return this.queue;
        }

        public void collectQueueNames(List<String> queueNames, String parentQueueName) {
            if (this.queue != null) {
                for (YarnSchedulerInfo schedulerInfo : this.queue) {
                    schedulerInfo.collectQueueNames(queueNames, parentQueueName);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class YarnSchedulerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String type;
        private RootQueue rootQueue;
        private String queueName;
        private YarnQueues queues;

        public String getType() {
            return this.type;
        }

        public RootQueue getRootQueue() {
            return this.rootQueue;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public YarnQueues getQueues() {
            return this.queues;
        }

        public void collectQueueNames(List<String> queueNames, String parentQueueName) {
            if (this.type != null) {
                if (this.type.equals(YarnSchedulerResponse.FAIR_SCHEDULER)) {
                    if (this.rootQueue != null) {
                        this.rootQueue.collectQueueNames(queueNames);
                    }
                } else if ((this.type.equals(YarnSchedulerResponse.CAPACITY_SCHEDULER) || this.type.equals(YarnSchedulerResponse.CAPACITY_SCHEDULER_LEAF_QUEUE)) && this.queueName != null) {
                    String queueFqdn = parentQueueName == null ? this.queueName : parentQueueName + "." + this.queueName;
                    queueNames.add(queueFqdn);
                    if (this.queues != null) {
                        this.queues.collectQueueNames(queueNames, queueFqdn);
                    }
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class YarnScheduler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private YarnSchedulerInfo schedulerInfo = null;

        public YarnSchedulerInfo getSchedulerInfo() {
            return this.schedulerInfo;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.schedulerInfo != null) {
                this.schedulerInfo.collectQueueNames(queueNames, null);
            }
        }
    }
}

