/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillQueryImpl
implements KillQuery {
    private static final Logger LOG = LoggerFactory.getLogger(KillQueryImpl.class);
    private final OperationManager operationManager;

    public KillQueryImpl(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    public void killQuery(String queryId, String errMsg) throws HiveException {
        try {
            Operation operation = this.operationManager.getOperationByQueryId(queryId);
            if (operation == null) {
                LOG.info("Query not found: " + queryId);
            } else {
                OperationHandle handle = operation.getHandle();
                this.operationManager.cancelOperation(handle, errMsg);
            }
        }
        catch (HiveSQLException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

