/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.ozone.client.OzoneResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceOzone
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceOzone.class);
    public static final String ACCESS_TYPE_READ = "read";
    public static final String ACCESS_TYPE_WRITE = "write";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_LIST = "list";
    public static final String ACCESS_TYPE_DELETE = "delete";
    public static final String ACCESS_TYPE_READ_ACL = "read_acl";
    public static final String ACCESS_TYPE_WRITE_ACL = "write_acl";
    public static final String ACCESS_TYPE_ALL = "all";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceOzone.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = OzoneResourceMgr.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException e) {
                LOG.error("<== RangerServiceOzone.validateConfig Error: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceOzone.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceOzone.lookupResource Context: (" + context + ")");
        }
        if (context != null) {
            try {
                ret = OzoneResourceMgr.getOzoneResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceOzone.lookupResource Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceOzone.lookupResource Response: (" + ret + ")");
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceOzone.getDefaultRangerPolicies() ");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().startsWith(ACCESS_TYPE_ALL)) continue;
            RangerPolicy.RangerPolicyItem policyItemOwner = new RangerPolicy.RangerPolicyItem();
            policyItemOwner.setUsers(Collections.singletonList("{OWNER}"));
            policyItemOwner.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_ALL)));
            policyItemOwner.setDelegateAdmin(Boolean.valueOf(true));
            defaultPolicy.addPolicyItem(policyItemOwner);
            if (!StringUtils.isNotBlank((CharSequence)this.lookUpUser)) continue;
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_WRITE));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_CREATE));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_LIST));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_DELETE));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ_ACL));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_WRITE_ACL));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_ALL));
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.addPolicyItem(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceOzone.getDefaultRangerPolicies() : " + ret);
        }
        return ret;
    }
}

