/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;

public class FieldToAttributeMapping {
    private static final Splitter ATTR_NAME_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final String fieldName;
    private final Collection<String> attributes;
    private final FilterType filterType;
    private final boolean acceptEmpty;
    private final String allUsersValue;
    private final Pattern attrValueRegex;
    private final String extraOpts;

    public FieldToAttributeMapping(String fieldName, String ldapAttributeNames, String filterType, boolean acceptEmpty, String allUsersValue, String valueFilterRegex, String extraOpts) {
        this.fieldName = fieldName;
        this.attributes = Collections.unmodifiableSet(Sets.newHashSet((Iterable)ATTR_NAME_SPLITTER.split((CharSequence)ldapAttributeNames)));
        this.filterType = FilterType.valueOf(filterType);
        this.acceptEmpty = acceptEmpty;
        this.allUsersValue = allUsersValue;
        this.attrValueRegex = Pattern.compile(valueFilterRegex);
        this.extraOpts = extraOpts;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public boolean getAcceptEmpty() {
        return this.acceptEmpty;
    }

    public String getAllUsersValue() {
        return this.allUsersValue;
    }

    public String getExtraOpts() {
        return this.extraOpts;
    }

    public Pattern getAttrValueRegex() {
        return this.attrValueRegex;
    }

    static enum FilterType {
        AND,
        OR,
        LTE,
        GTE;

    }
}

