/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import java.util.ServiceLoader;
import java.util.TreeMap;
import picocli.CommandLine;

public interface ExtensibleParentCommand {
    public Class<?> subcommandType();

    public static void addSubcommands(CommandLine cli) {
        Object command = cli.getCommand();
        if (command instanceof ExtensibleParentCommand) {
            ExtensibleParentCommand parentCommand = (ExtensibleParentCommand)command;
            ServiceLoader<?> subcommands = ServiceLoader.load(parentCommand.subcommandType());
            TreeMap<String, CommandLine> sorted = new TreeMap<String, CommandLine>();
            for (Object subcommand : subcommands) {
                CommandLine.Command commandAnnotation = subcommand.getClass().getAnnotation(CommandLine.Command.class);
                CommandLine subcommandCommandLine = new CommandLine(subcommand, cli.getFactory());
                sorted.put(commandAnnotation.name(), subcommandCommandLine);
            }
            sorted.forEach((arg_0, arg_1) -> ((CommandLine)cli).addSubcommand(arg_0, arg_1));
        }
        for (CommandLine subcommand : cli.getSubcommands().values()) {
            ExtensibleParentCommand.addSubcommands(subcommand);
        }
    }
}

