/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;

public final class HiveJoinAddNotNullRule
extends RelOptRule {
    public static final HiveJoinAddNotNullRule INSTANCE_JOIN = new HiveJoinAddNotNullRule(HiveJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    public static final HiveJoinAddNotNullRule INSTANCE_SEMIJOIN = new HiveJoinAddNotNullRule(HiveSemiJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public HiveJoinAddNotNullRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinAddNotNullRule.operand(clazz, (RelOptRuleOperandChildren)HiveJoinAddNotNullRule.any()));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        Join join = (Join)call.rel(0);
        RelNode lChild = join.getLeft();
        RelNode rChild = join.getRight();
        HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        assert (registry != null);
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        try {
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        }
        catch (CalciteSemanticException e) {
            return;
        }
        ArrayList<RexNode> leftJoinExprsList = new ArrayList<RexNode>();
        ArrayList<RexNode> rightJoinExprsList = new ArrayList<RexNode>();
        for (HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredicateInfo : joinPredInfo.getEquiJoinPredicateElements()) {
            leftJoinExprsList.addAll(joinLeafPredicateInfo.getJoinExprs(0));
            rightJoinExprsList.addAll(joinLeafPredicateInfo.getJoinExprs(1));
        }
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        HashSet<String> leftPushedPredicates = Sets.newHashSet(registry.getPushedPredicates((RelNode)join, 0));
        List<RexNode> newLeftConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, leftJoinExprsList, leftPushedPredicates);
        HashSet<String> rightPushedPredicates = Sets.newHashSet(registry.getPushedPredicates((RelNode)join, 1));
        List<RexNode> newRightConditions = HiveJoinAddNotNullRule.getNotNullConditions(cluster, rexBuilder, rightJoinExprsList, rightPushedPredicates);
        RexNode newLeftPredicate = RexUtil.composeConjunction((RexBuilder)rexBuilder, newLeftConditions, (boolean)false);
        RexNode newRightPredicate = RexUtil.composeConjunction((RexBuilder)rexBuilder, newRightConditions, (boolean)false);
        if (newLeftPredicate.isAlwaysTrue() && newRightPredicate.isAlwaysTrue()) {
            return;
        }
        if (!newLeftPredicate.isAlwaysTrue()) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, newLeftPredicate);
            call.getPlanner().onCopy(curr, lChild);
        }
        if (!newRightPredicate.isAlwaysTrue()) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, newRightPredicate);
            call.getPlanner().onCopy(curr, rChild);
        }
        Join newJoin = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newJoin);
        registry.getPushedPredicates((RelNode)newJoin, 0).addAll(leftPushedPredicates);
        registry.getPushedPredicates((RelNode)newJoin, 1).addAll(rightPushedPredicates);
        call.transformTo((RelNode)newJoin);
    }

    private static List<RexNode> getNotNullConditions(RelOptCluster cluster, RexBuilder rexBuilder, List<RexNode> inputJoinExprs, Set<String> pushedPredicates) {
        ArrayList<RexNode> newConditions = Lists.newArrayList();
        for (RexNode rexNode : inputJoinExprs) {
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexNode});
            String digest = cond.toString();
            if (!pushedPredicates.add(digest)) continue;
            newConditions.add(cond);
        }
        return newConditions;
    }
}

