/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Experimental(eta="2022-10-31")
public class FunctionNullability {
    private final boolean returnNullable;
    private final List<Boolean> argumentNullable;

    @JsonCreator
    public FunctionNullability(@JsonProperty(value="returnNullable") boolean returnNullable, @JsonProperty(value="argumentNullable") List<Boolean> argumentNullable) {
        this.returnNullable = returnNullable;
        this.argumentNullable = List.copyOf((Collection)Objects.requireNonNull(argumentNullable, "argumentNullable is null"));
    }

    @JsonProperty
    public boolean isReturnNullable() {
        return this.returnNullable;
    }

    public boolean isArgumentNullable(int index) {
        return this.argumentNullable.get(index);
    }

    @JsonProperty
    public List<Boolean> getArgumentNullable() {
        return this.argumentNullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionNullability that = (FunctionNullability)o;
        return this.returnNullable == that.returnNullable && this.argumentNullable.equals(that.argumentNullable);
    }

    public int hashCode() {
        return Objects.hash(this.returnNullable, this.argumentNullable);
    }

    public String toString() {
        return this.argumentNullable.stream().map(Objects::toString).collect(Collectors.joining(", ", "(", ")")) + this.returnNullable;
    }
}

