/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.futures;

import java.util.concurrent.Future;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.futures.BalancedClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientSynchronization;
import org.apache.qpid.protonj2.client.futures.ConservativeClientFuture;
import org.apache.qpid.protonj2.client.futures.ProgressiveClientFuture;

public abstract class ClientFutureFactory {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String WINDOWS_OS_PREFIX = "Windows";
    private static final boolean IS_WINDOWS = ClientFutureFactory.isOsNameMatch(OS_NAME, "Windows");
    public static final String CONSERVATIVE = "conservative";
    public static final String BALANCED = "balanced";
    public static final String PROGRESSIVE = "progressive";

    public static ClientFutureFactory create(String futureType) {
        if (futureType == null || futureType.isEmpty()) {
            if (Runtime.getRuntime().availableProcessors() < 4) {
                return new ConservativeProviderFutureFactory();
            }
            if (ClientFutureFactory.isWindows()) {
                return new BalancedProviderFutureFactory();
            }
            return new ProgressiveProviderFutureFactory();
        }
        switch (futureType.toLowerCase()) {
            case "conservative": {
                return new ConservativeProviderFutureFactory();
            }
            case "balanced": {
                return new BalancedProviderFutureFactory();
            }
            case "progressive": {
                return new ProgressiveProviderFutureFactory();
            }
        }
        throw new IllegalArgumentException("No ClientFuture implementation with name " + futureType + " found");
    }

    public static <T> Future<T> completedFuture(T result) {
        BalancedClientFuture<T> future = new BalancedClientFuture<T>();
        future.complete(result);
        return future;
    }

    public abstract <V> ClientFuture<V> createFuture();

    public abstract <V> ClientFuture<V> createFuture(ClientSynchronization<V> var1);

    public abstract <V> ClientFuture<V> createUnfailableFuture();

    public abstract <V> ClientFuture<V> createUnfailableFuture(ClientSynchronization<V> var1);

    private static boolean isWindows() {
        return IS_WINDOWS;
    }

    private static boolean isOsNameMatch(String currentOSName, String osNamePrefix) {
        if (currentOSName == null || currentOSName.isEmpty()) {
            return false;
        }
        return currentOSName.startsWith(osNamePrefix);
    }

    private static class ConservativeProviderFutureFactory
    extends ClientFutureFactory {
        private ConservativeProviderFutureFactory() {
        }

        @Override
        public <V> ClientFuture<V> createFuture() {
            return new ConservativeClientFuture();
        }

        @Override
        public <V> ClientFuture<V> createFuture(ClientSynchronization<V> synchronization) {
            return new ConservativeClientFuture<V>(synchronization);
        }

        @Override
        public <V> ClientFuture<V> createUnfailableFuture() {
            return this.createUnfailableFuture(null);
        }

        @Override
        public <V> ClientFuture<V> createUnfailableFuture(ClientSynchronization<V> synchronization) {
            return new ConservativeClientFuture<V>(synchronization){

                @Override
                public void failed(ClientException t) {
                    this.complete(null);
                }
            };
        }
    }

    private static class BalancedProviderFutureFactory
    extends ClientFutureFactory {
        private BalancedProviderFutureFactory() {
        }

        @Override
        public <V> ClientFuture<V> createFuture() {
            return new BalancedClientFuture();
        }

        @Override
        public <V> ClientFuture<V> createFuture(ClientSynchronization<V> synchronization) {
            return new BalancedClientFuture<V>(synchronization);
        }

        @Override
        public <V> ClientFuture<V> createUnfailableFuture() {
            return this.createUnfailableFuture(null);
        }

        @Override
        public <V> ClientFuture<V> createUnfailableFuture(ClientSynchronization<V> synchronization) {
            return new BalancedClientFuture<V>(synchronization){

                @Override
                public void failed(ClientException t) {
                    this.complete(null);
                }
            };
        }
    }

    private static class ProgressiveProviderFutureFactory
    extends ClientFutureFactory {
        private ProgressiveProviderFutureFactory() {
        }

        @Override
        public <V> ClientFuture<V> createFuture() {
            return new ProgressiveClientFuture();
        }

        @Override
        public <V> ClientFuture<V> createFuture(ClientSynchronization<V> synchronization) {
            return new ProgressiveClientFuture<V>(synchronization);
        }

        @Override
        public <V> ClientFuture<V> createUnfailableFuture() {
            return this.createUnfailableFuture(null);
        }

        @Override
        public <V> ClientFuture<V> createUnfailableFuture(ClientSynchronization<V> synchronization) {
            return new ProgressiveClientFuture<V>(synchronization){

                @Override
                public void failed(ClientException t) {
                    this.complete(null);
                }
            };
        }
    }
}

