/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery;

import java.io.IOException;
import java.net.URI;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgent;
import org.apache.qpid.jms.util.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryAgentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryAgentFactory.class);
    private static final FactoryFinder<DiscoveryAgentFactory> AGENT_FACTORY_FINDER = new FactoryFinder(DiscoveryAgentFactory.class, "META-INF/services/org/apache/qpid/jms/provider/agents/");

    public abstract DiscoveryAgent createDiscoveryAgent(URI var1) throws Exception;

    public abstract String getName();

    public static DiscoveryAgent createAgent(URI remoteURI) throws Exception {
        DiscoveryAgent result = null;
        try {
            DiscoveryAgentFactory factory = DiscoveryAgentFactory.findAgentFactory(remoteURI);
            result = factory.createDiscoveryAgent(remoteURI);
        }
        catch (Exception ex) {
            LOG.error("Failed to create DiscoveryAgent instance for: {}", (Object)remoteURI.getScheme());
            LOG.trace("Error: ", (Throwable)ex);
            throw ex;
        }
        return result;
    }

    protected static DiscoveryAgentFactory findAgentFactory(URI location) throws IOException {
        String scheme = location.getScheme();
        if (scheme == null || scheme.isEmpty()) {
            throw new IOException("No Discovery Agent scheme specified.");
        }
        DiscoveryAgentFactory factory = null;
        if (factory == null) {
            try {
                factory = (DiscoveryAgentFactory)AGENT_FACTORY_FINDER.newInstance(scheme);
            }
            catch (Throwable e) {
                throw new IOException("Discovery Agent scheme NOT recognized: [" + scheme + "]", e);
            }
        }
        return factory;
    }
}

