/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.DnsResolverConfig;
import org.apache.pulsar.client.api.EventLoopGroupConfig;
import org.apache.pulsar.client.api.PulsarClientSharedResources;
import org.apache.pulsar.client.api.PulsarClientSharedResourcesBuilder;
import org.apache.pulsar.client.api.ThreadPoolConfig;
import org.apache.pulsar.client.api.TimerConfig;
import org.apache.pulsar.client.impl.PulsarClientSharedResourcesImpl;
import org.apache.pulsar.common.util.netty.DnsResolverUtil;

public class PulsarClientSharedResourcesBuilderImpl
implements PulsarClientSharedResourcesBuilder {
    Set<PulsarClientSharedResources.SharedResource> sharedResources = new HashSet<PulsarClientSharedResources.SharedResource>();
    Map<PulsarClientSharedResources.SharedResource, ResourceConfig> resourceConfigs = new HashMap<PulsarClientSharedResources.SharedResource, ResourceConfig>();
    private boolean shareConfigured;

    public PulsarClientSharedResourcesBuilder resourceTypes(PulsarClientSharedResources.SharedResource ... sharedResource) {
        if (this.shareConfigured) {
            throw new IllegalStateException("Cannot set resourceTypes when shareConfigured() has already been called");
        }
        return this.resourceTypes(List.of(sharedResource));
    }

    public PulsarClientSharedResourcesBuilder resourceTypes(Collection<PulsarClientSharedResources.SharedResource> sharedResource) {
        if (this.shareConfigured) {
            throw new IllegalStateException("Cannot set resourceTypes when shareConfigured() has already been called");
        }
        this.sharedResources.addAll(sharedResource);
        return this;
    }

    public PulsarClientSharedResourcesBuilder shareConfigured() {
        if (!this.sharedResources.isEmpty()) {
            throw new IllegalStateException("Cannot use shareConfigured() when resourceTypes has already been set");
        }
        this.shareConfigured = true;
        return this;
    }

    private <T extends ResourceConfig> T getOrCreateConfig(PulsarClientSharedResources.SharedResource sharedResource) {
        return (T)this.resourceConfigs.computeIfAbsent(sharedResource, k -> {
            switch (sharedResource.getType()) {
                case EventLoopGroup: {
                    return new EventLoopResourceConfig();
                }
                case DnsResolver: {
                    return new DnsResolverResourceConfig();
                }
                case ThreadPool: {
                    return new ThreadPoolResourceConfig();
                }
                case Timer: {
                    return new TimerResourceConfig();
                }
            }
            throw new IllegalArgumentException("Unknown resource type: " + String.valueOf(sharedResource.getType()));
        });
    }

    public PulsarClientSharedResourcesBuilder configureThreadPool(PulsarClientSharedResources.SharedResource sharedResource, Consumer<ThreadPoolConfig<?>> configurer) {
        if (sharedResource.getType() != PulsarClientSharedResources.SharedResourceType.ThreadPool) {
            throw new IllegalArgumentException("The shared resource " + String.valueOf(sharedResource) + " doesn't support thread pool configuration");
        }
        configurer.accept((ThreadPoolConfig)this.getOrCreateConfig(sharedResource));
        return this;
    }

    public PulsarClientSharedResourcesBuilder configureEventLoop(Consumer<EventLoopGroupConfig> configurer) {
        configurer.accept((EventLoopGroupConfig)this.getOrCreateConfig(PulsarClientSharedResources.SharedResource.EventLoopGroup));
        return this;
    }

    public PulsarClientSharedResourcesBuilder configureDnsResolver(Consumer<DnsResolverConfig> configurer) {
        configurer.accept((DnsResolverConfig)this.getOrCreateConfig(PulsarClientSharedResources.SharedResource.DnsResolver));
        return this;
    }

    public PulsarClientSharedResourcesBuilder configureTimer(Consumer<TimerConfig> configurer) {
        configurer.accept((TimerConfig)this.getOrCreateConfig(PulsarClientSharedResources.SharedResource.Timer));
        return this;
    }

    public PulsarClientSharedResources build() {
        return new PulsarClientSharedResourcesImpl(this.sharedResources, this.resourceConfigs, this.shareConfigured);
    }

    static interface ResourceConfig {
    }

    static class EventLoopResourceConfig
    extends NamedResourceConfig<EventLoopGroupConfig>
    implements EventLoopGroupConfig {
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        boolean daemon = Thread.currentThread().isDaemon();
        boolean enableBusyWait;

        EventLoopResourceConfig() {
            this.name = "pulsar-client-io";
        }

        public EventLoopGroupConfig numberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public EventLoopGroupConfig daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public EventLoopGroupConfig enableBusyWait(boolean enableBusyWait) {
            this.enableBusyWait = enableBusyWait;
            return this;
        }
    }

    static class DnsResolverResourceConfig
    implements ResourceConfig,
    DnsResolverConfig {
        InetSocketAddress localAddress;
        Collection<InetSocketAddress> serverAddresses;
        int minTtl = DnsResolverUtil.getDefaultMinTTL();
        int maxTtl = DnsResolverUtil.getDefaultTTL();
        int negativeTtl = DnsResolverUtil.getDefaultNegativeTTL();
        long queryTimeoutMillis = -1L;
        boolean traceEnabled = true;
        boolean tcpFallbackEnabled = true;
        boolean tcpFallbackOnTimeoutEnabled = true;
        int ndots = -1;
        Collection<String> searchDomains;

        DnsResolverResourceConfig() {
        }

        public DnsResolverConfig localAddress(InetSocketAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public DnsResolverConfig serverAddresses(Iterable<InetSocketAddress> addresses) {
            this.serverAddresses = Lists.newArrayList(addresses);
            return this;
        }

        public DnsResolverConfig minTtl(int minTtl) {
            this.minTtl = minTtl;
            return this;
        }

        public DnsResolverConfig maxTtl(int maxTtl) {
            this.maxTtl = maxTtl;
            return this;
        }

        public DnsResolverConfig negativeTtl(int negativeTtl) {
            this.negativeTtl = negativeTtl;
            return this;
        }

        public DnsResolverConfig queryTimeoutMillis(long queryTimeoutMillis) {
            this.queryTimeoutMillis = queryTimeoutMillis;
            return this;
        }

        public DnsResolverConfig traceEnabled(boolean traceEnabled) {
            this.traceEnabled = traceEnabled;
            return this;
        }

        public DnsResolverConfig tcpFallbackEnabled(boolean tcpFallbackEnabled) {
            this.tcpFallbackEnabled = tcpFallbackEnabled;
            return this;
        }

        public DnsResolverConfig tcpFallbackOnTimeoutEnabled(boolean tcpFallbackOnTimeoutEnabled) {
            this.tcpFallbackOnTimeoutEnabled = tcpFallbackOnTimeoutEnabled;
            return this;
        }

        public DnsResolverConfig ndots(int ndots) {
            this.ndots = ndots;
            return this;
        }

        public DnsResolverConfig searchDomains(Iterable<String> searchDomains) {
            this.searchDomains = Lists.newArrayList(searchDomains);
            return this;
        }
    }

    static class ThreadPoolResourceConfig
    extends NamedResourceConfig<ThreadPoolConfig>
    implements ThreadPoolConfig {
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        boolean daemon = Thread.currentThread().isDaemon();

        ThreadPoolResourceConfig() {
        }

        public ThreadPoolConfig numberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public ThreadPoolConfig daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }
    }

    static class TimerResourceConfig
    extends NamedResourceConfig<TimerConfig>
    implements TimerConfig {
        long tickDuration = 1L;
        TimeUnit tickDurationTimeUnit = TimeUnit.MILLISECONDS;

        TimerResourceConfig() {
            this.name = "pulsar-timer";
        }

        public TimerConfig tickDuration(long tickDuration, TimeUnit timeUnit) {
            this.tickDuration = tickDuration;
            this.tickDurationTimeUnit = timeUnit;
            return this;
        }
    }

    static abstract class NamedResourceConfig<T>
    implements ResourceConfig {
        String name;

        NamedResourceConfig() {
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        T self() {
            return (T)this;
        }
    }
}

