/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.examples;

import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessagePayload;
import org.apache.pulsar.client.api.MessagePayloadContext;
import org.apache.pulsar.client.api.MessagePayloadProcessor;
import org.apache.pulsar.client.api.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPayloadProcessor
implements MessagePayloadProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestPayloadProcessor.class);

    public TestPayloadProcessor() {
        log.info("TestPayloadProcessor constructor without configs");
    }

    public TestPayloadProcessor(Map<String, Object> conf) {
        String configs = conf.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
        log.info("TestPayloadProcessor constructor with configs {}", (Object)configs);
    }

    public <T> void process(MessagePayload payload, MessagePayloadContext context, Schema<T> schema, Consumer<Message<T>> messageConsumer) throws Exception {
        log.info("Processing message using TestPayloadProcessor");
        if (context.isBatch()) {
            int numMessages = context.getNumMessages();
            for (int i = 0; i < numMessages; ++i) {
                messageConsumer.accept(context.getMessageAt(i, numMessages, payload, true, schema));
            }
        } else {
            messageConsumer.accept(context.asSingleMessage(payload, schema));
        }
    }
}

