/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.pulsar.broker.service.ConsumerIdentityWrapper;
import org.roaringbitmap.RoaringBitmap;

@NotThreadSafe
class ConsumerNameIndexTracker {
    private final Map<String, ConsumerNameIndexSlots> consumerNameIndexSlotsMap = new HashMap<String, ConsumerNameIndexSlots>();
    private final Map<ConsumerIdentityWrapper, ConsumerEntry> consumerEntries = new HashMap<ConsumerIdentityWrapper, ConsumerEntry>();

    ConsumerNameIndexTracker() {
    }

    public int increaseConsumerRefCountAndReturnIndex(ConsumerIdentityWrapper wrapper) {
        ConsumerEntry entry = this.consumerEntries.computeIfAbsent(wrapper, k -> {
            String consumerName = wrapper.consumer.consumerName();
            return new ConsumerEntry(consumerName, this.allocateConsumerNameIndex(consumerName), new MutableInt(0));
        });
        entry.refCount.increment();
        return entry.nameIndex;
    }

    private int allocateConsumerNameIndex(String consumerName) {
        return this.getConsumerNameIndexBitmap(consumerName).allocateIndexSlot();
    }

    private ConsumerNameIndexSlots getConsumerNameIndexBitmap(String consumerName) {
        return this.consumerNameIndexSlotsMap.computeIfAbsent(consumerName, k -> new ConsumerNameIndexSlots());
    }

    public void decreaseConsumerRefCount(ConsumerIdentityWrapper removed) {
        ConsumerEntry consumerEntry = this.consumerEntries.get(removed);
        int refCount = consumerEntry.refCount.decrementAndGet();
        if (refCount == 0) {
            this.deallocateConsumerNameIndex(consumerEntry.consumerName, consumerEntry.nameIndex);
            this.consumerEntries.remove(removed, consumerEntry);
        }
    }

    private void deallocateConsumerNameIndex(String consumerName, int index) {
        if (this.getConsumerNameIndexBitmap(consumerName).deallocateIndexSlot(index)) {
            this.consumerNameIndexSlotsMap.remove(consumerName);
        }
    }

    public int getTrackedIndex(ConsumerIdentityWrapper wrapper) {
        ConsumerEntry consumerEntry = this.consumerEntries.get(wrapper);
        return consumerEntry != null ? consumerEntry.nameIndex : -1;
    }

    int getTrackedConsumerNamesCount() {
        return this.consumerNameIndexSlotsMap.size();
    }

    int getTrackedConsumersCount() {
        return this.consumerEntries.size();
    }

    record ConsumerEntry(String consumerName, int nameIndex, MutableInt refCount) {
    }

    static class ConsumerNameIndexSlots {
        private RoaringBitmap indexSlots = new RoaringBitmap();

        ConsumerNameIndexSlots() {
        }

        public int allocateIndexSlot() {
            int index = (int)this.indexSlots.nextAbsentValue(0);
            if (index == -1) {
                index = this.indexSlots.getCardinality();
            }
            this.indexSlots.add(index);
            return index;
        }

        public boolean deallocateIndexSlot(int index) {
            this.indexSlots.remove(index);
            return this.indexSlots.isEmpty();
        }
    }
}

