/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.semaphore;

import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiterUtil;

public interface AsyncDualMemoryLimiter {
    public CompletableFuture<AsyncDualMemoryLimiterPermit> acquire(long var1, LimitType var3, BooleanSupplier var4);

    public CompletableFuture<AsyncDualMemoryLimiterPermit> update(AsyncDualMemoryLimiterPermit var1, long var2, BooleanSupplier var4);

    public void release(AsyncDualMemoryLimiterPermit var1);

    default public <T> CompletableFuture<T> withAcquiredPermits(long memorySize, LimitType limitType, BooleanSupplier isCancelled, Function<AsyncDualMemoryLimiterPermit, CompletableFuture<T>> function, Function<Throwable, CompletableFuture<T>> permitAcquireErrorHandler) {
        return AsyncDualMemoryLimiterUtil.withPermitsFuture(this.acquire(memorySize, limitType, isCancelled), function, permitAcquireErrorHandler, this::release);
    }

    default public <T> CompletableFuture<T> withUpdatedPermits(AsyncDualMemoryLimiterPermit initialPermit, long newMemorySize, BooleanSupplier isCancelled, Function<AsyncDualMemoryLimiterPermit, CompletableFuture<T>> function, Function<Throwable, CompletableFuture<T>> permitAcquireErrorHandler) {
        return AsyncDualMemoryLimiterUtil.withPermitsFuture(this.update(initialPermit, newMemorySize, isCancelled), function, permitAcquireErrorHandler, this::release);
    }

    public static enum LimitType {
        HEAP_MEMORY,
        DIRECT_MEMORY;

    }

    public static interface AsyncDualMemoryLimiterPermit {
        public long getPermits();

        public LimitType getLimitType();
    }
}

