/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUtils
extends ZooKeeperClusterTestCase {
    private static final int sessionTimeoutMs = 30000;
    private ZooKeeperClient zkc;

    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().name("zkc").uri(DLMTestUtil.createDLMURI(zkPort, "/")).sessionTimeoutMs(30000).build();
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
    }

    @Test(timeout=60000L)
    public void testZkAsyncCreateFulPathOptimisticRecursive() throws Exception {
        String path1 = "/a/b/c/d";
        Optional<Object> parentPathShouldNotCreate = Optional.empty();
        final CountDownLatch doneLatch1 = new CountDownLatch(1);
        Utils.zkAsyncCreateFullPathOptimisticRecursive((ZooKeeperClient)this.zkc, (String)path1, parentPathShouldNotCreate, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT, (AsyncCallback.StringCallback)new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                doneLatch1.countDown();
            }
        }, null);
        doneLatch1.await();
        Assert.assertNotNull((Object)this.zkc.get().exists(path1, false));
        String path2 = "/a/b/c/d/e/f/g";
        parentPathShouldNotCreate = Optional.of("/a/b/c/d/e");
        final CountDownLatch doneLatch2 = new CountDownLatch(1);
        Utils.zkAsyncCreateFullPathOptimisticRecursive((ZooKeeperClient)this.zkc, (String)path2, parentPathShouldNotCreate, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT, (AsyncCallback.StringCallback)new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                doneLatch2.countDown();
            }
        }, null);
        doneLatch2.await();
        Assert.assertNull((Object)this.zkc.get().exists("/a/b/c/d/e", false));
        Assert.assertNull((Object)this.zkc.get().exists("/a/b/c/d/e/f", false));
        Assert.assertNull((Object)this.zkc.get().exists("/a/b/c/d/e/f/g", false));
        parentPathShouldNotCreate = Optional.of("/a/b");
        final CountDownLatch doneLatch3 = new CountDownLatch(1);
        Utils.zkAsyncCreateFullPathOptimisticRecursive((ZooKeeperClient)this.zkc, (String)path2, parentPathShouldNotCreate, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT, (AsyncCallback.StringCallback)new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                doneLatch3.countDown();
            }
        }, null);
        doneLatch3.await();
        Assert.assertNotNull((Object)this.zkc.get().exists(path2, false));
    }

    @Test(timeout=60000L)
    public void testZkGetData() throws Exception {
        String path1 = "/zk-get-data/non-existent-path";
        Versioned data = (Versioned)Utils.ioResult((CompletableFuture)Utils.zkGetData((ZooKeeper)this.zkc.get(), (String)path1, (boolean)false));
        Assert.assertNull((String)"No data should return from non-existent-path", (Object)data.getValue());
        Assert.assertNull((String)"No version should return from non-existent-path", (Object)data.getVersion());
        String path2 = "/zk-get-data/path2";
        byte[] rawData = "test-data".getBytes(StandardCharsets.UTF_8);
        Utils.ioResult((CompletableFuture)Utils.zkAsyncCreateFullPathOptimistic((ZooKeeperClient)this.zkc, (String)path2, (byte[])rawData, (List)this.zkc.getDefaultACL(), (CreateMode)CreateMode.PERSISTENT));
        data = (Versioned)Utils.ioResult((CompletableFuture)Utils.zkGetData((ZooKeeper)this.zkc.get(), (String)path2, (boolean)false));
        Assert.assertArrayEquals((String)"Data should return as written", (byte[])rawData, (byte[])((byte[])data.getValue()));
        Assert.assertEquals((String)"Version should be zero", (long)0L, (long)((LongVersion)data.getVersion()).getLongVersion());
    }

    @Test(timeout=60000L)
    public void testGetParent() throws Exception {
        String path1 = null;
        Assert.assertNull((String)"parent of a null path is null", (Object)Utils.getParent(path1));
        String path2 = "";
        Assert.assertNull((String)"parent of an empty string is null", (Object)Utils.getParent((String)path2));
        String path3 = "abcdef";
        Assert.assertNull((String)"parent of a string with no / is null", (Object)Utils.getParent((String)path3));
        String path4 = "/test/test2";
        Assert.assertEquals((String)"parent of a /test/test2 is /test", (Object)"/test", (Object)Utils.getParent((String)path4));
        String path5 = "/test/test2/";
        Assert.assertEquals((String)("parent of a " + path5 + " is /test"), (Object)"/test", (Object)Utils.getParent((String)path5));
        String path6 = "/test";
        Assert.assertEquals((String)("parent of " + path6 + " is /"), (Object)"/", (Object)Utils.getParent((String)path6));
        String path7 = "//";
        Assert.assertEquals((String)("parent of " + path7 + " is /"), (Object)"/", (Object)Utils.getParent((String)path7));
        String path8 = "/";
        Assert.assertNull((String)("parent of " + path8 + " is null"), (Object)Utils.getParent((String)path8));
    }
}

