---
layout: news_item
title: "ORC 2.2.0 Released"
date: "2025-07-29 03:00:00 -0800"
author: william
version: 2.2.0
categories: [release]
---

The ORC team is excited to announce the release of ORC v2.2.0.

{% assign releaseName = "2.2.0" %}
{% include release_description.md %}

The new features:
- [ORC-1903]({{site.jira}}/ORC-1903): Support `Geometry` and `Geography` types 
- [ORC-1920]({{site.jira}}/ORC-1920): [C++] Support `Geometry` and `Geography` types
- [ORC-1884]({{site.jira}}/ORC-1884): [C++] Add the maybe() function to the SearchArgumentBuilder
- [ORC-1906]({{site.jira}}/ORC-1906): Support `Meson` build

The improvements:
- [ORC-1838]({{site.jira}}/ORC-1838): Bump `opencsv` to 5.10
- [ORC-1841]({{site.jira}}/ORC-1841): [C++] Add UBSAN to CI
- [ORC-1848]({{site.jira}}/ORC-1848): PrintData tool add parameter description
- [ORC-1858]({{site.jira}}/ORC-1858): Add a c++ api that only get stripe level statistics without reading row group index
- [ORC-1880]({{site.jira}}/ORC-1880): [C++] Add invalid argument check for NOT Operator in ExpressionTree
- [ORC-1894]({{site.jira}}/ORC-1894): Add `CMAKE_POLICY_VERSION_MINIMUM=3.12` to `PROTOBUF_CMAKE_ARGS`
- [ORC-1905]({{site.jira}}/ORC-1905): Upgrade Maven to 3.9.10
- [ORC-1931]({{site.jira}}/ORC-1931): Suppress Hadoop logs lower than ERROR level in `orc-tools`
- [ORC-1932]({{site.jira}}/ORC-1932): Use `setIfUnset` for `fs.defaultFS` and `fs.file.impl.disable.cache`
- [ORC-1933]({{site.jira}}/ORC-1933): Change `org.jetbrains:annotations` dependency to the `provided` scope
- [ORC-1936]({{site.jira}}/ORC-1936): Get example and build dir for tools test from Build System instead of gtest
- [ORC-1937]({{site.jira}}/ORC-1937): Use the default `buildtype` in Meson config
- [ORC-1938]({{site.jira}}/ORC-1938): Update `tools` module to set `fs.file.impl.disable.cache` only for Java 22+
- [ORC-1946]({{site.jira}}/ORC-1946): [C++] Fix the issue discovered by UBSAN.
- [ORC-1950]({{site.jira}}/ORC-1950): [C++] Replace std::unorder_map with google dense_hash_map in SortedStringDictionary and remove reorder to improve write performance of dict-encoding columns
- [ORC-1961]({{site.jira}}/ORC-1961): Support `orc.compression.zstd.strategy`

The bug fixes:
- [ORC-1833]({{site.jira}}/ORC-1833): [C++] Fix CMake script to be used inside another project 
- [ORC-1835]({{site.jira}}/ORC-1835): [C++] Fix cpp-linter-action to build first
- [ORC-1836]({{site.jira}}/ORC-1836): Upgrade `zstd-jni` to 1.5.6-9
- [ORC-1846]({{site.jira}}/ORC-1846): [C++] Fix imported libraries in the Conan build
- [ORC-1851]({{site.jira}}/ORC-1851): Upgrade `zstd-jni` to 1.5.6-10
- [ORC-1853]({{site.jira}}/ORC-1853): Rename class `TesScanData` to `TestScanData`
- [ORC-1854]({{site.jira}}/ORC-1854): Remove `ubuntu20` from `os-list.txt`
- [ORC-1863]({{site.jira}}/ORC-1863): Upgrade `slf4j` to 2.0.17
- [ORC-1865]({{site.jira}}/ORC-1865): Upgrade `zstd-jni` to 1.5.7-2
- [ORC-1866]({{site.jira}}/ORC-1866): Avoid zlib decompression infinite loop
- [ORC-1876]({{site.jira}}/ORC-1876): Upgrade to ORC Format 1.1
- [ORC-1879]({{site.jira}}/ORC-1879): Fix Heap Buffer Overflow in LZO Decompression
- [ORC-1881]({{site.jira}}/ORC-1881): [C++] The decimal scale and precision become zero in ColumnVectorBatch when converting between decimal types.
- [ORC-1892]({{site.jira}}/ORC-1892): Upgrade `snappy` to 1.2.2
- [ORC-1893]({{site.jira}}/ORC-1893): Upgrade `zstd` to 1.5.7
- [ORC-1898]({{site.jira}}/ORC-1898): When column is all null, NULL_SAFE_EQUALS pushdown doesn't get evaluated correctly
- [ORC-1929]({{site.jira}}/ORC-1929): Fix the Javadoc of `ZstdCodec.compress`
- [ORC-1934]({{site.jira}}/ORC-1934): Upgrade `protobuf-java` to 3.25.8
- [ORC-1939]({{site.jira}}/ORC-1939): TimestampFrom...TreeReader should set isUTC flag in TimestampColumnVector
- [ORC-1940]({{site.jira}}/ORC-1940): Meson configuration should add thread dependency to orc lib
- [ORC-1942]({{site.jira}}/ORC-1942): Fix `PhysicalFsWriter` to change `tempOptions` directly
- [ORC-1948]({{site.jira}}/ORC-1948): Fix GeospatialTreeWriter#writeBatch updating ColumnStatistics with incorrect values
- [ORC-1952]({{site.jira}}/ORC-1952): [C++] Fix the issue where the value of headerThirdByte exceeds the valid byte range
- [ORC-1954]({{site.jira}}/ORC-1954): Fix CI asan-test
- [ORC-1957]({{site.jira}}/ORC-1957): Upgrade `zstd-jni` to 1.5.7-4

The test changes:
- [ORC-1839]({{site.jira}}/ORC-1839): Upgrade `spotless-maven-plugin` to 2.44.1
- [ORC-1842]({{site.jira}}/ORC-1842): Upgrade `commons-csv` to 1.13.0
- [ORC-1844]({{site.jira}}/ORC-1844): Upgrade `spotless-maven-plugin` to 2.44.2
- [ORC-1847]({{site.jira}}/ORC-1847): Upgrade `Hive` to 4.0.1 in bench module
- [ORC-1849]({{site.jira}}/ORC-1849): Upgrade `byte-buddy` to 1.17.0
- [ORC-1850]({{site.jira}}/ORC-1850): Upgrade `maven-surefire-plugin` to 3.5.2
- [ORC-1855]({{site.jira}}/ORC-1855): Add `Amazon Linux 2023` and `Corretto` to docker tests and CI
- [ORC-1856]({{site.jira}}/ORC-1856): Bump `spotbugs-maven-plugin` to 4.9.1.0
- [ORC-1857]({{site.jira}}/ORC-1857): Bump `checkstyle` to 10.21.2
- [ORC-1859]({{site.jira}}/ORC-1859): Upgrade `junit` to 5.12.0
- [ORC-1860]({{site.jira}}/ORC-1860): Upgrade `spotless-maven-plugin` to 2.44.3
- [ORC-1861]({{site.jira}}/ORC-1861): Upgrade `junit` to 5.12.1
- [ORC-1862]({{site.jira}}/ORC-1862): Upgrade `spotbugs-maven-plugin` to `4.9.3.0`
- [ORC-1864]({{site.jira}}/ORC-1864): Upgrade `checkstyle` to 10.21.4
- [ORC-1867]({{site.jira}}/ORC-1867): Upgrade `commons-csv` to 1.14.0 in `bench` module
- [ORC-1868]({{site.jira}}/ORC-1868): Upgrade `parquet` to 1.15.1 in `bench` module
- [ORC-1871]({{site.jira}}/ORC-1871): Include `iomanip` at `Test(DictionaryEncoding|ConvertColumnReader)`
- [ORC-1872]({{site.jira}}/ORC-1872): Upgrade `extra-enforcer-rules` to 1.10.0
- [ORC-1875]({{site.jira}}/ORC-1875): Support `ubuntu-24.04-arm` in GitHub Action CIs
- [ORC-1882]({{site.jira}}/ORC-1882): Upgrade spotless-maven-plugin to 2.44.4
- [ORC-1883]({{site.jira}}/ORC-1883): Upgrade `checkstyle` to 10.23.0
- [ORC-1886]({{site.jira}}/ORC-1886): Upgrade `junit` to 5.12.2
- [ORC-1887]({{site.jira}}/ORC-1887): Upgrade `checkstyle` to 10.23.1
- [ORC-1889]({{site.jira}}/ORC-1889): Upgrade `parquet` to `1.15.2`
- [ORC-1899]({{site.jira}}/ORC-1899): Upgrade Spark to 4.0.0 and Scala to 2.13.16
- [ORC-1900]({{site.jira}}/ORC-1900): Upgrade `Jackson` to 2.18.2 in bench module
- [ORC-1901]({{site.jira}}/ORC-1901): Remove `threeten-extra` exclusion in `enforceBytecodeVersion` rule
- [ORC-1904]({{site.jira}}/ORC-1904): Upgrade `checkstyle` to 10.25.0
- [ORC-1907]({{site.jira}}/ORC-1907): Upgrade `byte-buddy` to 1.17.5
- [ORC-1908]({{site.jira}}/ORC-1908): Add `--enable-native-access=ALL-UNNAMED` to Surefire argLine
- [ORC-1909]({{site.jira}}/ORC-1909): Remove unused test resource `log4j.properties` files
- [ORC-1910]({{site.jira}}/ORC-1910): Add `-XX:+EnableDynamicAgentLoading` to Surefire argLine
- [ORC-1911]({{site.jira}}/ORC-1911): Update CIs to use `actions/checkout@v4` consistently
- [ORC-1913]({{site.jira}}/ORC-1913): Fix `TestColumnStatistics` to set `testFilePath` with absolute path
- [ORC-1915]({{site.jira}}/ORC-1915): Remove `Fedora 35` Support
- [ORC-1916]({{site.jira}}/ORC-1916): Add Java `25-ea` build CI
- [ORC-1917]({{site.jira}}/ORC-1917): Add `TestConf` interface to centralize test configurations
- [ORC-1918]({{site.jira}}/ORC-1918): Add Java `25-ea` test coverage for `shims` and `core` modules
- [ORC-1923]({{site.jira}}/ORC-1923): Remove `Windows 2019` GitHub Action job
- [ORC-1925]({{site.jira}}/ORC-1925): Add `oraclelinux8` to docker tests and GitHub Action
- [ORC-1926]({{site.jira}}/ORC-1926): Use `TestConf` interface in `tools` module
- [ORC-1927]({{site.jira}}/ORC-1927): Add Java `25-ea` test coverage for `tools` modules
- [ORC-1930]({{site.jira}}/ORC-1930): Improve `GenerateVariants` to accept ORC configs via system properties
- [ORC-1935]({{site.jira}}/ORC-1935): Upgrade `checkstyle` to 10.25.1
- [ORC-1941]({{site.jira}}/ORC-1941): Upgrade `checkstyle` to 10.26.1
- [ORC-1943]({{site.jira}}/ORC-1943): Add `com.google.protobuf.use_unsafe_pre22_gencode` to Surefire testing
- [ORC-1944]({{site.jira}}/ORC-1944): Upgrade `spotbugs` to 4.9.3
- [ORC-1947]({{site.jira}}/ORC-1947): Upgrade `maven-enforcer-plugin` to 3.6.0
- [ORC-1953]({{site.jira}}/ORC-1953): Upgrade `commons-lang3` to 3.18.0
- [ORC-1955]({{site.jira}}/ORC-1955): Make `commons-lang3` as a test dependency explicitly
- [ORC-1956]({{site.jira}}/ORC-1956): Enable GitHub Action CI in `branch-2.2`
- [ORC-1959]({{site.jira}}/ORC-1959): Add test String statistics with Presto writer

Tasks
- [ORC-1837]({{site.jira}}/ORC-1837): Remove `commons-csv` from parent `pom.xml`
- [ORC-1852]({{site.jira}}/ORC-1852): Add `--enable-native-access=ALL-UNNAMED` to suppress Maven warnings
- [ORC-1877]({{site.jira}}/ORC-1877): Upgrade `gson` to 2.13.0
- [ORC-1902]({{site.jira}}/ORC-1902): Use `super-linter` for `README.md` files
- [ORC-1914]({{site.jira}}/ORC-1914): Ensure `Annotation Processing` in `core` module compilation
- [ORC-1919]({{site.jira}}/ORC-1919): Update `.asf.yaml` with new `README.md` link
- [ORC-1928]({{site.jira}}/ORC-1928): Upgrade `junit` to 5.13.1
- [ORC-1945]({{site.jira}}/ORC-1945): Update Python documentation with PyArrow 20.0.0 and Dask 2025.5.1
- [ORC-1958]({{site.jira}}/ORC-1958): Upgrade Maven to 3.9.11
- [ORC-1962]({{site.jira}}/ORC-1962): Fix `publish_snapshot.yml` in `branch-2.2` to publish
