/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.OutputStream;
import java.io.PrintStream;
import opennlp.tools.cmdline.EvaluationErrorPrinter;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.log.LogPrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageDetectorEvaluationErrorListener
extends EvaluationErrorPrinter<LanguageSample>
implements LanguageDetectorEvaluationMonitor {
    private static final Logger logger = LoggerFactory.getLogger(LanguageDetectorEvaluationErrorListener.class);

    public LanguageDetectorEvaluationErrorListener() {
        super((PrintStream)new LogPrintStream(logger));
    }

    public LanguageDetectorEvaluationErrorListener(OutputStream outputStream) {
        super(outputStream);
        this.printStream.println("Expected\tPredicted\tContext");
    }

    @Override
    public void misclassified(LanguageSample reference, LanguageSample prediction) {
        this.printError(reference, prediction);
    }

    @Override
    protected void printError(LanguageSample referenceSample, LanguageSample predictedSample) {
        this.printStream.println(String.join((CharSequence)"\t", referenceSample.language().getLang(), predictedSample.language().getLang(), referenceSample.context()));
    }
}

